<?php

class Antrean extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('api_bpjs_model');
		$this->load->model('data_pasien_model');
		$this->load->model('mjkn_model');

		$this->url_controller = $this->uri->segment(1);
	}

	public function index()
	{
		$header  = apache_request_headers();
		$konten = trim(file_get_contents("php://input"));
		$decode = json_decode($konten, true);

		$cek_token = $this->mjkn_model->cek_token($header);

		if($cek_token == FALSE)
		{
			$data['response'] = $cek_token;
		}
		else
		{		
			$decode['data_pasien'] = (array) $this->data_pasien_model->lihat_from_nik_nokartu($decode);

			if(!empty($decode['data_pasien']))
			{
				$data['response'] = $this->mjkn_model->ambil_antrian($decode);
			}
			else
			{
				$context  = array(
					'service_name' => 'peserta',
					'jnsKartu' => 'noka',
					'keyword' => $decode['nomorkartu'],
					'data' => array()
				);

				$data_peserta = $this->api_bpjs_model->get($context);

				if($data_peserta['metaData']['code'] == '200')
				{
					$context  = array(
						'auto_id' => 'on',
						'nama' => $data_peserta['result']['nama'],
						'nik' => $data_peserta['result']['noKTP'],
						'jenis_kelamin' => $data_peserta['result']['sex'],
						'tgl_lahir' => $data_peserta['result']['tglLahir'],
						'alamat' => '-',
						'propinsi' => '-',
						'kabupaten' => '-',
						'kecamatan' => '-',
						'kelurahan' => '-',
						'no_bpjs' => $decode['nomorkartu'],
						'no_hp' => $data_peserta['result']['noHP'],
					);

					$tambah_pasien = $this->data_pasien_model->add_data($context);

					if($tambah_pasien['eror'] == 'success')
					{
						$decode['data_pasien'] = (array) $this->data_pasien_model->lihat_from_nik_nokartu($decode);

						$data['response'] = $this->mjkn_model->ambil_antrian($decode);
					}
				}
				
			}			
		}
		
		$this->load->view('mjkn/page', $data);
	}

	public function status()
	{		
		$header = apache_request_headers();

		$cek_token = $this->mjkn_model->cek_token($header);

		$context  = array(
			'kode_poli' => $this->uri->segment(3),
			'tanggalperiksa' => $this->uri->segment(4)
		);

		if($cek_token == FALSE)
		{
			$data['response'] = $cek_token;
		}
		else $data['response'] = $this->mjkn_model->status_antrian($context);

		$this->load->view('mjkn/page', $data);
	}

	public function sisapeserta()
	{
		$header = apache_request_headers();

		$cek_token = $this->mjkn_model->cek_token($header);

		$context  = array(
			'nomorkartu_jkn' => $this->uri->segment(4),
			'kode_poli' => $this->uri->segment(5),
			'tanggalperiksa' => $this->uri->segment(6)
		);

		if($cek_token == FALSE)
		{
			$data['response'] = $cek_token;
		}
		else $data['response'] = $this->mjkn_model->sisa_antrian($context);

		$this->load->view('mjkn/page', $data);

	}

	public function batal()
	{
		$header = apache_request_headers();
		$konten = trim(file_get_contents("php://input"));
		$decode = json_decode($konten, true);

		$cek_token = $this->mjkn_model->cek_token($header);

		if($cek_token == FALSE)
		{
			$data['response'] = $cek_token;
		}
		else $data['response'] = $this->mjkn_model->batal_antrian($decode);

		$this->load->view('mjkn/page', $data);
	}
}

?>