<?php

class Api_icare extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('api_icare_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{					
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function get()
	{					
		$context  = $this->input->post();

		$param = $context['no_bpjs'];

		$get_bpjs = $this->api_icare_model->get_content($param);

		if($get_bpjs['eror'] == 'warning') 
		{
			$query = array(
				'eror' => 'warning', 
				'pesan' => $get_bpjs['pesan'],
				'data' => $get_bpjs
			);
		}
		else 
		{
			$query = array(
				'eror' => 'success', 
				'pesan' => 'Get data berhasil',
				'data' => $get_bpjs
			);
		}

		echo json_encode($query);
	}
}

?>