<?php

class Asset_bpjs_bridging extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('api_bpjs_model');
		$this->load->model('asset_bpjs_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{					
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{					
		$data = [
			'data' => $this->asset_bpjs_model->select_data()
		];	

		$this->load->view($this->url_controller.'/page', $data);
	}	

	public function tabel()
	{
		$context  = array(
			'table_name' => 'bpjs_asset_'.$this->input->post('asset')
		);

		$data = [
			'data' => $this->asset_bpjs_model->tabel_data($context),
		];

		$this->load->view($this->url_controller.'/tabel', $data);
	}

	public function update()
	{	
		print_r($this->input->post());

		$context  = array(
			'table_name' => 'bpjs_asset_'.$this->input->post('asset'),
			'bpjs' => $this->api_bpjs_model->get(['service_name' => $this->input->post('asset')])
		);

		$query = $this->asset_bpjs_model->update_data($context);
		echo json_encode($query);
	}

	public function update_2()
	{	
		$asset = $this->input->post('asset');

		if($asset == 'subspesialis')
		{
			$context  = array('table_name' => 'bpjs_asset_spesialis');
			$data = $this->asset_bpjs_model->tabel_data($context);

			foreach($data['result'] as $key) 
			{
				$context  = array(
					'table_name' => 'bpjs_asset_'.$asset,
					'bpjs' => $this->api_bpjs_model->get(['service_name' => $asset, 'kdSpesialis' => $key->kdSpesialis])
				);

				$query = $this->asset_bpjs_model->update_data($context);
			}
		}

		if(!isset($query)) $query = array('eror' => 'warning', 'pesan' => 'Tidak ada data!');
		
		echo json_encode($query);
	}

	public function select()
	{	
		$context  = array(
			'table_name' => 'bpjs_asset_'.$this->input->post('asset'),
			'bpjs' => $this->api_bpjs_model->get(['service_name' => $this->input->post('asset')])
		);

		$query = $this->asset_bpjs_model->update_data($context);
		echo json_encode($query);
	}

	public function select_2()
	{	
		$context  = array(
			'table_name' => 'bpjs_asset_'.$this->input->post('asset')
		);

		$query = $this->asset_bpjs_model->tabel_data_2($this->input->post()); 
		echo json_encode($query);
	}

}

?>