<?php

class Asset_satusehat extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('api_satusehat_model');
		$this->load->model('asset_satusehat_model');
		$this->load->model('data_dokter_model');
		$this->load->model('satusehat_mapping_lokasi_model');
		$this->load->model('satusehat_mapping_organisasi_model');
		$this->load->model('pengaturan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{					
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{	
		$data = [
			'pengaturan' => $this->pengaturan_model->tabel_data(),
			'select_dokter' => $this->data_dokter_model->select_data(),
			'url_form' => $this->url_controller.'/add_update'
		];

		$this->load->view($this->url_controller.'/page', $data);
	}	

	public function tabel()
	{	
		$context = $this->input->post();

		$data['url_form'] = $this->url_controller.'/add';

		switch($context['table_name']) 
		{
			case 'mapping_praktisi':
			$data['select_dokter'] = $this->data_dokter_model->select_data();
			$data['data'] = $this->data_dokter_model->tabel_all();
			break;

			case 'mapping_organisasi':
			$data['data'] = $this->satusehat_mapping_organisasi_model->tabel_data();
			break;

			case 'mapping_lokasi':
			$data['data'] = $this->satusehat_mapping_lokasi_model->tabel_data();
			break;
		}

		if(isset($data['data'])) $this->load->view($this->url_controller.'/tabel_'.$context['table_name'], $data);
	}	

	public function get()
	{		
		$context = $this->input->post();

		$response = $this->api_satusehat_model->get($context); 
		
		$data['data'] = $response;

		$this->load->view($this->url_controller.'/tabel_'.$context['table_name'], $data);
	}

	public function get_update()
	{		
		$context = $this->input->post();

		$response = $this->api_satusehat_model->get($context);

		switch($context['table_name']) 
		{
			case 'mapping_praktisi':
			$response = $this->data_dokter_model->update_satusehat($response);
			break;

			case 'mapping_organisasi':
			$response = $this->satusehat_mapping_organisasi_model->add_update($response);
			break;

			case 'mapping_lokasi':
			$response = $this->satusehat_mapping_lokasi_model->add_update($response);
			break;
		}		

		echo json_encode($response);
	}

	public function add_update()
	{		
		$context = $this->input->post();

		if(isset($context['id']))
		{		
			if($context['id'] == '')
			{
				$response = $this->api_satusehat_model->post($context);
			}
			else $response = $this->api_satusehat_model->put($context);
		}
		else $response = $this->api_satusehat_model->post($context);

		if(!isset($response['eror']))
		{
			switch($context['table_name']) 
			{
				case 'mapping_organisasi':
				$response = $this->satusehat_mapping_organisasi_model->add_update($response);
				break;

				case 'mapping_lokasi':
				$response = $this->satusehat_mapping_lokasi_model->add_update($response);
				break;
			}	
		}	

		echo json_encode($response);
	}

	public function delete()
	{					
		$context = $this->input->post();

		switch($context['table_name'])
		{			
			case 'mapping_organisasi':
			$context['service_name'] = 'organization';
			break;

			case 'mapping_lokasi':
			$context['service_name'] = 'location';
			break;

			case 'mapping_praktisi':
			$response = $this->data_dokter_model->delete_satusehat($context);
			break;

			case 'mapping_organisasi':
			$response = $this->satusehat_mapping_organisasi_model->update_status($context);
			break;

			case 'mapping_lokasi':
			$response = $this->satusehat_mapping_lokasi_model->update_status($context);
			break;
		}		
		

		if(isset($context['service_name']))
		{
			$response = $this->api_satusehat_model->patch($context);
		}

		echo json_encode($response);
	}
}

?>