<?php

class Cari_rujukan extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('api_bpjs_model');
		$this->load->model('asset_bpjs_model');
		$this->load->model('data_dokter_model');
		$this->load->model('data_pendaftaran_model');
		$this->load->model('data_pemeriksaan_model');
		$this->load->model('data_pasien_model');
		$this->load->model('pengaturan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{		
		$data = [
			'url_form' => $this->url_controller.'/tabel',
			'noKartu' => $this->input->post('noKartu'),
			'select_spesialis' => $this->asset_bpjs_model->select_tabel('bpjs_asset_spesialis'),
			'select_sarana' => $this->asset_bpjs_model->select_tabel('bpjs_asset_sarana'),
			'select_spesialis_khusus' => $this->asset_bpjs_model->select_tabel('bpjs_asset_spesialis_khusus')
		];

		$this->load->view($this->url_controller.'/form', $data);
	}	

	public function tabel()
	{	
		$post = $this->input->post();

		if($post['rujukan'] == 'spesialis') 
		{
			$context  = array(
				'service_name' => 'rujukan_subspesialis',
				'kdSubSpesialis' => $this->input->post('subspesialis'),
				'kdSarana' => $this->input->post('sarana'),
				'tglEstRujuk' => $this->input->post('tglEstRujuk')
			);
		}
		elseif($post['rujukan'] == 'khusus')
		{
			if(in_array($post['spesialis_khusus'],['THA','HEM']))
			{
				$context  = array(
					'service_name' => 'rujukan_khusus_2',
					'noKartu' => $post['noKartu'],
					'kdKhusus' => $post['spesialis_khusus'],
					'kdSubSpesialis' => $post['subspesialis_khusus'],
					'tglEstRujuk' => $post['tglEstRujuk']
				);
			} 
			else
			{
				$context  = array(
					'service_name' => 'rujukan_khusus_1',
					'noKartu' => $post['noKartu'],
					'kdKhusus' => $post['spesialis_khusus'],
					'tglEstRujuk' => $post['tglEstRujuk']
				);
			}
		}
		
		$query = $this->api_bpjs_model->get($context);
		echo json_encode($query);
	}
}

?>