<?php

class Dashboard extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}		

		$this->load->model('dashboard_model');
		
		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{	
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{					
		$data = [
			'select_tahun' => $this->dashboard_model->select_tahun()
		];

		$this->load->view('home/page', $data);
	}	

	public function tabel()
	{	
		$context = $this->input->post();

		$data['pendaftaran'] = $this->dashboard_model->pendaftaran_per_debitur($context);
		
		$this->load->view('home/tabel', $data);
	}

}

?>