<?php

class Data_bpjs extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('api_bpjs_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{					
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{					
		$data = [
			'url_form' => $this->url_controller.'/tabel',
		];	

		$this->load->view($this->url_controller.'/page', $data);
	}	

	public function tabel_post_service()
	{
		$context = $this->input->post();

		$get_bpjs = $this->api_bpjs_model->add($context);
		
		if($get_bpjs['eror'] == 'warning') 
		{
			$query = array(
				'eror' => 'warning', 
				'pesan' => $get_bpjs['pesan']
			);
		}
		else 
		{
			$query = array(
				'eror' => 'success', 
				'pesan' => 'Get data berhasil',
				'data' => $this->load->view($this->url_controller.'/tabel_'.$context['service_name'], $get_bpjs, true)
			);
		}

		echo json_encode($query);
	}

	public function tabel_service()
	{
		$context = $this->input->post();

		$get_bpjs = $this->api_bpjs_model->get($context);

		if($get_bpjs['eror'] == 'warning') 
		{
			$query = array(
				'eror' => 'warning', 
				'pesan' => $get_bpjs['pesan']
			);
		}
		else 
		{
			$query = array(
				'eror' => 'success', 
				'pesan' => 'Get data berhasil',
				'data' => $this->load->view($this->url_controller.'/tabel_'.$context['service_name'], $get_bpjs, true)
			);
		}

		echo json_encode($query);
	}

	public function print_service()
	{
		$context = $this->input->post(); 

		$get_bpjs = $this->api_bpjs_model->get($context);
		
		if($get_bpjs['eror'] == 'warning') 
		{
			$query = array(
				'eror' => 'warning', 
				'pesan' => $get_bpjs['pesan']
			);
		}
		else 
		{
			$query = array(
				'eror' => 'success', 
				'pesan' => 'Get data berhasil',
				'data' => $this->load->view($this->url_controller.'/print_'.$context['service_name'], $get_bpjs, true)
			);
		}

		echo json_encode($query);
	}

	public function tabel_get_loop()
	{
		$context  = $this->input->post();

		$get_bpjs = $this->api_bpjs_model->get_loop($context);

		if($get_bpjs['eror'] == 'warning') 
		{
			$query = array(
				'eror' => 'warning', 
				'pesan' => $get_bpjs['pesan']
			);
		}
		else 
		{
			$query = array(
				'eror' => 'success', 
				'pesan' => 'Get data berhasil',
				'data' => $this->load->view($this->url_controller.'/tabel', $get_bpjs, true)
			);
		}

		echo json_encode($query);
	}

	public function tabel_get()
	{
		$context  = $this->input->post();

		$get_bpjs = $this->api_bpjs_model->get($context);

		if($get_bpjs['eror'] == 'warning') 
		{
			$query = array(
				'eror' => 'warning', 
				'pesan' => $get_bpjs['pesan']
			);
		}
		else 
		{
			$query = array(
				'eror' => 'success', 
				'pesan' => 'Get data berhasil',
				'data' => $this->load->view($this->url_controller.'/tabel', $get_bpjs, true)
			);
		}

		echo json_encode($query);
	}

	public function tabel_post()
	{
		$context  = $this->input->post();

		$bpjs = array(
			'param' => $context['no_bpjs']
		);

		$context_bpjs  = array(
			'service_name' => $context['service_name'],
			'data' => $bpjs
		);

		$get_bpjs = $this->api_bpjs_model->post($context_bpjs);

		if($get_bpjs['eror'] == 'warning') 
		{
			$query = array(
				'eror' => 'warning', 
				'pesan' => $get_bpjs['pesan'],
				'data' => $get_bpjs
			);
		}
		else 
		{
			$query = array(
				'eror' => 'success', 
				'pesan' => 'Get data berhasil',
				'data' => $get_bpjs
			);
		}

		echo json_encode($query);
	}
}

?>