<?php

class Data_pemeriksaan extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('api_bpjs_model');
		$this->load->model('asset_bpjs_model');
		$this->load->model('data_dokter_model');
		$this->load->model('data_pendaftaran_model');
		$this->load->model('data_pemeriksaan_model');
		$this->load->model('data_pasien_model');
		$this->load->model('pengaturan_model');
		$this->load->model('data_jasa_pemeriksaan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{	
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{		
		$this->load->view($this->url_controller.'/page');
	}	

	public function tabel()
	{
		$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0; 
		$url_page = $this->url_controller.'/tabel';	
		$limit = 10;

		$context  = array(
			'range_tgl' => $this->input->post('range_tgl'),
			'status_pemeriksaan' => $this->input->post('status_pemeriksaan'),
			'keyword' => $this->input->post('keyword'),
			'limit' => $limit,
			'start' => $page
		);

		$get_data = $this->data_pemeriksaan_model->tabel_data($context);
		$get_jml = $this->data_pemeriksaan_model->jml_data($context);

		$data = [
			'data' => $get_data,
			'jml_data' => $get_jml,
			'page' => $page,
			'pagination' => $this->paging_model->get($get_jml, $limit, $url_page, 'tabel_1'),
			'page_curr' => $url_page.'/'.$page
		];

		$this->load->view($this->url_controller.'/tabel', $data);
	}

	public function riwayat()
	{				
		$context = $this->input->post();

		$data = [
			'data' => $this->data_pemeriksaan_model->riwayat($context)
		];
		
		$this->load->view($this->url_controller.'/riwayat', $data);
	}

	public function tambah()
	{				
		$context = array('no_rawat' => $this->input->post('no_rawat'));

		$pendaftaran = $this->data_pendaftaran_model->lihat_data_no_rawat($context);

		$context = array('id' => $pendaftaran->no_rm);

		$data = [
			'url_form' => $this->url_controller.'/add_update',
			'data' => $this->data_pemeriksaan_model->tambah_data($pendaftaran),
			'pasien' => $this->data_pasien_model->lihat_data($context),
			'select_debitur' => $this->select_model->select_asset('asset_debitur', 'value'),
			'select_dokter' => $this->data_dokter_model->select_data(),
			'select_perawatan' => $this->asset_bpjs_model->select_tabel('bpjs_asset_tkp'),
			'select_poli' => $this->asset_bpjs_model->select_tabel('bpjs_asset_poli'),
			'select_kesadaran' => $this->asset_bpjs_model->select_tabel('bpjs_asset_kesadaran'),
			'select_alergi_makanan' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_makanan'),
			'select_alergi_udara' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_udara'),
			'select_alergi_obat' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_obat'),
			'select_prognosa' => $this->asset_bpjs_model->select_tabel('bpjs_asset_prognosa'),
			'select_status_pulang' => $this->asset_bpjs_model->select_tabel('bpjs_asset_status_pulang'),
			'select_tacc' => $this->asset_bpjs_model->select_tabel('bpjs_asset_tacc'),
			'select_jasa_pemeriksaan' => $this->data_jasa_pemeriksaan_model->select_data($pendaftaran->debitur),
			'pengaturan' => $this->pengaturan_model->tabel_data()
		];
		
		$this->load->view($this->url_controller.'/form', $data);
	}

	public function edit()
	{
		$context = array('no_rawat' => $this->input->post('no_rawat'));

		$pendaftaran = $this->data_pendaftaran_model->lihat_data_no_rawat($context);

		$get_data = $this->data_pemeriksaan_model->lihat_data_no_rawat($context);

		$context = array(
			'id' => $get_data->no_rm,
			'pemeriksaan_id' => $get_data->pemeriksaan_id
		);

		$data = [
			'url_form' => $this->url_controller.'/add_update',
			'data' => $get_data,
			'pasien' => $this->data_pasien_model->lihat_data($context),
			'obat' => $this->data_pemeriksaan_model->tabel_obat($context),
			'tindakan' => $this->data_pemeriksaan_model->tabel_tindakan($context),
			'procedure' => $this->data_pemeriksaan_model->tabel_procedure($context),
			'select_debitur' => $this->select_model->select_asset('asset_debitur', 'value'),
			'select_dokter' => $this->data_dokter_model->select_data(),
			'select_perawatan' => $this->asset_bpjs_model->select_tabel('bpjs_asset_tkp'),
			'select_poli' => $this->asset_bpjs_model->select_tabel('bpjs_asset_poli'),
			'select_kesadaran' => $this->asset_bpjs_model->select_tabel('bpjs_asset_kesadaran'),
			'select_alergi_makanan' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_makanan'),
			'select_alergi_udara' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_udara'),
			'select_alergi_obat' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_obat'),
			'select_prognosa' => $this->asset_bpjs_model->select_tabel('bpjs_asset_prognosa'),
			'select_status_pulang' => $this->asset_bpjs_model->select_tabel('bpjs_asset_status_pulang'),
			'select_tacc' => $this->asset_bpjs_model->select_tabel('bpjs_asset_tacc'),
			'select_jasa_pemeriksaan' => $this->data_jasa_pemeriksaan_model->select_data($pendaftaran->debitur),
			'pengaturan' => $this->pengaturan_model->tabel_data()
		];
		
		$this->load->view($this->url_controller.'/form', $data);
	}

	public function delete()
	{		
		$context = array('id' => $this->input->post('id'));

		$query = $this->data_pemeriksaan_model->lihat_data($context);

		$pendaftaran_id = $query->pendaftaran_id;

		if($query->debitur == '1' && $query->status_kirim_bpjs == 'Terkirim')
		{
			$context  = array(
				'service_name' => 'kunjungan',
				'noKunjungan' => $query->bpjs_noKunjungan, 
				'data' => array()
			);

			$query = $this->api_bpjs_model->delete($context);

			if($query['eror'] == 'success') $query = $this->data_pemeriksaan_model->delete_data($context);
		}
		else $query = $this->data_pemeriksaan_model->delete_data($context);

		if($query['eror'] == 'success')
		{
			$query = $this->data_pendaftaran_model->update_status_pemeriksaan($pendaftaran_id, 'Belum');
		}

		echo json_encode($query);
	}

	public function add_update()
	{
		$context_input = $this->input->post();
		
		$query = $this->data_pemeriksaan_model->add_update($context_input);

		$context = $this->data_pemeriksaan_model->lihat_data_no_rawat($context_input);

		if($context_input['kirim_bpjs'] == '1')
		{
			$query = $this->kirim_bpjs($context); 
			
			if(isset($query['metaData']['code'])) 
			{
				if($query['metaData']['code'] == '201')
				{
					$query = $this->update_kunjungan($context->no_rawat);
				} 		
				else if($query['metaData']['code'] == '412')
				{
					$i = 0;
					$pesan = '';

					foreach($query['response'] as $key) 
					{
						$i++;
						$pesan .= '<br>'.$i.'. ['.$key['field'].'] '.$key['message'];

						if($key['message'] == 'Peserta sudah di-entri di poli yang sama pada hari yang sama.') 
						{
							$pemeriksaan_update = $this->update_kunjungan($context_input['no_rawat']);

							$pesan .= '<br> Kunjungan berhasil diupdate';
						}
					}

					$query = array('eror' => 'warning', 'pesan' => 'Cek input data !<br>['.$query['metaData']['code'].'] '.$query['metaData']['message'].''.$pesan);
				} 
				else $query = array('eror' => 'warning', 'pesan' => 'Cek input data !<br>['.$query['metaData']['code'].'] '.$query['metaData']['message']);		
			}
		} 

		echo json_encode($query);
	}

	public function cari_rujukan()
	{		
		$data = [
			'select_spesialis' => $this->asset_bpjs_model->select_tabel('bpjs_asset_spesialis'),
			'select_sarana' => $this->asset_bpjs_model->select_tabel('bpjs_asset_sarana'),
			'select_spesialis_khusus' => $this->asset_bpjs_model->select_tabel('bpjs_asset_spesialis_khusus')
		];

		$this->load->view($this->url_controller.'/form_cari_rujukan', $data);
	}	

	public function update_antrol()
	{
		$query = array('eror' => 'success', 'pesan' => 'Antrian berhasil di update' );

		$context = array('no_rawat' => $this->input->post('no_rawat'));

		$pendaftaran = $this->data_pendaftaran_model->lihat_data_no_rawat($context);

		if($pendaftaran->date_kirim_antrol != '' && $pendaftaran->date_update_antrol == '' && $pendaftaran->debitur == 1)
		{
			$bpjs = array(
				'tanggalperiksa' => $pendaftaran->tgl_daftar,
				'kodepoli' => $pendaftaran->bpjs_kdPoli,
				'nomorkartu' => $pendaftaran->bpjs_noKartu,
				'status' => 1,
				'waktu' => $this->input->post('waktu')
			);

			$context_bpjs  = array(
				'service_name' => 'update_antrol',
				'data' => $bpjs
			);

			$query = $this->api_bpjs_model->add($context_bpjs);

			if($query['eror'] == 'success')
			{
				$query = $this->data_pendaftaran_model->status_update_antrol($pendaftaran->no_rawat, $query['data']);

				if($query['eror'] == 'success')
				{
					$query = array('eror' => 'success', 'pesan' => 'Antrian berhasil di update' );
				}
			}
		}

		echo json_encode($query);
	}

	public function kirim_bpjs($pemeriksaan)
	{
		if($pemeriksaan->bpjs_rujukLanjut == 'true')
		{
			if($pemeriksaan->bpjs_rujukLanjut_SubSpesialis == 'true')
			{
				$subSpesialis = array( 
					"kdSubSpesialis1" => $pemeriksaan->bpjs_rujukLanjut_SubSpesialis_kdSubSpesialis1,
					"kdSarana" => $pemeriksaan->bpjs_rujukLanjut_SubSpesialis_kdSarana
				);
			}
			else $subSpesialis = null;

			if($pemeriksaan->bpjs_rujukLanjut_khusus == 'true')
			{
				$khusus = array(
					"kdKhusus" => $pemeriksaan->bpjs_rujukLanjut_khusus_kdKhusus,
					"kdSubSpesialis" => $pemeriksaan->bpjs_rujukLanjut_khusus_kdSubSpesialis,
					"catatan" => $pemeriksaan->bpjs_rujukLanjut_khusus_catatan
				);
			} 
			else $khusus = null;

			$rujuk_lanjut = array( 
				"kdppk" => $pemeriksaan->bpjs_rujukLanjut_kdppk,
				"tglEstRujuk" => $pemeriksaan->bpjs_rujukLanjut_tglEstRujuk,
				"subSpesialis" => $subSpesialis,
				"khusus" => $khusus
			);
		}
		else $rujuk_lanjut = null; 

		$bpjs = array(
			"noKunjungan" => null,
			"noKartu" => $pemeriksaan->bpjs_noKartu,
			"tglDaftar" => $pemeriksaan->bpjs_tglDaftar,
			"kdPoli" => $pemeriksaan->bpjs_kdPoli,
			"keluhan" => $pemeriksaan->bpjs_keluhan,
			"kdSadar" => $pemeriksaan->bpjs_kdSadar,
			"sistole" => $pemeriksaan->bpjs_sistole,
			"diastole" => $pemeriksaan->bpjs_diastole,
			"beratBadan" => $pemeriksaan->bpjs_beratBadan,
			"tinggiBadan" => $pemeriksaan->bpjs_tinggiBadan,
			"respRate" => $pemeriksaan->bpjs_respRate,
			"heartRate" => $pemeriksaan->bpjs_heartRate,
			"lingkarPerut" => $pemeriksaan->bpjs_lingkarPerut,
			"kdStatusPulang" => $pemeriksaan->bpjs_kdStatusPulang,
			"tglPulang" => $pemeriksaan->bpjs_tglPulang,
			"kdDokter" => $pemeriksaan->dokter,
			"kdDiag1" => $pemeriksaan->bpjs_kdDiag1,
			"kdDiag2" => $pemeriksaan->bpjs_kdDiag2,
			"kdDiag3" => $pemeriksaan->bpjs_kdDiag3,
			"kdPoliRujukInternal" => null,
			"rujukLanjut" => $rujuk_lanjut,
			"kdTacc" => $pemeriksaan->bpjs_kdTacc,
			"alasanTacc" => $pemeriksaan->bpjs_alasanTacc,
			"anamnesa" => $pemeriksaan->bpjs_anamnesa,
			"alergiMakan" => $pemeriksaan->bpjs_alergiMakan,
			"alergiUdara" => $pemeriksaan->bpjs_alergiUdara,
			"alergiObat" => $pemeriksaan->bpjs_alergiObat,
			"kdPrognosa" => $pemeriksaan->bpjs_kdPrognosa,
			"terapiObat" => $pemeriksaan->bpjs_terapiObat,
			"terapiNonObat" => $pemeriksaan->bpjs_terapiNonObat,
			"bmhp" => $pemeriksaan->bpjs_bmhp,
			"suhu" => $pemeriksaan->bpjs_suhu
		);

		$context_bpjs = array(
			'service_name' => 'kunjungan',
			'data' => $bpjs
		);

		$query = $this->api_bpjs_model->add($context_bpjs);

		if($query['eror'] == 'success')
		{
			$result = array(
				'noKunjungan' => $query['result'][0]['message'],
				'metaData' => '['.$query['metaData']['code'].'] '.$query['metaData']['message']
			);

			$query = $this->data_pemeriksaan_model->update_status_kirim($pemeriksaan->no_rawat, $result);
		}

		return $query;
	}

	public function update_kunjungan($no_rawat)
	{		
		$context = $this->data_pemeriksaan_model->lihat_data_no_rawat(['no_rawat' => $no_rawat]);

		$bpjs_tglDaftar = $context->bpjs_tglDaftar;
		$no_rawat = $context->no_rawat;

		if($context->bpjs_noKunjungan == '' && $context->bpjs_noUrut != '-')
		{
			$context  = array(
				'service_name' => 'riwayat_kunjungan',
				'noKartu' => $context->bpjs_noKartu
			);

			$context['data'] = $this->api_bpjs_model->get($context);

			if(isset($context['data']['result']))
			{
				foreach ($context['data']['result']['list'] as $key) 
				{ 
					if($key['tglKunjungan'] == $bpjs_tglDaftar)
					{
						$result = array(
							'noKunjungan' => $key['noKunjungan'],
							'metaData' => '['.$context['data']['metaData']['code'].'] '.$context['data']['metaData']['message']
						);

						$query = $this->data_pemeriksaan_model->update_status_kirim($no_rawat, $result);

						break;
					}
				}

				if(!isset($query)) $query = array('eror' => 'warning', 'pesan' => 'Gagal update pemeriksaan');
			}
			else $query = array('eror' => 'success', 'pesan' => 'Berhasil update');
		} 
		else $query = array('eror' => 'success', 'pesan' => 'Berhasil update');

		return $query;
	}

}

?>