<?php

class Data_pemeriksaan_obat extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('data_pemeriksaan_model');
		$this->load->model('data_pemeriksaan_obat_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{	
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{		
		$this->load->view($this->url_controller.'/page');
	}		

	public function riwayat()
	{				
		$context = $this->input->post();

		$data = [
			'data' => $this->data_pemeriksaan_obat_model->tabel_obat($context)
		];
		
		echo json_encode($data);
	}
}

?>