<?php

class Data_pendaftaran extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('api_bpjs_model');
		$this->load->model('asset_bpjs_model');
		$this->load->model('data_dokter_model');
		$this->load->model('data_pendaftaran_model');
		$this->load->model('data_mjkn_model');
		$this->load->model('data_pasien_model');
		$this->load->model('pengaturan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{	
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{		
		$this->load->view($this->url_controller.'/page');
	}			

	public function tabel()
	{
		$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0; 
		$url_page = $this->url_controller.'/tabel';	
		$limit = 10;

		$context  = array(
			'range_tgl' => $this->input->post('range_tgl'),
			'keyword' => $this->input->post('keyword'),
			'limit' => $limit,
			'start' => $page
		);

		$get_data = $this->data_pendaftaran_model->tabel_data($context);
		$get_jml = $this->data_pendaftaran_model->jml_data($context);

		$data = [
			'data' => $get_data,
			'jml_data' => $get_jml,
			'page' => $page,
			'table_id' => 'tabel_1',
			'pagination' => $this->paging_model->get($get_jml, $limit, $url_page, 'tabel_1'),
			'page_curr' => $url_page.'/'.$page
		];

		$this->load->view($this->url_controller.'/tabel', $data);
	}

	public function riwayat()
	{				
		$context = $this->input->post();

		$data = [
			'data' => $this->data_pendaftaran_model->riwayat($context)
		];
		
		$this->load->view($this->url_controller.'/riwayat', $data);
	}

	public function tabel_pasien()
	{
		$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0; 
		$url_page = $this->url_controller.'/tabel_pasien';	
		$limit = 10;

		$context  = array(
			'keyword' => $this->input->post('keyword'),
			'limit' => $limit,
			'start' => $page
		);

		$get_data = $this->data_pasien_model->tabel_data($context);
		$get_jml = $this->data_pasien_model->jml_data($context);

		$data = [
			'data' => $get_data,
			'jml_data' => $get_jml,
			'page' => $page,
			'table_id' => 'tabel_2',
			'pagination' => $this->paging_model->get($get_jml, $limit, $url_page, 'tabel_2'),
			'page_curr' => $url_page.'/'.$page
		];

		$this->load->view($this->url_controller.'/tabel_pasien', $data);
	}

	public function bridging_bpjs()
	{	
		$context  = array(
			'service_name' => 'peserta',
			'jnsKartu' => $this->input->post('jnsKartu'),
			'keyword' => $this->input->post('keyword'),
			'data' => array()
		);
		
		$query = $this->api_bpjs_model->get($context); print_r($query);
		echo json_encode($query);
	}

	public function tambah()
	{				
		$context = array('id' => $this->input->post('no_rm'));

		$data = [
			'url_form' => $this->url_controller.'/add_update',
			'data' => $this->data_pendaftaran_model->tambah_data(),
			'pasien' => $this->data_pasien_model->lihat_data($context),
			'select_debitur' => $this->select_model->select_asset('asset_debitur', 'value'),
			'select_dokter' => $this->data_dokter_model->select_data(),
			'select_perawatan' => $this->asset_bpjs_model->select_tabel('bpjs_asset_tkp'),
			'select_poli' => $this->asset_bpjs_model->select_tabel('bpjs_asset_poli'),
			'pengaturan' => $this->pengaturan_model->tabel_data()
		];
		
		$this->load->view($this->url_controller.'/form', $data);
	}

	public function edit()
	{
		$context  = array('id' => $this->input->post('id'));

		$query = $this->data_pendaftaran_model->lihat_data($context);

		$context = array('id' => $query->no_rm);

		$data = [
			'url_form' => $this->url_controller.'/add_update',
			'data' => $query,
			'pasien' => $this->data_pasien_model->lihat_data($context),
			'select_debitur' => $this->select_model->select_asset('asset_debitur', 'value'),
			'select_dokter' => $this->data_dokter_model->select_data(),
			'select_perawatan' => $this->asset_bpjs_model->select_tabel('bpjs_asset_tkp'),
			'select_poli' => $this->asset_bpjs_model->select_tabel('bpjs_asset_poli'),
			'pengaturan' => $this->pengaturan_model->tabel_data()
		];

		$this->load->view($this->url_controller.'/form', $data);
	}

	public function add_update()
	{
		$context_input = $this->input->post();

		if($context_input['id'] == '')
		{
			$cek_pendaftaran_jkn = $this->data_mjkn_model->data_hari_ini($context_input);
		}
		else $cek_pendaftaran_jkn = array();		

		if(empty($cek_pendaftaran_jkn))
		{
			$query = $this->data_pendaftaran_model->add_update($context_input); 

			if($context_input['kirim_bpjs'] == '1')
			{			
				$context = $this->data_pendaftaran_model->lihat_data_no_rawat($query['data']);

				$query = $this->kirim_bpjs($context);
			}
		}		
		else
		{
			$query = array('eror' => 'warning', 'pesan' => 'Pasien sudah terdaftar melalui MJKN. <br>Silahkan kembali ke data pendaftaran kemudian edit pendaftaran an. <strong>'. $context_input['nama_pasien'].'</strong>');
		}

		echo json_encode($query);	
	}

	public function delete()
	{		
		$context = array('id' => $this->input->post('id'));

		$query = $this->data_pendaftaran_model->lihat_data($context);

		if($query->debitur == '1' && $query->status_kirim_bpjs == 'Terkirim')
		{
			$bpjs  = array(
				'service_name' => 'pendaftaran',
				'noKartu' => $query->bpjs_noKartu, 
				'tglDaftar' => $query->bpjs_tglDaftar, 
				'noUrut' => $query->bpjs_noUrut, 
				'kdPoli' => $query->bpjs_kdPoli,
				'data' => array()
			);

			$query = $this->api_bpjs_model->delete($bpjs);

			if($query['eror'] == 'success') $query = $this->data_pendaftaran_model->delete_data($context);
		}
		else $query = $this->data_pendaftaran_model->delete_data($context);

		echo json_encode($query);
	}

	public function kirim_bpjs($pendaftaran)
	{
		if($pendaftaran->date_kirim_antrol == '')
		{
			$pengaturan = $this->pengaturan_model->tabel_data();

			if($pendaftaran->pasien_no_hp == ''){ $pasien_no_hp = '000000000000'; } else $pasien_no_hp = $pendaftaran->pasien_no_hp;

			$bpjs = array(
				'nomorkartu' => $pendaftaran->bpjs_noKartu,
				'nik' => $pendaftaran->pasien_nik,
				'nohp' => $pasien_no_hp,
				'kodepoli' => $pendaftaran->bpjs_kdPoli,
				'namapoli' => $pendaftaran->bpjs_nmPoli,
				'norm' => $pendaftaran->no_rm,
				'tanggalperiksa' => $pendaftaran->tgl_daftar,
				'kodedokter' => $pendaftaran->dokter,
				'namadokter' => $pendaftaran->nm_dokter,
				'jampraktek' => $pendaftaran->jadwal_praktek,
				'nomorantrean' => $pendaftaran->urut,
				'angkaantrean' => intval($pendaftaran->urut),
				'keterangan' => 'Antrian Online'
			);

			$context_bpjs  = array(
				'service_name' => 'kirim_antrol',
				'data' => $bpjs
			);

			$query = $this->api_bpjs_model->add($context_bpjs);
			
			if($query['eror'] == 'success')
			{
				$query = $this->data_pendaftaran_model->status_kirim_antrol($pendaftaran->no_rawat, $query['data']);
			}
		}

		$context_get_peserta  = array(
			'service_name' => 'peserta',
			'jnsKartu' => 'noka',
			'keyword' => $pendaftaran->bpjs_noKartu,
			'data' => array()
		);

		$get_peserta = $this->api_bpjs_model->get($context_get_peserta); 

		$bpjs = array(
			'kdProviderPeserta' => $get_peserta['result']['kdProviderPst']['kdProvider'],
			'tglDaftar' => $pendaftaran->bpjs_tglDaftar,
			'noKartu' => $pendaftaran->bpjs_noKartu,
			'kdPoli' => $pendaftaran->bpjs_kdPoli,
			'keluhan' => $pendaftaran->bpjs_keluhan,
			'kunjSakit' =>  $pendaftaran->bpjs_kunjSakit,
			'sistole' =>  $pendaftaran->bpjs_sistole,
			'diastole' =>  $pendaftaran->bpjs_diastole,
			'beratBadan' =>  $pendaftaran->bpjs_beratBadan,
			'tinggiBadan' =>  $pendaftaran->bpjs_tinggiBadan,
			'respRate' =>  $pendaftaran->bpjs_respRate,
			'lingkarPerut' =>  $pendaftaran->bpjs_lingkarPerut,
			'heartRate' =>  $pendaftaran->bpjs_heartRate,
			'rujukBalik' =>  $pendaftaran->bpjs_rujukBalik,
			'kdTkp' =>  $pendaftaran->bpjs_kdTkp
		);

		$context_bpjs  = array(
			'service_name' => 'pendaftaran',
			'data' => $bpjs
		);

		$query = $this->api_bpjs_model->add($context_bpjs);

		if($query['eror'] == 'success')
		{
			$query = $this->data_pendaftaran_model->update_status_pcare($pendaftaran->no_rawat, $query['data']);
		}

		return $query;
	}

}

?>