<?php

class Mjkn extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('api_bpjs_model');
		$this->load->model('data_pasien_model');
		$this->load->model('mjkn_model');
	}

	public function index()
	{
		$header = apache_request_headers();

		$cek_token = $this->mjkn_model->cek_token($header);

		$context  = array(
			'nomorkartu_jkn' => $this->uri->segment(3),
			'kode_poli' => $this->uri->segment(4),
			'tanggalperiksa' => $this->uri->segment(5)
		);

		if(isset($cek_token['metadata']))
		{
			$data['response'] = $cek_token;
		}
		else $data['response'] = $this->mjkn_model->sisa_antrian($context);

		$this->load->view('mjkn/page', $data);

	}

	public function getToken()
	{		
		$gtoken = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJTQUhBQkFUIEtMSU5JSyIsImF1ZCI6Ik1JVFJBIEtMSU5JSyIsImlhdCI6MTcxNzI2MzQzMSwiZXhwIjozNjYwfQ.LdDP5nePO/ue9DhVT9hkJ+1wbflm9uTEggScj27m1tY';

		$data1['response'] = array(
			'response' => array(
				'token' => $gtoken
			),
			'metadata' => array(
				'message' => 'Ok',
				'code' => 200
			)
		);

		$data2['response'] = array(
			'metadata' => array(
				'message' => 'Token Expired',
				'code' => 201
			)
		);
	}

	public function GetStatusAntrian()
	{	
		$data1['response'] = array(
			'response' => array(
				'nomorantrean' => 001,
				'angkaantrean' => 1,
				'namapoli' => 'UMUM',
				'sisaantrean' => 1,
				'antreanpanggil' => 0,
				'keterangan' => 'Datang 30 Menit sebelum pelayanan, Konfirmasi kehadiran dibagian pendaftaran dengan menunjukan bukti pendaftaran melalui Mobile JKN, Terima Kasih.'
			),
			'metadata' => array(
				'message' => 'Ok',
				'code' => 200
			)
		);

		$data2['response'] = array(
			'metadata' => array(
				'message' => 'Format Tanggal Tidak Sesuai, format yang benar adalah yyyy-mm-dd',
				'code' => 201
			)
		);

		$this->load->view('mjkn/page', $data2);
	}

	public function GetAmbilAntrian()
	{	
		$data1['response'] = array(
			'response' => array(
				'nomorantrean' => '002',
				'angkaantrean' => 2,
				'namapoli' => 'UMUM',
				'sisaantrean' => 2,
				'antreanpanggil' => 0,
				'keterangan' => 'Datang 30 Menit sebelum pelayanan, Konfirmasi kehadiran dibagian pendaftaran dengan menunjukan bukti pendaftaran melalui Mobile JKN, Terima Kasih.'
			),
			'metadata' => array(
				'message' => 'Ok',
				'code' => 200
			)
		);

		$data2['response'] = array(
			'metadata' => array(
				'message' => 'Data pasien ini tidak ditemukan, silahkan Melakukan Registrasi Pasien Baru',
				'code' => 201
			)
		);

		$this->load->view('mjkn/page', $data1);
	}

	public function GetSisaAntrain()
	{	
		$data1['response'] = array(
			'response' => array(
				'nomorantrean' => '002',
				'angkaantrean' => 2,
				'namapoli' => 'UMUM',
				'sisaantrean' => 2,
				'antreanpanggil' => 0,
				'keterangan' => 'Datang 30 Menit sebelum pelayanan, Konfirmasi kehadiran dibagian pendaftaran dengan menunjukan bukti pendaftaran melalui Mobile JKN, Terima Kasih.'
			),
			'metadata' => array(
				'message' => 'Ok',
				'code' => 200
			)
		);

		$data2['response'] = array(
			'metadata' => array(
				'message' => 'Antrean Tidak Ditemukan',
				'code' => 201
			)
		);

		$this->load->view('mjkn/page', $data1);
	}

	public function GetBatalAntrian()
	{	
		$data1['response'] = array(
			'response' => array(
				'nomorantrean' => '002',
				'angkaantrean' => 2,
				'namapoli' => 'UMUM',
				'sisaantrean' => 2,
				'antreanpanggil' => 0,
				'keterangan' => 'Datang 30 Menit sebelum pelayanan, Konfirmasi kehadiran dibagian pendaftaran dengan menunjukan bukti pendaftaran melalui Mobile JKN, Terima Kasih.'
			),
			'metadata' => array(
				'message' => 'Ok',
				'code' => 200
			)
		);

		$data2['response'] = array(
			'metadata' => array(
				'message' => 'Antrean Tidak Ditemukan atau Sudah Dibatalkan',
				'code' => 201
			)
		);

		$data3['response'] = array(
			'metadata' => array(
				'message' => 'Ok',
				'code' => 200
			)
		);

		$this->load->view('mjkn/page', $data3);
	}

	
}

?>