<?php

class Pengaturan extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('asset_bpjs_model');
		$this->load->model('api_satusehat_model');		
		$this->load->model('update_database_model');
		$this->load->model('pengaturan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');				
		$this->load->model('wilayah_model');	

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{			
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{					
		$this->load->view($this->url_controller.'/page');
	}			

	public function tabel()
	{
		$get_data = $this->pengaturan_model->tabel_data();

		$data = [
			'url_form_1' => $this->url_controller.'/update',
			'data' => $get_data,
			'select_propinsi' => $this->wilayah_model->select_kode_propinsi(),
			'select_kabupaten' => $this->wilayah_model->select_kode_kabupaten($get_data->satusehat_propinsi),
			'select_kecamatan' => $this->wilayah_model->select_kode_kecamatan($get_data->satusehat_kabupaten),
			'select_kelurahan' => $this->wilayah_model->select_kode_kelurahan($get_data->satusehat_kecamatan)
		];

		$this->load->view($this->url_controller.'/tabel', $data);
	}

	public function lihat()
	{		
		$query = $this->pengaturan_model->tabel_data();
		echo json_encode($query);
	}

	public function update()
	{		
		$context = $this->input->post();

		$query = $this->pengaturan_model->update_data($context);
		echo json_encode($query);
	}

	public function update_pcare()
	{		
		$context = $this->input->post();

		$query = $this->pengaturan_model->update_pcare($context);

		echo json_encode($query);
	}

	public function update_icare()
	{		
		$context = $this->input->post();

		$query = $this->pengaturan_model->update_icare($context);

		echo json_encode($query);
	}

	public function form_update_get()
	{
		$this->load->view($this->url_controller.'/form_update_get');
	}
	
	public function update_get_from_server()
	{
		$context_input = $this->input->post();

		$backup['eror'] = 'success';

		if(isset($context_input['mode']))
		{
			if($context_input['mode'] == 'all')
			{ 
				$backup = $this->backup_database();
			}
		}
		else $this->backup_database();

		if($backup['eror'] == 'success')
		{
			$pengaturan = (array) $this->db->select('*')->from('pengaturan')->get()->row();

			$headers = array(
				"Accept: application/json"
			);

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $pengaturan['url_update']);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_TIMEOUT, 60);  
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
			curl_setopt($ch, CURLOPT_POSTFIELDS, $context_input);

			$content = curl_exec($ch);
			$err = curl_error($ch);

			curl_close($ch);   

			echo $content;
		}
	}

	public function execute_update_content()
	{
		$context = $this->input->post();

		$respon = '<td>'.$context['filename'].'</td><td>'.$context['dir'].'</td><td>'.$context['file_date'].'</td><td>NOT UPDATE</td>';

		$pengaturan = (array) $this->db->select('*')->from('pengaturan')->get()->row();

		$url = $context['dir'].'/'.$context['filename'];

		if(!file_exists($context['dir'])) mkdir($context['dir'], 0777, true);

		if($context['content'] != '' && $url != '')
		{
			if($pengaturan['mode'] == 'Client')
			{
				if(!isset($context['content']))
				{
					$file_date = date("Y-m-d H:i:s", filemtime($url));

					if(strtotime($file_date) < strtotime($context['file_date']))
					{
						$get_content = $this->get_content($context['id']);

						$query = file_put_contents($url, base64_decode($get_content['content']), LOCK_EX);	

						$respon = '<td>'.$context['filename'].'</td><td>'.$context['dir'].'</td><td>'.$context['file_date'].'</td><td>UPDATE</td>';
					}			
				}
				else
				{
					if(file_exists($url)) unlink($url);

					$query = file_put_contents($url, base64_decode($context['content']), LOCK_EX);	

					$respon = '<td>'.$context['filename'].'</td><td>'.$context['dir'].'</td><td>'.$context['file_date'].'</td><td>UPDATE</td>';
				}

			}
			else if($url != './application/views/data_pemeriksaan/form.php' && $url != './application/views/data_pendaftaran/form.php')
			{
				if(file_exists($url)) unlink($url);

				$query = file_put_contents($url, base64_decode($context['content']), LOCK_EX);

				$respon = '<td>'.$context['filename'].'</td><td>'.$context['dir'].'</td><td>'.$context['file_date'].'</td><td>UPDATE</td>';
			}			
		} 	

		echo $respon;	
	}

	public function execute_update_database()
	{
		$context = $this->input->post();

		$query = $this->update_database_model->exe_query($context);

		echo '<td>'.$context['query'].'</td><td>'.$query['pesan'].'</td>';
	}

	public function update_versi()
	{
		$context = $this->input->post();

		$query = $this->pengaturan_model->update_versi($context);

		echo json_encode($query);
	}

	public function backup_database()
	{		
		$this->load->dbutil();

		$config = array(
			'format'	=> 'txt',
			'filename'	=> 'database.sql'
		);

		if(!file_exists('./backup/')) mkdir('./backup/', 0777, true);

		$url = './backup/'.date("Ymd_His").'-db.sql';

		$backup = $this->dbutil->backup($config);

		$write = file_put_contents($url, $backup, LOCK_EX);

		$notif = array('eror' => 'success', 'pesan' => 'Backup database Berhasil');

		return $notif;		
	}
	
	public function get_content($id)
	{		
		$context_input = array('id' => $id);

		$pengaturan = (array) $this->db->select('*')->from('pengaturan')->get()->row();

		$headers = array(
			"Accept: application/json"
		);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $pengaturan['url_update'].'/content');
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_TIMEOUT, 60);  
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $context_input);

		$content = curl_exec($ch);
		$err = curl_error($ch);

		curl_close($ch);   

		return $content;
	}
}

?>