<?php

class Pengaturan_pemeriksaan extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('asset_bpjs_model');
		$this->load->model('data_dokter_model');
		$this->load->model('pengaturan_pemeriksaan_model');
		$this->load->model('pengaturan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function edit()
	{
		$get_data = $this->pengaturan_pemeriksaan_model->lihat_data();

		$data = [
			'url_form' => $this->url_controller.'/update',
			'data' => $get_data,
			'select_debitur' => $this->select_model->select_asset('asset_debitur', 'value'),
			'select_dokter' => $this->data_dokter_model->select_data(),
			'select_perawatan' => $this->asset_bpjs_model->select_tabel('bpjs_asset_tkp'),
			'select_poli' => $this->asset_bpjs_model->select_tabel('bpjs_asset_poli'),
			'select_kesadaran' => $this->asset_bpjs_model->select_tabel('bpjs_asset_kesadaran'),
			'select_alergi_makanan' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_makanan'),
			'select_alergi_udara' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_udara'),
			'select_alergi_obat' => $this->asset_bpjs_model->select_tabel('bpjs_asset_alergi_obat'),
			'select_prognosa' => $this->asset_bpjs_model->select_tabel('bpjs_asset_prognosa'),
			'select_status_pulang' => $this->asset_bpjs_model->select_tabel('bpjs_asset_status_pulang'),
			'select_tacc' => $this->asset_bpjs_model->select_tabel('bpjs_asset_tacc'),
			'pengaturan' => $this->pengaturan_model->tabel_data()
		];
		
		$this->load->view($this->url_controller.'/form', $data);
	}

	public function update()
	{
		$context_input = $this->input->post();
		
		$query = $this->pengaturan_pemeriksaan_model->update($context_input);

		echo json_encode($query);
	}

}

?>