<?php

class Penyerahan_obat extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		if($this->session->userdata('class_'.$this->session->userdata('prefix')) == null){    
			redirect(base_url('login'));
		}

		$this->load->model('data_pendaftaran_model');
		$this->load->model('data_pasien_model');
		$this->load->model('data_pemeriksaan_model');
		$this->load->model('data_pemeriksaan_obat_model');
		$this->load->model('data_pemeriksaan_tindakan_model');
		$this->load->model('pengaturan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{	
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{		
		$this->load->view($this->url_controller.'/page');
	}	

	public function tabel()
	{
		$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0; 
		$url_page = $this->url_controller.'/tabel';	
		$limit = 10;

		$context  = array(
			'range_tgl' => $this->input->post('range_tgl'),
			'penyerahan_obat' => $this->input->post('penyerahan_obat'),
			'keyword' => $this->input->post('keyword'),
			'limit' => $limit,
			'start' => $page
		);

		$get_data = $this->data_pemeriksaan_obat_model->tabel_data($context); 
		$get_jml = $this->data_pemeriksaan_obat_model->jml_data($context);

		$data = [
			'data' => $get_data,
			'jml_data' => $get_jml,
			'page' => $page,
			'pagination' => $this->paging_model->get($get_jml, $limit, $url_page, 'tabel_1'),
			'page_curr' => $url_page.'/'.$page
		];

		$this->load->view($this->url_controller.'/tabel', $data);
	}

	public function penyerahan()
	{				
		$pemeriksaan_id = $this->input->post('pemeriksaan_id');

		$data_pemeriksaan = $this->data_pemeriksaan_model->lihat_data(['id' => $pemeriksaan_id]);

		$data_pemeriksaan_obat = $this->data_pemeriksaan_obat_model->tabel_obat(['pemeriksaan_id' => $pemeriksaan_id]); 

		$data_pemeriksaan_tindakan = $this->data_pemeriksaan_tindakan_model->tabel_tindakan(['pemeriksaan_id' => $pemeriksaan_id]); 

		$context = array('id' => $data_pemeriksaan->no_rm);

		$data = [
			'url_form' => $this->url_controller.'/update',
			'pemeriksaan' => $data_pemeriksaan,
			'data_obat' => $data_pemeriksaan_obat,
			'data_tindakan' => $data_pemeriksaan_tindakan,
			'pasien' => $this->data_pasien_model->lihat_data($context)
		];
		
		$this->load->view($this->url_controller.'/form', $data);
	}

	public function print_surat()
	{				
		$pemeriksaan_id = $this->input->post('pemeriksaan_id');

		$data_pemeriksaan = $this->data_pemeriksaan_model->lihat_data(['id' => $pemeriksaan_id]);

		$data_pemeriksaan_obat = $this->data_pemeriksaan_obat_model->tabel_obat(['pemeriksaan_id' => $pemeriksaan_id]); 

		$data_pemeriksaan_tindakan = $this->data_pemeriksaan_tindakan_model->tabel_tindakan(['pemeriksaan_id' => $pemeriksaan_id]); 

		$context = array('id' => $data_pemeriksaan->no_rm);

		$data = [
			'post' => $this->input->post(),
			'pengaturan' => $this->pengaturan_model->tabel_data(),
			'pemeriksaan' => $data_pemeriksaan,
			'data_obat' => $data_pemeriksaan_obat,
			'data_tindakan' => $data_pemeriksaan_tindakan,
			'pasien' => $this->data_pasien_model->lihat_data($context)
		];
		
		$this->load->view($this->url_controller.'/print_'.$this->input->post('nama_surat'), $data);
	}

	public function update()
	{		
		$context = $this->input->post();
		
		$query = $this->data_pemeriksaan_obat_model->update_data($context);

		if($query['eror'] == 'success')
		{
			$query = $this->data_pemeriksaan_model->update_status_penyerahan_obat($context);
		}

		echo json_encode($query);
	}
}

?>