<?php

class Satusehat_data_clinical_impression extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('data_pasien_model');
		$this->load->model('data_pendaftaran_model');
		$this->load->model('data_pemeriksaan_model');
		$this->load->model('api_satusehat_model');
		$this->load->model('satusehat_data_clinical_impression_model');
		$this->load->model('pengaturan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{	
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{		
		$this->load->view($this->url_controller.'/page');
	}			

	public function tabel()
	{
		$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0; 
		$url_page = $this->url_controller.'/tabel';	
		$limit = 10;

		$context  = array(
			'service_name' => 'clinical_impression',
			'range_tgl' => $this->input->post('range_tgl'),
			'keyword' => $this->input->post('keyword'),
			'limit' => $limit,
			'start' => $page
		);

		$get_data = $this->data_pemeriksaan_model->tabel_data_satusehat($context);
		$get_jml = $this->data_pemeriksaan_model->jml_data_satusehat($context);

		$data = [
			'data' => $get_data,
			'jml_data' => $get_jml,
			'page' => $page,
			'pagination' => $this->paging_model->get($get_jml, $limit, $url_page, 'tabel_1'),
			'page_curr' => $url_page.'/'.$page
		];

		$this->load->view($this->url_controller.'/tabel', $data);
	}

	public function tabel_eror()
	{
		$this->load->view($this->url_controller.'/tabel_eror');
	}

	public function kirim()
	{
		$data = $this->input->post();

		$response = $this->execute($data);

		echo json_encode($response);
	}

	public function kirim_semua()
	{
		$context_data = array(
			'service_name' => 'clinical_impression',
			'range_tgl' => $this->input->post('range_tgl'),
			'keyword' => $this->input->post('keyword')
		);

		$get_data = $this->data_pemeriksaan_model->tabel_all_satusehat($context_data);

		echo json_encode($get_data);
	}

	public function kirim_semua_json()
	{
		$context_data = array(
			'service_name' => 'clinical_impression'
		);

		$get_data = $this->data_pemeriksaan_model->tabel_all_satusehat($context_data);

		$i = 0;
		$data = array();

		foreach ($get_data as $key)
		{		
			if($key->clinical_impression_satusehat_id == '')
			{
				$response = $this->execute((array) $key);

				if($response['eror'] == 'warning')
				{
					$data['data'][$i] = $key;
					$data['data'][$i]->response_kirim = $response['pesan'];

					$i++;
				} 
			}		
		}

		echo json_encode($data);
	}

	public function execute($context_data)
	{
		$pendaftaran = $this->data_pendaftaran_model->lihat_data_no_rawat($context_data);

		$context = (array) $pendaftaran;

		$context['service_name'] = 'clinical_impression';

		$response = $this->api_satusehat_model->post($context);

		if(isset($response['eror']))
		{
			if($response['data']['issue'][0]->code == 'duplicate')
			{
				$context = array('service_name' => 'clinical_impression_by_subject_encounter', 'subject' => $pendaftaran->pasien_satusehat_id, 'encounter' => $pendaftaran->encounter_satusehat_id);

				$response = $this->api_satusehat_model->get($context); 

				foreach($response['entry'] as $key) 
				{
					$split = explode('/', $key->resource->encounter->reference);

					if($split[1] == $pendaftaran->encounter_satusehat_id)
					{
						$response = (array) $key->resource;
						break;
					} 
				}
			}
		}

		if(!empty($response))
		{
			$response['data'] = (array) $pendaftaran;

			$response = $this->satusehat_data_clinical_impression_model->add_update($response);			
		} 
		else $response = array('eror' => 'warning', 'pesan' => 'Tidak ada respon dari SATUSEHAT. Kesalahan data yang dikirim');

		return $response;
	}
}

?>