<?php

class Satusehat_data_observation extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('data_pasien_model');
		$this->load->model('data_pendaftaran_model');
		$this->load->model('data_pemeriksaan_model');
		$this->load->model('api_satusehat_model');
		$this->load->model('satusehat_data_observation_model');
		$this->load->model('pengaturan_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{	
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{		
		$this->load->view($this->url_controller.'/page');
	}			

	public function tabel()
	{
		$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0; 
		$url_page = $this->url_controller.'/tabel';	
		$limit = 10;

		$context  = array(
			'service_name' => 'observation',
			'range_tgl' => $this->input->post('range_tgl'),
			'keyword' => $this->input->post('keyword'),
			'limit' => $limit,
			'start' => $page
		);

		$get_data = $this->data_pemeriksaan_model->tabel_data_satusehat($context);
		$get_jml = $this->data_pemeriksaan_model->jml_data_satusehat($context);

		$data = [
			'data' => $get_data,
			'jml_data' => $get_jml,
			'page' => $page,
			'pagination' => $this->paging_model->get($get_jml, $limit, $url_page, 'tabel_1'),
			'page_curr' => $url_page.'/'.$page
		];

		$this->load->view($this->url_controller.'/tabel', $data);
	}

	public function tabel_eror()
	{
		$this->load->view($this->url_controller.'/tabel_eror');
	}

	public function kirim()
	{
		$data = $this->input->post();

		$response = $this->execute($data);

		echo json_encode($response);
	}

	public function kirim_semua()
	{
		$context_data = array(
			'service_name' => 'observation',
			'range_tgl' => $this->input->post('range_tgl'),
			'keyword' => $this->input->post('keyword')
		);

		$get_data = $this->data_pemeriksaan_model->tabel_all_satusehat($context_data);

		echo json_encode($get_data);
	}

	public function kirim_semua_json()
	{
		$context_data = array(
			'service_name' => 'observation'
		);

		$get_data = $this->data_pemeriksaan_model->tabel_all_satusehat($context_data);

		$i = 0;
		$data = array();

		foreach ($get_data as $key)
		{		
			if($key->observation_satusehat_id == '')
			{
				$response = $this->execute((array) $key);

				$data['data'][$i] = $key;
				$data['data'][$i]->response_kirim = $response['pesan'];

				$i++;
			}		
		}

		echo json_encode($data);
	}

	public function execute($context_data)
	{
		$_eror = '';

		$pendaftaran = $this->data_pendaftaran_model->lihat_data_no_rawat($context_data);

		$context = (array) $pendaftaran;

		$context['service_name'] = 'observation';

		switch ($pendaftaran->kesadaran)
		{
			case 'Compos mentis':
			$kesadaran = 'Alert'; 
			break;

			case 'Sopor':
			$kesadaran = 'Voice';
			break;

			case 'Somnolence':
			$kesadaran = 'Pain';
			break;

			case 'Coma':
			$kesadaran = 'Unresponsive';
			break;
		}

		$parameter = [
			[
				"satusehat" => $pendaftaran->sistole_satusehat,
				"category" => [
					"system" => "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "vital-signs",
					"display" => "Vital Signs"
				],
				"code" => [
					"system" => "http://loinc.org",
					"code" => "8480-6",
					"display" => "Systolic blood pressure"		
				],
				"valueQuantity" => [
					"system" => "http://unitsofmeasure.org",
					"value" => $pendaftaran->sistole,
					"unit" => "mmHg",
					"code" => "mm[Hg]"
				]
			],
			[
				"satusehat" => $pendaftaran->diastole_satusehat,
				"category" => [
					"system" => "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "vital-signs",
					"display" => "Vital Signs"
				],
				"code" => [
					"system" => "http://loinc.org",
					"code" => "8462-4",
					"display" => "Diastolic blood pressure"		
				],
				"valueQuantity" => [
					"system" => "http://unitsofmeasure.org",
					"value" => $pendaftaran->diastole,
					"unit" => "mmHg",
					"code" => "mm[Hg]"
				]
			],
			[
				"satusehat" => $pendaftaran->heart_rate_satusehat,
				"category" => [
					"system" => "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "vital-signs",
					"display" => "Vital Signs"
				],
				"code" => [
					"system" => "http://loinc.org",
					"code" => "8867-4",
					"display" => "Heart rate"		
				],
				"valueQuantity" => [
					"system" => "http://unitsofmeasure.org",
					"value" => $pendaftaran->heart_rate,
					"unit" => "beats/minute",
					"code" => "/min"
				]
			],
			[
				"satusehat" => $pendaftaran->lingkar_perut_satusehat,
				"category" => [
					"system" => "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "vital-signs",
					"display" => "Vital Signs"
				],
				"code" => [
					"system" => "http://loinc.org",
					"code" => "8280-0",
					"display" => "Waist Circumference at umbilicus by Tape measure"		
				],
				"valueQuantity" => [
					"system" => "http://unitsofmeasure.org",
					"value" => $pendaftaran->lingkar_perut,
					"unit" => "centimeter",
					"code" => "cm"
				]
			],
			[
				"satusehat" => $pendaftaran->berat_badan_satusehat,
				"category" => [
					"system" => "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "vital-signs",
					"display" => "Vital Signs"
				],
				"code" => [
					"system" => "http://loinc.org",
					"code" => "29463-7",
					"display" => "Body weight"		
				],
				"valueQuantity" => [
					"system" => "http://unitsofmeasure.org",
					"value" => $pendaftaran->berat_badan,
					"unit" => "kilogram",
					"code" => "kg"
				]
			],
			[
				"satusehat" => $pendaftaran->tinggi_badan_satusehat,
				"category" => [
					"system" => "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "vital-signs",
					"display" => "Vital Signs"
				],
				"code" => [
					"system" => "http://loinc.org",
					"code" => "8302-2",
					"display" => "Body height"		
				],
				"valueQuantity" => [
					"system" => "http://unitsofmeasure.org",
					"value" => $pendaftaran->tinggi_badan,
					"unit" => "centimeter",
					"code" => "cm"
				]
			],	
			[
				"satusehat" => $pendaftaran->respirasi_rate_satusehat,
				"category" => [
					"system"=> "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "vital-signs",
					"display" => "Vital Signs"
				],
				"code" => [
					"system" => "http://loinc.org",
					"code" => "9279-1",
					"display" => "Respiratory rate"		
				],
				"valueQuantity" => [
					"system" => "http://unitsofmeasure.org",
					"value" => $pendaftaran->respirasi_rate,
					"unit" => "breaths/minute",
					"code" => "/min"
				]
			],
			[ 
				"satusehat" => $pendaftaran->kesadaran_satusehat,
				"category" => [
					"system" => "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "exam",
					"display" => "Exam"
				],
				"code" => [
					"system" => "http://snomed.info/sct",
					"code" => "1104441000000107",
					"display" => "ACVPU (Alert Confusion Voice Pain Unresponsive) scale score"		
				],
				"valueCodeableConcept" => ["text" => $pendaftaran->kesadaran]
			],
			[
				"satusehat" => $pendaftaran->suhu_satusehat,
				"category" => [
					"system"=> "http://terminology.hl7.org/CodeSystem/observation-category",
					"code" => "vital-signs",
					"display" => "Vital Signs"
				],
				"code" => [
					"system" => "http://loinc.org",
					"code" => "8310-5",
					"display" => "Body temperature"		
				],
				"valueQuantity" => [
					"system" => "http://unitsofmeasure.org",
					"value" => $pendaftaran->suhu,
					"unit" => "degree Celsius",
					"code" => "Cel"
				]
			]
		];

		foreach ($parameter as $key) 
		{
			if($key['satusehat'] == '')
			{
				$context['parameter'] = $key;

				$parameter = $key;

				if(isset($key["valueQuantity"]["value"]))
				{
					if($key["valueQuantity"]["value"] != 0)
					{
						$response = $this->api_satusehat_model->post($context);
					}
				}
				else $response = $this->api_satusehat_model->post($context);

				if(isset($response['data']['issue']))
				{
					if($response['data']['issue'][0]->code == 'duplicate')
					{
						$response = $this->duplicate($context);
					} 
					// else $_eror .= '<td>'.$response['data']['issue'][0]->code.'</td>';
				}

				if(!empty($response))
				{
					$response['data'] = (array) $pendaftaran;

					$response['parameter'] = $parameter;

					$response = $this->satusehat_data_observation_model->add_update($response);
				} 
				else $_eror .= '<td>Tidak ada respon dari SATUSEHAT. Kesalahan data yang dikirim</td>';

				if(!$response['eror'] == 'warning')
				{
					$_eror .= '<td>Data sudah dikirim</td>';	
				}
				else $_eror .= '<td>'.$response['pesan'].'</td>';
			}
			else $_eror .= '<td>Data sudah dikirim</td>';		
		}				

		if($_eror == '')
		{
			$response = array('eror' => 'success', 'pesan' => '<td>Kirim data berhasil<td>');
		} 
		else $response = array('eror' => 'warning', 'pesan' => $_eror);

		return $response;
	}

	public function duplicate($context)
	{
		$context = array('service_name' => 'observation_by_encounter',  'encounter' => $context['encounter_satusehat_id']);

		$response = $this->api_satusehat_model->get($context);

		foreach($response['entry'] as $key) 
		{
			$response = (array) $key->resource;
			break;			
		}

		return $response;
	}
}

?>