<?php

class Satusehat_verifikasi_kyc extends CI_Controller {


	public function __construct()
	{
		parent::__construct();

		$this->load->model('pengaturan_model');
		$this->load->model('data_dokter_model');

		$this->load->model('asset_menu_class_model');
		$this->load->model('paging_model');				
		$this->load->model('select_model');		

		$this->url_controller = $this->uri->segment(1);
		$this->navigation = $this->session->userdata('nav_'.$this->session->userdata('prefix'));
	}

	public function index()
	{	
		$data = [
			'menu' => [
				'data' => $this->asset_menu_class_model->tabel_data($this->session->userdata('level_id_'.$this->session->userdata('prefix'))),
				'select_level' => $this->select_model->select_asset('asset_level_user', 'id')
			]			
		];

		$this->load->view($this->navigation.'/body', $data);
	}

	public function page()
	{	
		$data = [
			'select_dokter' => $this->data_dokter_model->select_satu_sehat()
		];
		
		$this->load->view($this->url_controller.'/page', $data);
	}

	public function generate_link()
	{		
		$pengaturan = $this->pengaturan_model->tabel_data();

		$context = array(
			'client_id' => $pengaturan->satusehat_client_id,
			'client_secret' => $pengaturan->satusehat_secret_key,
			'auth_url' => $pengaturan->satusehat_url_auth,
			'api_url' => 'https://api-satusehat.kemkes.go.id/kyc/v1/generate-url',
			'environment' => 'production',
			'agent_name' => 'dr. Mudrikah',
			'agent_nik' => '3329044603700005'
		);

		$url = 'https://apps2.rsudbumiayu.com/api_kyc?data='.base64_encode(json_encode($context));

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "$url",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_HTTPHEADER => array(
				'Content-Type: application/x-www-form-urlencoded'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);

		echo $response;
	}
}

?>