<?php

class Select extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('asset_model');
		$this->load->model('data_obat_model');
		$this->load->model('data_tindakan_model');
		$this->load->model('select_model');
	}

	public function selected_data()
	{
		$context  = array(
            'table_name' => $this->input->post('asset'),
            'id' => $this->input->post('id')
        );

		$query = $this->select_model->selected_data($context);

		echo json_encode($query);
	}

	public function select_icd10()
	{
		$query = $this->select_model->select_asset_2('asset_icd_10', 'id', $this->uri->segment(3));

		echo json_encode($query);
	}

	public function select_icd9()
	{
		$query = $this->select_model->select_asset_2('asset_icd_9', 'id', $this->uri->segment(3));

		echo json_encode($query);
	}

	public function select_obat()
	{
		$context  = array(
            'order_by' => 'value',
            'keyword' => $this->uri->segment(3)
        );

		$query = $this->data_obat_model->select_data_keyword($context);

		echo json_encode($query);
	}

	public function select_tindakan()
	{
		$context  = array(
            'order_by' => 'value',
            'keyword' => $this->uri->segment(3)
        );

		$query = $this->data_tindakan_model->select_data_keyword($context);

		echo json_encode($query);
	}

	public function select_diet()
	{
		$context  = array(
            'order_by' => 'value',
            'keyword' => $this->uri->segment(3)
        );

		$query = $this->data_diet_model->select_data_keyword($context);

		echo json_encode($query);
	}


}

?>