<?php

class Api_satusehat_model extends CI_Model {

	private $_error = "";

	public function getToken()
	{
		$pengaturan =  $this->db->get('pengaturan')->row();

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => $pengaturan->satusehat_url_auth.'/accesstoken?grant_type=client_credentials',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => 'client_id='.$pengaturan->satusehat_client_id.'&client_secret='.$pengaturan->satusehat_secret_key,
		));

		$response = (array) json_decode(curl_exec($curl));

		curl_close($curl);

		$data['satusehat_access_token'] = $response['access_token'];
		$data['satusehat_expired_token'] = date("Y-m-d h:i:s", time() + $response['expires_in']);			

		$query = $this->db->update('pengaturan', $data);	

		if($query)	
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update Token berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => "Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");

		return $response;
	}

	public function get($context)
	{
		$url = '';

		$data = array();
		
		$pengaturan = $this->db->select('*')->from('pengaturan')->get()->row();

		$service_name = $context['service_name'];

		switch($service_name)
		{			
			case 'practitioner':
			$url = $pengaturan->satusehat_url_fhir.'/Practitioner?identifier=https://fhir.kemkes.go.id/id/nik|'.$context['nik'];
			break;

			case 'patient':
			$url = $pengaturan->satusehat_url_fhir.'/Patient?identifier=https://fhir.kemkes.go.id/id/nik|'.$context['nik'];
			break;

			case 'organization':
			$url = $pengaturan->satusehat_url_fhir.'/Organization/'.$pengaturan->satusehat_id;
			break;

			case 'location':
			$url = $pengaturan->satusehat_url_fhir.'/Location?organization='.$pengaturan->satusehat_id;
			break;

			case 'encounter_by_subject':
			$url = $pengaturan->satusehat_url_fhir.'/Encounter?subject='.$context['subject'];
			break;

			case 'observation_by_subject':
			$url = $pengaturan->satusehat_url_fhir.'/Observation?subject='.$context['subject'];
			break;

			case 'condition_by_subject_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/Condition?subject='.$context['subject'].'&encounter='.$context['encounter'];
			break;

			case 'observation_by_subject_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/Observation?subject='.$context['subject'].'&encounter='.$context['encounter'];
			break;

			case 'observation_by_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/Observation?encounter='.$context['encounter'];
			break;

			case 'composition_by_subject':
			$url = $pengaturan->satusehat_url_fhir.'/Composition?subject='.$context['subject'];
			break;

			case 'composition_by_subject_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/Composition?subject='.$context['subject'].'&encounter='.$context['encounter'];
			break;

			case 'composition_by_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/Composition?encounter='.$context['encounter'];
			break;

			case 'procedure_by_subject':
			$url = $pengaturan->satusehat_url_fhir.'/Procedure?subject='.$context['subject'];
			break;

			case 'procedure_by_subject_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/Procedure?subject='.$context['subject'].'&encounter='.$context['encounter'];
			break;

			case 'procedure_by_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/Procedure?encounter='.$context['encounter'];
			break;			

			case 'clinical_impression_by_subject':
			$url = $pengaturan->satusehat_url_fhir.'/ClinicalImpression?subject='.$context['subject'];
			break;

			case 'clinical_impression_by_subject_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/ClinicalImpression?subject='.$context['subject'].'&encounter='.$context['encounter'];
			break;

			case 'clinical_impression_by_encounter':
			$url = $pengaturan->satusehat_url_fhir.'/ClinicalImpression?encounter='.$context['encounter'];
			break;

		}

		$response = $this->execute($data, 'GET', $url, $pengaturan->satusehat_access_token); 

		if(isset($response['issue']))
		{
			if($response['issue'][0]->code == 'invalid-access-token')
			{
				$response = $this->getToken();

				if($response == 'success') $response = $this->execute($data, 'GET', $url, $pengaturan->satusehat_access_token); 
			}
			else 
			{
				$response = array('eror' => 'warning', 'pesan' => $response['issue'][0]->details->text, 'data' => $response);
			}
		}

		return $response;
	}

	public function post($context)
	{
		$url = '';

		$data = array();

		$pengaturan = $this->db->select('*, a_kab.value AS kabupaten_value')->from('pengaturan p')->join('satusehat_mapping_organisasi s_mo', 's_mo.organization_id=p.satusehat_id', 'left')->join('asset_kabupaten a_kab', 'a_kab.kode=p.satusehat_kabupaten', 'left')->get()->row();

		$service_name = $context['service_name'];

		switch($service_name)
		{			
			case 'location':
			$url = $pengaturan->satusehat_url_fhir.'/Location';
			$data = '{
				"resourceType": "Location",
				"identifier": [
				{
					"system": "http://sys-ids.kemkes.go.id/location/'.$context['satusehat_id'].'",
					"value": "'.$context['kode'].'"
				}
				],
				"status": "active",
				"name": "'.$context['kode'].'",
				"description": "'.$context['kode'].', '.$pengaturan->coding_display.'",
				"mode": "instance",
				"telecom": [
				{ "system": "phone",
				"value": "'.$context['no_telp'].'",
				"use": "work"
				},
				{ "system": "email",
				"value": "'.$context['email'].'",
				"use": "work"
				},
				{ "system": "url",
				"value": "www.'.$context['email'].'",
				"use": "work"
			}
			],
			"address": { "use": "work",
			"line": [
			"'.$pengaturan->alamat.'"
			],
			"city": "'.$pengaturan->kabupaten_value.'",
			"postalCode": "'.$pengaturan->satusehat_kodepos.'",
			"country": "ID",
			"extension": [
			{
				"url": "https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode",
				"extension": [
				{ "url": "province",
				"valueCode": "'.$pengaturan->satusehat_propinsi.'"
				},
				{ "url": "city",
				"valueCode": "'.$pengaturan->satusehat_kabupaten.'"
				},
				{ "url": "district",
				"valueCode": "'.$pengaturan->satusehat_kecamatan.'"
				},
				{ "url": "village",
				"valueCode": "'.$pengaturan->satusehat_kelurahan.'"
				},
				{ "url": "rt",
				"valueCode": "'.$pengaturan->satusehat_rt.'"
				},
				{ "url": "rw",
				"valueCode": "'.$pengaturan->satusehat_rw.'"
			}
			]
		}
		]
		},
		"physicalType": { 
			"coding": [
			{
				"system": "http://terminology.hl7.org/CodeSystem/location-physical-type",
				"code": "ro",
				"display": "Room"
			}
			]
			},
			"position": {
				"longitude": '.$context['longitude'].',
				"latitude": '.$context['latitude'].',
				"altitude": '.$context['altitude'].'
				},
				"managingOrganization": {
					"reference": "Organization/'.$context['satusehat_id'].'"
				}
			}';

			break;

			case 'encounter':
			$url = $pengaturan->satusehat_url_fhir.'/Encounter';
			$data = '{
				"resourceType": "Encounter",
				"status": "arrived",
				"class": {
					"system": "http://terminology.hl7.org/CodeSystem/v3-ActCode",
					"code": "AMB",
					"display": "ambulatory"
					},
					"subject": { "reference": "Patient/'.$context['pasien_satusehat_id'].'",
					"display": "'.$context['pasien_nama'].'"
					},
					"participant": [
					{ "type": [
					{
						"coding": [
						{
							"system": "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
							"code": "ATND",
							"display": "attender"
						}
						]
					}
					],
					"individual": {
						"reference": "Practitioner/'.$context['dokter_satusehat_id'].'",
						"display": "'.$context['dokter_nama'].'"
					}
				}
				],"period": {
					"start": "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'"
					},
					"location": [
					{ "location": {
						"reference": "Location/'.$context['lokasi_satusehat_id'].'",
						"display": "'.$context['lokasi_satusehat_description'].'"
					}
				}
				],
				"statusHistory": [
				{
					"status": "arrived",
					"period": {
						"start": "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'",
						"end": "'.$context['tgl_selesai'].'T'.$context['jam_selesai'].''.$pengaturan->kode_waktu.'"
					}
				}
				],
				"serviceProvider": { "reference": "Organization/'.$pengaturan->satusehat_id.'"
				},
				"identifier": [
				{
					"system": "http://sys-ids.kemkes.go.id/encounter/'.$pengaturan->satusehat_id.'",
					"value": "'.$context['no_rawat'].'"
				}
				]
			}';
			break;

			case 'condition':
			$url = $pengaturan->satusehat_url_fhir.'/Condition';
			$data = '{
				"resourceType": "Condition",
				"clinicalStatus": 
				{ "coding": 
				[
				{
					"system": "http://terminology.hl7.org/CodeSystem/condition-clinical", 
					"code": "active", 
					"display": "Active" 
				}
				]
				},
				"category": 
				[
				{
					"coding": 
					[
					{
						"system": "http://terminology.hl7.org/CodeSystem/condition-category",
						"code": "encounter-diagnosis",
						"display": "Encounter Diagnosis"
					}
					]
				}
				],
				"code": 
				{ "coding": [
				{
					"system": "http://hl7.org/fhir/sid/icd-10",
					"code": "'.$context['icd10_id'].'",
					"display": "'.$context['icd10_value'].'"
				}
				]
				},
				"subject": {
					"reference": "Patient/'.$context['pasien_satusehat_id'].'",
					"display": "'.$context['pasien_nama'].'"
					},
					"encounter": {
						"reference": "Encounter/'.$context['encounter_satusehat_id'].'",
						"display": "'.$context['no_rawat'].' '.$context['pasien_nama'].' dari tanggal '.$context['tgl_daftar'].'"
					}
				}';
				break;

				case 'observation':
				$url = $pengaturan->satusehat_url_fhir.'/Observation';

				if(isset($context['parameter']['valueQuantity']))
				{
					$array_3 = '"valueQuantity": { "system": "'.$context['parameter']['valueQuantity']['system'].'",
					"value": '.$context['parameter']['valueQuantity']['value'].',
					"unit": "'.$context['parameter']['valueQuantity']['unit'].'",
					"code": "'.$context['parameter']['valueQuantity']['code'].'" }';
				}
				else if(isset($context['parameter']['valueCodeableConcept']))
				{
					$array_3 = '"valueCodeableConcept": {"text": "'.$context['parameter']['valueCodeableConcept']['text'].'" }';
				}

				$data = '{	"resourceType": "Observation",
				"status": "final",
				"category": [
				{
					"coding": [
					{
						"system": "'.$context['parameter']['category']['system'].'",
						"code": "'.$context['parameter']['category']['code'].'",
						"display": "'.$context['parameter']['category']['display'].'"
					}
					]
				}
				],
				"code": {	"coding": [
				{
					"system": "'.$context['parameter']['code']['system'].'",
					"code": "'.$context['parameter']['code']['code'].'",
					"display": "'.$context['parameter']['code']['display'].'"
				}
				]
				},
				"subject": { "reference": "Patient/'.$context['pasien_satusehat_id'].'"
				},
				"performer": [
				{
					"reference": "Practitioner/'.$context['dokter_satusehat_id'].'"
				}
				],
				"encounter": {	"reference": "Encounter/'.$context['encounter_satusehat_id'].'",
				"display": "'.$context['no_rawat'].' '.$context['pasien_nama'].' dari tanggal '.$context['tgl_daftar'].'"
				},
				"effectiveDateTime": "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'",
				"issued": "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'",
				'.$array_3.'
			}';
			break;

			case 'procedure':
			$url = $pengaturan->satusehat_url_fhir.'/Procedure';
			$data = '{
				"resourceType": "Procedure",
				"status": "completed",
				"category": 
				{ 
					"coding": [
					{
						"system": "http://snomed.info/sct",
						"code": "103693007",
						"display": "Diagnostic procedure
					}
					],
					"text":"Diagnostic procedure"
					},
					"code": { "coding": [
					{
						"system": "http://hl7.org/fhir/sid/icd-9-cm",
						"code": "'.$context['icd_9'].'",
						"display": "'.$context['icd_9_value'].'"
					}
					]
					},
					"subject": { "reference": "Patient/'.$context['pasien_satusehat_id'].'", 
					"display": "'.$context['pasien_nama'].'"},
					"encounter": { "reference": "Encounter/"'.$context['encounter_satusehat_id'].'",
					"display": "Prosedur "'.$context['tindakan_nama'].'" selama kunjungan tanggal "'.$context['tgl_daftar'].'"
					},
					"performedPeriod": { "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'",
					"end": "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'"
				}
			}';
			break;

			case 'composition':
			$url = $pengaturan->satusehat_url_fhir.'/Composition';
			$data = '{
				"resourceType": "Composition",
				"identifier": {
					"system": "http://sys-ids.kemkes.go.id/composition/'.$pengaturan->satusehat_id.'",
					"value": "'.$context['no_rawat'].'"
					},
					"status": "final",
					"type": { "coding": [
					{
						"system": "http://loinc.org",
						"code": "18842-5",
						"display": "Discharge summary"
					}
					]
					},
					"category": [
					{
						"coding": [
						{
							"system": "http://loinc.org",
							"code": "LP173421-1",
							"display": "Report"
						}
						]
					}
					],
					"subject": { "reference": "Patient/'.$context['pasien_satusehat_id'].'",
					"display": "'.$context['pasien_nama'].'"
					},
					"encounter": { "reference": "Encounter/'.$context['encounter_satusehat_id'].'",
					"display": "Kunjungan '.$context['pasien_nama'].' tanggal '.$context['tgl_daftar'].'"
					},
					"date": "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'",
					"author": [
					{
						"reference": "Practitioner/'.$context['dokter_satusehat_id'].'",
						"display": "'.$context['dokter_nama'].'"
					}
					],
					"title": "Resume Medis Rawat Jalan",
					"custodian": { "reference": "Organization/'.$pengaturan->satusehat_id.'"
					},
					"section": [
					{
						"code": { "coding": [
						{
							"system": "http://loinc.org",
							"code": "42344-2",
							"display": "Discharge diet (narrative)"
						}
						]
						},
						"text": { "status": "additional",
						"div": "'.$context['diet'].'"
					}
				}
				]
			}';
			break;

			case 'clinical_impression':
			$url = $pengaturan->satusehat_url_fhir.'/ClinicalImpression';
			$data = '{
				"resourceType": "ClinicalImpression",
				"status": "completed",
				"description" : "-",
				"subject": { "reference": "Patient/'.$context['pasien_satusehat_id'].'",
				"display": "'.$context['pasien_nama'].'"
				},
				"encounter": { "reference": "Encounter/'.$context['encounter_satusehat_id'].'",
				"display": "Kunjungan '.$context['pasien_nama'].' tanggal '.$context['tgl_daftar'].'"
				},
				"effectiveDateTime": "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'",
				"date": "'.$context['tgl_daftar'].'T'.$context['jam_daftar'].''.$pengaturan->kode_waktu.'",
				"assessor" : {"reference": "Practitioner/'.$context['dokter_satusehat_id'].'"
				},
				"summary" : "'.$context['anamnesa'].'",
				"finding": [ 
				{ 
					"itemCodeableConcept": { "coding": [
					{
						"system": "http://hl7.org/fhir/sid/icd-10",
						"code": "'.$context['icd10_id'].'",
						"display": "'.$context['icd10_value'].'"
					}
					]
					},
					"itemReference": {
						"reference": "Condition/'.$context['condition_satusehat_id'].'"
					}
				}
				],
				"prognosisCodeableConcept": [
				{
					"coding": [
					{
						"system": "http://terminology.kemkes.go.id/CodeSystem/clinical-term",
						"code": "PR000001",
						"display": "Prognosis"
					}
					]
				}
				]
			}';
			break;

			case 'medication':
			$url = $pengaturan->satusehat_url_fhir.'/Medication';
			$data = '{
				"resourceType": "Medication",
				"meta": {"profile": ["https://fhir.kemkes.go.id/r4/StructureDefinition/Medication"]},
				"identifier": [
				{
					"system" : "http://sys-ids.kemkes.go.id/medication/"'.$pengaturan->satusehat_id.'",
					"use": "official",
					"value" : 
				}
				],
				"code": { 
					"coding": [
					{
						"system": "'.$context['satusehat_kfa_system'].'",
						"code": "'.$context['satusehat_kfa_code'].'",
						"display": "'.$context['satusehat_kfa_display'].'"
					}
					]
					},
					"status": "'.$context['status'].'",
					"form": { "coding": 
					[
					{
						"system": "'.$context['satusehat_form_system'].'",
						"code": "'.$context['satusehat_form_code'].'",
						"display": "'.$context['satusehat_form_display'].'"
					}
					]
					},
					"extension": [
					{
						"url": "https://fhir.kemkes.go.id/r4/StructureDefinition/MedicationType",
						"valueCodeableConcept": {
						"coding": [
						{
							"system": "http://terminology.kemkes.go.id/CodeSystem/medication-type",
							"code": "NC",
							"display": "Non-compound"
						}
						]
					}
				}
				]
			}';
			break;
		}

		$response = $this->execute($data, 'POST', $url, $pengaturan->satusehat_access_token); 

		if(isset($response['issue']))
		{
			if($response['issue'][0]->code == 'invalid-access-token')
			{
				$response = $this->getToken();

				if($response == 'success') $response = $this->execute($data, 'POST', $url, $pengaturan->satusehat_access_token); 
			}
			else 
			{
				$response = array('eror' => 'warning', 'pesan' => $response['issue'][0]->details->text, 'data' => $response, 'send_data' => $data);
			}
		}

		return $response;
	}

	public function put($context)
	{
		$url = '';

		$data = array();

		$pengaturan = $this->db->select('*, a_kab.value AS kabupaten_value')->from('pengaturan p')->join('satusehat_mapping_organisasi s_mo', 's_mo.organization_id=p.satusehat_id', 'left')->join('asset_kabupaten a_kab', 'a_kab.kode=p.satusehat_kabupaten', 'left')->get()->row();

		$service_name = $context['service_name'];

		switch($service_name)
		{			
			case 'location':
			$url = $pengaturan->satusehat_url_fhir.'/Location/'.$context['id'];
			$data = '{
				"resourceType": "Location",
				"id": "'.$context['id'].'",
				"identifier": [
				{
					"system": "http://sys-ids.kemkes.go.id/location/'.$context['satusehat_id'].'",
					"value": "'.$context['kode'].'"
				}
				],
				"status": "'.$context['status'].'",
				"name": "'.$context['kode'].'",
				"description": "'.$context['kode'].', '.$pengaturan->coding_display.'",
				"mode": "instance",
				"telecom": [
				{ "system": "phone",
				"value": "'.$context['no_telp'].'",
				"use": "work"
				},
				{ "system": "email",
				"value": "'.$context['email'].'",
				"use": "work"
				},
				{ "system": "url",
				"value": "www.'.$context['email'].'",
				"use": "work"
			}
			],
			"address": { 
				"use": "work",
				"line": [
				"'.$pengaturan->alamat.'"
				],
				"city": "'.$pengaturan->kabupaten_value.'",
				"postalCode": "'.$pengaturan->satusehat_kodepos.'",
				"country": "ID",
				"extension": [
				{
					"url": "https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode",
					"extension": [
					{ "url": "province",
					"valueCode": "'.$pengaturan->satusehat_propinsi.'"
					},
					{ "url": "city",
					"valueCode": "'.$pengaturan->satusehat_kabupaten.'"
					},
					{ "url": "district",
					"valueCode": "'.$pengaturan->satusehat_kecamatan.'"
					},
					{ "url": "village",
					"valueCode": "'.$pengaturan->satusehat_kelurahan.'"
					},
					{ "url": "rt",
					"valueCode": "'.$pengaturan->satusehat_rt.'"
					},
					{ "url": "rw",
					"valueCode": "'.$pengaturan->satusehat_rw.'"
				}
				]
			}
			]
			},
			"physicalType": { "coding": [
			{
				"system": "http://terminology.hl7.org/CodeSystem/location-physical-type",
				"code": "ro",
				"display": "Room"
			}
			]
			},
			"position": {
				"longitude": '.$context['position_longitude'].',
				"latitude": '.$context['position_latitude'].',
				"altitude": '.$context['position_altitude'].'
				},
				"managingOrganization": {
					"reference": "Organization/'.$context['satusehat_id'].'"
				}
			}';

			break;
		}

		$response = $this->execute($data, 'PUT', $url, $pengaturan->satusehat_access_token);

		if(isset($response['issue']))
		{
			if($response['issue'][0]->code == 'invalid-access-token')
			{
				$response = $this->getToken();

				if($response == 'success') $response = $this->execute($data, 'PUT', $url, $pengaturan->satusehat_access_token); 
			}
			else 
			{
				$response = array('eror' => 'warning', 'pesan' => $response['issue'][0]->details->text, 'data' => $response);
			}
		}

		return $response;
	}

	public function patch($context)
	{
		$url = '';

		$data = array();

		$pengaturan = $this->db->select('*')->from('pengaturan')->get()->row();

		$service_name = $context['service_name'];

		switch($service_name)
		{			
			case 'organization':
			$url = $pengaturan->satusehat_url_fhir.'/Organization/'.$context['id'];
			break;

			case 'location':
			$url = $pengaturan->satusehat_url_fhir.'/Location/'.$context['id'];
			break;
		}

		$data = '{
			"op" : "replace",
			"path" : "/status",
			"value" : "'.$context['status'].'"
		}';

		$response = $this->execute($data, 'PATCH', $url, $pengaturan->satusehat_access_token);

		if(isset($response['issue']))
		{
			if($response['issue'][0]->code == 'invalid-access-token')
			{
				$response = $this->getToken();

				if($response == 'success') $response = $this->execute($data, 'PATCH', $url, $pengaturan->satusehat_access_token); 
			}
			else 
			{
				$response = array('eror' => 'warning', 'pesan' => $response['issue'][0]->details->text, 'data' => $response);
			}
		}

		return $response;
	}

	public function execute($data, $type, $url, $access_token)
	{
		$curl = curl_init();

		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_ENCODING, '');
		curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
		curl_setopt($curl, CURLOPT_TIMEOUT, 0);
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Authorization: Bearer '.$access_token));
		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $type);

		if(!empty($data)) curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

		$response = json_decode(curl_exec($curl));

		curl_close($curl);
		return (array) $response;
	}
}