<?php

class Asset_bpjs_jenis_kartu_model extends CI_Model {

	private $_table_name = "asset_jenis_kartu";
	private $_table_sql = "asset_jenis_kartu a_jk";

	public function tabel_data()
	{		
		$this->db->select('a_jk.*,');
		$this->db->from($this->_table_sql);		

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{
		$id =  $context['id'];
		
		$this->db->select('a_jk.*');
		$this->db->from($this->_table_sql);
		$this->db->where('a_jk.id', $id);
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->value = '';
		$this->status = '';

		return $this;
	}

	public function add_data($context)
	{
		$this->value = $context['value'];
		$this->id = $context['id'];
		$this->status = $context['status'];

		$query = $this->db->insert($this->_table_name, $this);

		$notif = $this->get_notif_query('Tambah');

		return $notif;
	}

	public function update_data($context)
	{		
		$this->value = $context['value'];
		$this->id = $context['id'];
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id_old'])->update($this->_table_name, $this);

		$notif = $this->get_notif_query('Update');

		return $notif;
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);

		$notif = $this->get_notif_query('Hapus');

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif_query($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}
}	