<?php

class Asset_jenis_obat_model extends CI_Model {

	private $_table_name = "asset_jenis_obat";
	private $_table_sql = "asset_jenis_obat a_jo";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$this->db->select('a_jo.*,');
		$this->db->from($this->_table_sql);		

		if($keyword != "") $this->db->where("a_jo.id LIKE '%$keyword%' OR a_jo.value LIKE '%$keyword%'");

		$this->db->order_by('a_jo.id', 'ASC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$this->db->select('a_jo.*');
		$this->db->from($this->_table_sql);
		
		if($keyword != "") $this->db->where("a_jo.id LIKE '%$keyword%' OR a_jo.value LIKE '%$keyword%'");

		return $this->db->get()->num_rows();
	}

	public function lihat_data($context)
	{
		$id =  $context['id'];
		
		$this->db->select('a_jo.*');
		$this->db->from($this->_table_sql);
		$this->db->where('a_jo.id', $id);
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->value = '';
		$this->satusehat_form_code = '';
		$this->satusehat_form_system = '';
		$this->satusehat_form_display = '';
		$this->status = '';

		return $this;
	}

	public function add_data($context)
	{
		$this->value = $context['value'];
		$this->satusehat_form_code = $context['satusehat_form_code'];
		$this->satusehat_form_system = $context['satusehat_form_system'];
		$this->satusehat_form_display = $context['satusehat_form_display'];
		$this->status = $context['status'];

		$query = $this->db->insert($this->_table_name, $this);

		$notif = $this->get_notif_query('Tambah');

		return $notif;
	}

	public function update_data($context)
	{		
		$this->value = $context['value'];
		$this->satusehat_form_code = $context['satusehat_form_code'];
		$this->satusehat_form_system = $context['satusehat_form_system'];
		$this->satusehat_form_display = $context['satusehat_form_display'];
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);

		$notif = $this->get_notif_query('Update');

		return $notif;
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);

		$notif = $this->get_notif_query('Hapus');

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif_query($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}
}	