<?php

class Asset_model extends CI_Model {

	private $_table_name = "asset";
	private $_table_sql = "asset a";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$this->db->select('*');
		$this->db->from($this->_table_sql);

		if($keyword != "")	$this->db->where("value LIKE '%$keyword%'");

		$this->db->order_by('status, value', 'ASC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$this->db->select('*');
		$this->db->from($this->_table_sql);

		if($keyword != "")	$this->db->where("value LIKE '%$keyword%'");

		return $this->db->get()->num_rows();
	}

	public function lihat_data($context)
	{
		$id =  $context['id'];

		$this->db->select('*');
		$this->db->from($this->_table_sql);	
		$this->db->where('id', $id);
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->value = '';
		$this->table_name = '';
		$this->status = '';

		return $this;
	}

	public function add_data($context)
	{
		$this->value = $context['value'];
		$this->table_name = $context['table_name'];
		$this->status = $context['status'];	
		$this->created_date = date('Y-m-d H:i:s');

		$query = $this->db->insert($this->_table_name, $this);

		if($query || $query['code'] == 1062) $this->db->query("CREATE TABLE `$this->table_name` (
			`id` varchar(10) NOT NULL,
			`value` varchar(200) NOT NULL,
			`status` enum('Aktif','Tidak Aktif') NOT NULL DEFAULT 'Aktif',
			`created_date` datetime NOT NULL,
			PRIMARY KEY (`id`)
		) ENGINE=InnoDB DEFAULT CHARSET=latin1");

		$notif = $this->get_notif_query('Tambah');

		return $notif;
	}

	public function update_data($context)
	{		
		$this->value = $context['value'];
		$this->table_name = $context['table_name'];	
		$this->status = $context['status'];	

		$table_name_old = $context['table_name_old'];

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);

		if($this->table_name != $table_name_old)
		{
			if($query) $this->db->query("ALTER TABLE `$table_name_old` RENAME TO `$this->table_name`");
		} 

		$notif = $this->get_notif_query('Update');

		return $notif;
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$table_name = $this->lihat_data($context)->table_name;

		$query = $this->db->where('id', $id)->delete($this->_table_name);

		if($query) $this->db->query("DROP TABLE `$table_name`");

		$notif = $this->get_notif_query('Hapus');

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif_query($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else if($eror['code'] == 1451){
			$notif = array('eror'=>'warning', 'pesan'=>'Data terhubung dengan tabel lain');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}
}	