<?php

class Asset_satusehat_model extends CI_Model {

	private $_error = "";
	private $_table_name = "asset_satusehat";
	private $_table_sql = "asset_satusehat a_b";

	public function tabel_data($context)
	{		
		$table_name = $context['table_name'];

		$data['column_name'] = $this->db->list_fields($table_name);

		$data['result'] = $this->db->from($table_name)->get()->result();

		return $data;
	}

	public function tabel_data_2($context)
	{		
		$table_name = 'bpjs_asset_'.$context['asset'];

		$data['column_name'] = $this->db->list_fields($table_name);

		$this->db->from($table_name);

		$i = 0;

		foreach ($context as $key => $value) 
		{
			if($i > 0) $this->db->where($key, $value);

			$i++;
		}

		$data['result'] = $this->db->get()->result();

		return $data;
	}

	public function update_data($context)
	{				
		$table_name = $context['table_name'];

		if(isset($context['bpjs']['metaData']))
		{
			if($context['bpjs']['metaData']['code'] == '200')
			{
				for ($i=0; $i < count($context['bpjs']['result']['list']) ; $i++) 
				{ 
					$query = $this->db->insert($table_name, $context['bpjs']['result']['list'][$i]);

					if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
				}
			}
			else $this->_error .= $context['bpjs']['metaData']['code'].' - '.$context['bpjs']['metaData']['message'];
		} 
		else $this->_error .= 'Tidak terkoneksi dengan BPJS';

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error, 'data' => $context['bpjs']);

		return $notif;
	}

	public function add_data($context)
	{
		switch ($context['service_name'])
		{
			case 'pendaftaran_provider':

			foreach ($context['data']['result']['list'] as $key) 
			{
				$this->noUrut = $key['noUrut'];
				$this->tglDaftar = $key['tglDaftar'];
				$this->peserta_noKartu = $key['peserta']['noKartu'];

				$cek_data = $this->db->where('tglDaftar', $this->tglDaftar)->where('peserta_noKartu', $this->peserta_noKartu)->get('bpjs_pendaftaran_provider')->result();

				if(empty($cek_data))
				{
					$query = $this->db->insert('bpjs_pendaftaran_provider', $this);

					if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
				}
			}

			break;
		}

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}


	//--------------------------------------------------------------------------------------------

	public function select_data()
	{		
		$query = $this->db->from($this->_table_name)->order_by('value')->get()->result();

		return $query;
	}

	//--------------------------------------------------------------------------------------------

	public function select_tabel($tabel_name)
	{		
		$query = $this->db->from($tabel_name)->get()->result();

		return $query;
	}

	//--------------------------------------------------------------------------------------------

	public function mysql_get_error()
	{
		$error = $this->db->error();

		switch ($error['code']) 
		{
			case '1062':
			$error_detail = 'Data sudah ada';
			break;
			
			default:
			$error_detail = "$eror[code]: $eror[message]";
			break;
		}

		return $error_detail;		
	}
}	