<?php

class Data_debitur_model extends CI_Model {

	private $_table_name = "asset_debitur";
	private $_table_sql = "asset_debitur a_d";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$this->db->select('a_d.*, 
			a_kd.value AS kategori_value');
		$this->db->from($this->_table_sql);		
		$this->db->join('asset_kategori_debitur a_kd', 'a_kd.id=a_d.kategori', 'left');	

		if($keyword != "")	$this->db->where("a_d.value LIKE '%$keyword%'");

		$this->db->order_by('a_d.value', 'ASC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$this->db->select('a_d.*');
		$this->db->from($this->_table_sql);

		return $this->db->get()->num_rows();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('a_d.*');
		$this->db->from($this->_table_sql);
		$this->db->where('a_d.id', $id);
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->value = '';
		$this->kode = '';
		$this->kategori = '';
		$this->status = '';

		return $this;
	}

	public function add_data($context)
	{
		$this->value = $context['value'];
		$this->kode = $context['kode'];
		$this->kategori = $context['kategori'];
		$this->status = $context['status'];
		$this->created_date = date('Y-m-d H:i:s');

		$query = $this->db->insert($this->_table_name, $this);

		return $this->get_notif('Tambah');
	}

	public function update_data($context)
	{		
		$this->value = $context['value'];
		$this->kode = $context['kode'];
		$this->kategori = $context['kategori'];
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);	

		return $this->get_notif('Update');
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);		

		return $this->get_notif('Hapus');
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	