<?php

class Data_dokter_model extends CI_Model {

	private $_error = "";
	private $_table_name = "data_dokter";
	private $_table_sql = "data_dokter d_d";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$this->db->select('d_d.*');
		$this->db->from($this->_table_sql);	

		if($keyword != "")	$this->db->where("d_d.nama LIKE '%$keyword%'");

		$this->db->order_by('d_d.nama', 'ASC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$this->db->select('d_d.*');
		$this->db->from($this->_table_sql);
		
		if($keyword != "")	$this->db->where("d_d.nama LIKE '%$keyword%'");

		return $this->db->get()->num_rows();
	}

	public function tabel_all()
	{		
		$this->db->select('d_d.*');
		$this->db->from($this->_table_sql);	
		$this->db->order_by('d_d.nama', 'ASC');	

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_d.*');
		$this->db->from($this->_table_sql);
		$this->db->where('d_d.id', $id);
		
		return $this->db->get()->row();
	}

	public function lihat_data_jadwal_praktek()
	{
		$this->db->select('d_d.*');
		$this->db->from($this->_table_sql);
		$this->db->where('d_d.utama', '1');
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->nama = '';
		$this->nik = '';
		$this->bpjs_kdDokter = '';
		$this->bpjs_nmDokter = '';
		$this->utama = '';
		$this->senin_pagi = '00:00-00:00';
		$this->senin_sore = '00:00-00:00';
		$this->selasa_pagi = '00:00-00:00';
		$this->selasa_sore = '00:00-00:00';		
		$this->rabu_pagi = '00:00-00:00';
		$this->rabu_sore = '00:00-00:00';
		$this->kamis_pagi = '00:00-00:00';
		$this->kamis_sore = '00:00-00:00';
		$this->jumat_pagi = '00:00-00:00';
		$this->jumat_sore = '00:00-00:00';
		$this->sabtu_pagi = '00:00-00:00';
		$this->sabtu_sore = '00:00-00:00';
		$this->minggu_pagi = '00:00-00:00';
		$this->minggu_sore = '00:00-00:00';
		$this->status = '';

		return $this;
	}

	public function add_data($context)
	{
		if($context['bpjs_kdDokter'] == '-')
		{
			$this->id = $context['id'];
		}
		else $this->id = $context['bpjs_kdDokter'];

		$this->nama = $context['nama'];
		$this->nik = $context['nik'];

		$this->bpjs_kdDokter = $context['bpjs_kdDokter'];
		$this->bpjs_nmDokter = $context['bpjs_nmDokter'];		

		if(isset($context['utama']))
		{
			$this->db->update($this->_table_name, ['utama' => 0]);

			$this->utama = $context['utama'];
		}

		$this->senin_pagi = $context['senin_mulai_pagi'].'-'.$context['senin_selesai_pagi'];
		$this->senin_sore = $context['senin_mulai_sore'].'-'.$context['senin_selesai_sore'];
		$this->selasa_pagi = $context['selasa_mulai_pagi'].'-'.$context['selasa_selesai_pagi'];
		$this->selasa_sore = $context['selasa_mulai_sore'].'-'.$context['selasa_selesai_sore'];		
		$this->rabu_pagi = $context['rabu_mulai_pagi'].'-'.$context['rabu_selesai_pagi'];
		$this->rabu_sore = $context['rabu_mulai_sore'].'-'.$context['rabu_selesai_sore'];
		$this->kamis_pagi = $context['kamis_mulai_pagi'].'-'.$context['kamis_selesai_pagi'];
		$this->kamis_sore = $context['kamis_mulai_sore'].'-'.$context['kamis_selesai_sore'];
		$this->jumat_pagi = $context['jumat_mulai_pagi'].'-'.$context['jumat_selesai_pagi'];
		$this->jumat_sore = $context['jumat_mulai_sore'].'-'.$context['jumat_selesai_sore'];
		$this->sabtu_pagi = $context['sabtu_mulai_pagi'].'-'.$context['sabtu_selesai_pagi'];
		$this->sabtu_sore = $context['sabtu_mulai_sore'].'-'.$context['sabtu_selesai_sore'];
		$this->minggu_pagi = $context['minggu_mulai_pagi'].'-'.$context['minggu_selesai_pagi'];
		$this->minggu_sore = $context['minggu_mulai_sore'].'-'.$context['minggu_selesai_sore'];

		$this->created_date = date('Y-m-d H:i:s');

		$query = $this->db->insert($this->_table_name, $this);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 	

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Tambah data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}
	
	public function update_data($context)
	{
		if($context['id'] != '-' )
		{
			$this->id = $context['id'];
		}
		else $this->id = $context['bpjs_kdDokter'];
		
		$this->nama = $context['nama'];
		$this->nik = $context['nik'];

		$this->bpjs_kdDokter = $context['bpjs_kdDokter'];
		$this->bpjs_nmDokter = $context['bpjs_nmDokter'];
		$this->status = $context['status'];

		if(isset($context['utama']))
		{
			$this->db->update($this->_table_name, ['utama' => 0]);

			$this->utama = $context['utama'];
		}

		$this->senin_pagi = $context['senin_mulai_pagi'].'-'.$context['senin_selesai_pagi'];
		$this->senin_sore = $context['senin_mulai_sore'].'-'.$context['senin_selesai_sore'];
		$this->selasa_pagi = $context['selasa_mulai_pagi'].'-'.$context['selasa_selesai_pagi'];
		$this->selasa_sore = $context['selasa_mulai_sore'].'-'.$context['selasa_selesai_sore'];		
		$this->rabu_pagi = $context['rabu_mulai_pagi'].'-'.$context['rabu_selesai_pagi'];
		$this->rabu_sore = $context['rabu_mulai_sore'].'-'.$context['rabu_selesai_sore'];
		$this->kamis_pagi = $context['kamis_mulai_pagi'].'-'.$context['kamis_selesai_pagi'];
		$this->kamis_sore = $context['kamis_mulai_sore'].'-'.$context['kamis_selesai_sore'];
		$this->jumat_pagi = $context['jumat_mulai_pagi'].'-'.$context['jumat_selesai_pagi'];
		$this->jumat_sore = $context['jumat_mulai_sore'].'-'.$context['jumat_selesai_sore'];
		$this->sabtu_pagi = $context['sabtu_mulai_pagi'].'-'.$context['sabtu_selesai_pagi'];
		$this->sabtu_sore = $context['sabtu_mulai_sore'].'-'.$context['sabtu_selesai_sore'];
		$this->minggu_pagi = $context['minggu_mulai_pagi'].'-'.$context['minggu_selesai_pagi'];
		$this->minggu_sore = $context['minggu_mulai_sore'].'-'.$context['minggu_selesai_sore'];
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id_lama'])->update($this->_table_name, $this);	

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 	

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}
	
	public function update_satusehat($context)
	{
		if(isset($context['entry']))
		{
			$this->satusehat_id = $context['entry'][0]->resource->id;

			$query = $this->db->where('nik', $context['entry'][0]->resource->identifier[1]->value)->update($this->_table_name, $this);
		}
		else $notif = array('eror' => 'warning', 'pesan' => 'Data Kosong', 'data' => $context);

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}

	public function delete_satusehat($context)
	{
		$id = $context['id'];
		
		$query = $this->db->where('id', $id)->update($this->_table_name, ['satusehat_id' => '']);	

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 	

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Hapus data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}

	public function delete_data($context)
	{
		$id = $context['id'];
		
		$query = $this->db->where('id', $id)->delete($this->_table_name);	

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 	

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Hapus data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function select_data()
	{	
		$this->db->select('d_d.*, d_d.nama AS value');
		$this->db->from($this->_table_sql);
		$this->db->where('d_d.status', 'Aktif');
		$this->db->order_by('d_d.utama', 'DESC');
		$this->db->order_by('d_d.nama');
		
		return $this->db->get()->result();
	}

	public function select_satu_sehat()
	{	
		$this->db->select('d_d.nik AS id, d_d.nama AS value');
		$this->db->from($this->_table_sql);
		$this->db->where('d_d.status', 'Aktif');
		$this->db->where('d_d.nik!=""');
		$this->db->order_by('d_d.nama');
		
		return $this->db->get()->result();
	}

	//--------------------------------------------------------------------------------------------

	public function mysql_get_error()
	{
		$error = $this->db->error();

		switch ($error['code']) 
		{
			case '1062':
			$error_detail = 'Data sudah ada';
			break;
			
			default:
			$error_detail = "$eror[code]: $eror[message]";
			break;
		}

		return $error_detail;		
	}

}	