<?php

class Data_jasa_pemeriksaan_model extends CI_Model {

	private $_table_name = "data_jasa_pemeriksaan";
	private $_table_sql = "data_jasa_pemeriksaan d_jp";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$this->db->select('d_jp.*, 
			a_d.value AS debitur_value');
		$this->db->from($this->_table_sql);		
		$this->db->join('asset_debitur a_d', 'a_d.id=d_jp.debitur', 'left');	

		if($keyword != "") $this->db->where("d_jp.value LIKE '%$keyword%'");

		$this->db->order_by('d_jp.debitur, d_jp.value', 'ASC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$this->db->select('d_jp.*');
		$this->db->from($this->_table_sql);

		if($keyword != "") $this->db->where("d_jp.value LIKE '%$keyword%'");

		return $this->db->get()->num_rows();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_jp.*');
		$this->db->from($this->_table_sql);
		$this->db->where('d_jp.id', $id);
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->value = '';
		$this->debitur = '';
		$this->total = '';
		$this->status = '';

		return $this;
	}

	public function add_data($context)
	{		
		$this->value = $context['value'];
		$this->debitur = $context['debitur'];
		$this->total = $context['total'];
		$this->status = $context['status'];
		$this->created_date = date('Y-m-d H:i:s');

		$query = $this->db->insert($this->_table_name, $this);

		return $this->get_notif('Tambah');
	}

	public function update_data($context)
	{		
		$this->value = $context['value'];
		$this->debitur = $context['debitur'];
		$this->total = $context['total'];
		$this->status = $context['status'];
		
		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);	

		return $this->get_notif('Update');
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);		

		return $this->get_notif('Hapus');
	}

	//--------------------------------------------------------------------------------------------

	public function select_data($debitur)
	{	
		$this->db->select('*');
		$this->db->from($this->_table_sql);
		$this->db->where('d_jp.status', 'Aktif');
		$this->db->order_by('d_jp.value');
		
		return $this->db->get()->result();
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	