<?php

class Data_mjkn_model extends CI_Model {
	
	private $_error = "";
	private $_table_name = "data_pendaftaran_jkn";
	private $_table_sql = "data_pendaftaran_jkn d_pj";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);

		$this->db->select('
			d_pj.id,
			d_pj.status,
			d_pen.tgl_daftar,
			d_pen.umur,
			d_pen.urut,
			d_pas.nama,
			d_pas.no_rm,
			a_d.value AS debitur_value');
		$this->db->from($this->_table_sql);		
		$this->db->join('data_pendaftaran d_pen', 'd_pen.no_rawat=d_pj.no_rawat', 'left');
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	

		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if(isset($tgl['awal']) && isset($tgl['akhir'])) $this->db->where("d_pen.tgl_daftar BETWEEN '".$tgl['awal']."' AND '".$tgl['akhir']."'");

		$this->db->order_by('d_pj.created_date', 'DESC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);
		
		$this->db->select('d_pj.*');
		$this->db->from($this->_table_sql);
		$this->db->join('data_pendaftaran d_pen', 'd_pen.no_rawat=d_pj.no_rawat', 'left');
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');

		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if(isset($tgl['awal']) && isset($tgl['akhir'])) $this->db->where("d_pen.tgl_daftar BETWEEN '".$tgl['awal']."' AND '".$tgl['akhir']."'");

		return $this->db->get()->num_rows();
	}

	public function data_hari_ini($context)
	{		
		$this->db->select('*');
		$this->db->from($this->_table_sql);		
		$this->db->join('data_pendaftaran d_pen', 'd_pen.no_rawat=d_pj.no_rawat', 'left');
		$this->db->where('d_pen.tgl_daftar', $context['tgl_daftar']);
		$this->db->where('d_pen.no_rm', $context['no_rm']);

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_pj.*,
			a_d.value AS debitur_value,
			d_d.id AS kdDokter');
		$this->db->from($this->_table_sql);
		$this->db->join('data_pendaftaran d_pen', 'd_pen.no_rawat=d_pj.no_rawat', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');
		$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');	
		$this->db->where('d_pj.id', $id);
		
		return $this->db->get()->row();
	}

	public function update_data($context)
	{
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);	

		return $this->get_notif('Update');
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error();

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Delete data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function convert_range_tgl($range)
	{
		$split = explode(' - ', $range);

		if(isset($split[0]))
		{
			$tgl['awal'] = substr($split[0],6,4).'-'.substr($split[0],3,2).'-'.substr($split[0],0,2);
		}

		if(isset($split[1]))
		{
			$tgl['akhir'] = substr($split[1],6,4).'-'.substr($split[1],3,2).'-'.substr($split[1],0,2);
		}

		return $tgl;
	}

	//--------------------------------------------------------------------------------------------

	public function mysql_get_error()
	{
		$error = $this->db->error();

		switch ($error['code']) 
		{
			case '1062':
			$error_detail = 'Data sudah ada';
			break;

			case '1451':
			$error_detail = 'Pasien sudah di periksa. Silakan hapus dulu data pemeriksaan';
			break;
			
			default:
			$error_detail = "$error[code]: $error[message]";
			break;
		}

		return $error_detail;		
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	