<?php

class Data_obat_model extends CI_Model {

	private $_table_name = "data_obat";
	private $_table_sql = "data_obat d_o";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$this->db->select('d_o.*, 
			a_s.value AS satuan_value,
			a_ko.value AS kategori_value,
			a_jo.value AS jenis_value,
			a_jo.satusehat_form_code,
			a_jo.satusehat_form_system,
			a_jo.satusehat_form_display');
		$this->db->from($this->_table_sql);
		$this->db->join('asset_satuan a_s', 'a_s.id=d_o.satuan', 'left');		
		$this->db->join('asset_kategori_obat a_ko', 'a_ko.id=d_o.kategori', 'left');
		$this->db->join('asset_jenis_obat a_jo', 'a_jo.id=d_o.jenis', 'left');	

		if($keyword != "")	$this->db->where("d_o.nama LIKE '%$keyword%'");

		$this->db->order_by('d_o.nama', 'ASC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$this->db->select('d_o.*');
		$this->db->from($this->_table_sql);

		if($keyword != "")	$this->db->where("d_o.nama LIKE '%$keyword%'");

		return $this->db->get()->num_rows();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_o.*,
			a_jo.satusehat_form_code,
			a_jo.satusehat_form_system,
			a_jo.satusehat_form_display');
		$this->db->from($this->_table_sql);
		$this->db->join('asset_jenis_obat a_jo', 'a_jo.id=d_o.jenis', 'left');	
		$this->db->where('d_o.id', $id);
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->nama = '';
		$this->harga = '';
		$this->aturan_pakai = '';
		$this->tersedia = '';
		$this->satuan = '';
		$this->kategori = '';
		$this->jenis = '';
		$this->bpjs_pcare_id = '';
		$this->satusehat_id = '';
		$this->status = '';

		return $this;
	}

	public function add_data($context)
	{
		if(isset($context['auto_id']))
		{
			$last_id = $this->db->order_by('id', 'DESC')->limit(1)->get($this->_table_sql)->row();

			if(!empty($last_id))
			{
				$last_count = intval(substr($last_id->id, 1))+1;

				if($last_count < 10){ $this->id = 'A000'.$last_count; }
				else if($last_count < 100){ $this->id = 'A00'.$last_count; }
				else if($last_count < 1000){ $this->id = 'A0'.$last_count; }
				else if($last_count < 10000){ $this->id = 'A'.$last_count; }
			}
			else $this->id = 'A0001';
		} 
		else $this->id = $context['id'];

		$this->nama = $context['nama'];
		$this->harga = $context['harga'];
		$this->aturan_pakai = $context['aturan_pakai'];
		$this->tersedia = $context['tersedia'];
		$this->satuan = $context['satuan'];
		$this->kategori = $context['kategori'];
		$this->jenis = $context['jenis'];
		$this->status = $context['status'];
		$this->created_date = date('Y-m-d H:i:s');

		$query = $this->db->insert($this->_table_name, $this);

		return $this->get_notif('Tambah');
	}

	public function update_data($context)
	{
		$this->id = $context['id'];
		$this->nama = $context['nama'];
		$this->harga = $context['harga'];
		$this->aturan_pakai = $context['aturan_pakai'];
		$this->tersedia = $context['tersedia'];
		$this->satuan = $context['satuan'];
		$this->kategori = $context['kategori'];
		$this->jenis = $context['jenis'];
		$this->status = $context['status'];	

		$query = $this->db->where('id', $context['id_old'])->update($this->_table_name, $this);	

		return $this->get_notif('Update');
	}

	public function update_kfa($context)
	{
		$this->satusehat_kfa_code = $context['satusehat_kfa_code'];
		$this->satusehat_kfa_system = $context['satusehat_kfa_system'];
		$this->satusehat_kfa_display = $context['satusehat_kfa_display'];
		$this->jenis = $context['jenis'];			

		if(isset($context['id'])){ $this->satusehat_id = $context['id']; } else $this->satusehat_id = '-';

		if(isset($context['data']['status_kirim'])){ $this->status_kirim = $context['data']['status_kirim']; } else $this->status_kirim = 'Terkirim';

		if(isset($context['data']['response'])){ $this->response = $context['data']['response']; } else $this->response = '-';

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);	

		return $this->get_notif('Update');
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);		

		return $this->get_notif('Hapus');
	}

	//--------------------------------------------------------------------------------------------

	public function select_data_keyword($context)
	{	
		$keyword = $context['keyword'];

		$this->db->select('d_o.id, concat(d_o.nama, " (", a_s.value, ") - Rp ", d_o. harga) AS text');
		$this->db->from($this->_table_sql);
		$this->db->join('asset_satuan a_s', 'a_s.id=d_o.satuan', 'left');
		$this->db->where('d_o.status', 'Aktif');		

		if($keyword != "")	$this->db->where("d_o.nama LIKE '%$keyword%'");

		$this->db->order_by('d_o.nama', 'ASC');	
		
		return $this->db->get()->result();
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	