<?php

class Data_panggil_poli_model extends CI_Model {

	private $_table_name = "data_panggil_poli";
	private $_table_sql = "data_panggil_poli d_pp";

	public function tabel_data()
	{		
		$this->db->select('d_pp.*');
		$this->db->from($this->_table_sql);
		$this->db->where('status', 'menunggu');

		return $this->db->get()->row();
	}

	public function tabel_data_last()
	{		
		$this->db->select('d_pp.*');
		$this->db->from($this->_table_sql);
		$this->db->order_by('id', 'DESC');
		$this->db->limit(1);

		return $this->db->get()->row();
	}

	public function add_data($context)
	{
		$this->value = ucwords(strtolower($context['value']));
		$this->created_date = date('Y-m-d H:i:s');		

		$query = $this->db->insert($this->_table_name, $this);			

		return $this->get_notif_query('Tambah');
	}

	public function update_status($context)
	{
		$this->status = $context['status'];		

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);			

		return $this->get_notif_query('Update');
	}
	
	//--------------------------------------------------------------------------------------------

	public function get_notif_query($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0)
		{
			$notif = array('eror' => 'success', 'pesan'=> $name_function.' data berhasil');
		} 
		else if($eror['code'] == 1062)
		{
			$notif = array('eror' => 'warning', 'pesan' => 'Data sudah terdaftar');
		} 
		else $notif = array('eror' => 'warning', 'pesan' => "Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	