<?php

class Data_pasien_model extends CI_Model {

	private $_error = "";
	private $_table_name = "data_pasien";
	private $_table_sql = "data_pasien d_p";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$this->db->select('d_p.*');
		$this->db->from($this->_table_sql);	

		if($keyword != "") $this->db->where("d_p.no_rm LIKE '%$keyword%' OR d_p.nama LIKE '%$keyword%' OR d_p.nik LIKE '%$keyword%' OR d_p.no_bpjs LIKE '%$keyword%' OR d_p.alamat LIKE '%$keyword%' OR d_p.keterangan_lain LIKE '%$keyword%'");

		$this->db->order_by('d_p.no_rm', 'ASC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$this->db->select('d_p.*');
		$this->db->from($this->_table_sql);
		
		if($keyword != "") $this->db->where("d_p.no_rm LIKE '%$keyword%' OR d_p.nama LIKE '%$keyword%' OR d_p.nik LIKE '%$keyword%' OR d_p.no_bpjs LIKE '%$keyword%' OR d_p.alamat LIKE '%$keyword%' OR d_p.keterangan_lain LIKE '%$keyword%'");

		return $this->db->get()->num_rows();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_p.*, 
			DATE_FORMAT(tgl_lahir, "%d-%m-%Y") As tgl_lahir,
			CONCAT(CONCAT(CONCAT(TIMESTAMPDIFF(YEAR, tgl_lahir, CURDATE()), " Th "),CONCAT(TIMESTAMPDIFF(MONTH, tgl_lahir, CURDATE()) - ((TIMESTAMPDIFF(MONTH, tgl_lahir, CURDATE()) div 12) * 12), " Bl ")),CONCAT(TIMESTAMPDIFF(DAY, DATE_ADD(DATE_ADD(tgl_lahir,INTERVAL TIMESTAMPDIFF(YEAR, tgl_lahir, CURDATE()) YEAR), INTERVAL TIMESTAMPDIFF(MONTH, tgl_lahir, CURDATE()) - ((TIMESTAMPDIFF(MONTH, tgl_lahir, CURDATE()) div 12) * 12) MONTH), CURDATE()), " Hr")) AS umur');
		$this->db->from($this->_table_sql);
		$this->db->where('d_p.no_rm', $id);
		
		return $this->db->get()->row();
	}

	public function lihat_from_nik_nokartu($context)
	{
		$nik = $context['nik'];
		$nomorkartu = $context['nomorkartu'];		
		$tanggalperiksa = $context['tanggalperiksa'];

		$this->db->select("d_p.*, 
			DATE_FORMAT(tgl_lahir, '%d-%m-%Y') As tgl_lahir,
			CONCAT(CONCAT(CONCAT(TIMESTAMPDIFF(YEAR, tgl_lahir, '$tanggalperiksa'), ' Th '),CONCAT(TIMESTAMPDIFF(MONTH, tgl_lahir, '$tanggalperiksa') - ((TIMESTAMPDIFF(MONTH, tgl_lahir, '$tanggalperiksa') div 12) * 12), ' Bl ')),CONCAT(TIMESTAMPDIFF(DAY, DATE_ADD(DATE_ADD(tgl_lahir,INTERVAL TIMESTAMPDIFF(YEAR, tgl_lahir, '$tanggalperiksa') YEAR), INTERVAL TIMESTAMPDIFF(MONTH, tgl_lahir, '$tanggalperiksa') - ((TIMESTAMPDIFF(MONTH, tgl_lahir, '$tanggalperiksa') div 12) * 12) MONTH), '$tanggalperiksa'), ' Hr')) AS umur");
		$this->db->from($this->_table_sql);
		$this->db->where("no_bpjs='$nomorkartu' OR nik='$nik'");
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->no_rm = '';
		$this->nama = '';
		$this->nik = '';
		$this->jenis_kelamin = '';
		$this->tgl_lahir = '';
		$this->tanggal_lahir = '';
		$this->bulan_lahir = '';
		$this->tahun_lahir = '';
		$this->alamat = '';
		$this->propinsi = '';
		$this->kabupaten = '';
		$this->kecamatan = '';
		$this->kelurahan = '';
		$this->no_bpjs = '';
		$this->no_hp = '';
		$this->alergi = '';
		$this->keterangan_lain = '';

		return $this;
	}

	public function add_data($context)
	{
		$last_no_rm = 1;

		if(!isset($context['auto_id']))
		{
			$this->no_rm = $context['no_rm'];	
		}
		else {
			while ($last_no_rm == 1) 
			{				
				$this->no_rm = $this->generate_no_rm();

				$last_no_rm = $this->db->where('no_rm', $this->no_rm)->get($this->_table_sql)->num_rows();
			}
		}

		$this->nama = $context['nama'];
		$this->nik = $context['nik'];
		$this->jenis_kelamin = $context['jenis_kelamin'];

		$spit = explode('-', $context['tgl_lahir']);

		$this->tgl_lahir = $spit[2].'-'.$spit[1].'-'.$spit[0];
		$this->alamat = $context['alamat'];
		$this->propinsi = $context['propinsi'];
		$this->kabupaten = $context['kabupaten'];
		$this->kecamatan = $context['kecamatan'];
		$this->kelurahan = $context['kelurahan'];
		$this->no_bpjs = $context['no_bpjs'];
		$this->no_hp = $context['no_hp'];

		if(isset($context['alergi'])) $this->alergi = $context['alergi'];

		if(isset($context['keterangan_lain'])) $this->keterangan_lain = $context['keterangan_lain'];

		$this->created_date = date('Y-m-d H:i:s');

		$query = $this->db->insert($this->_table_name, $this);

		$notif = $this->get_query_notif('Tambah');

		if($query) 
		{
			if($last_no_rm < $this->no_rm) $this->db->update('pengaturan', ['last_no_rm' => $this->no_rm]);
		}

		return $notif;
	}

	public function generate_no_rm()
	{
		$last_no_rm = $this->db->select('last_no_rm')->get('pengaturan')->row();

		if(!empty($last_no_rm))
		{
			$last_count = intval($last_no_rm->last_no_rm)+1;

			if($last_count < 10){ $no_rm = '00000'.$last_count; }
			else if($last_count < 100){ $no_rm = '0000'.$last_count; }
			else if($last_count < 1000){ $no_rm = '000'.$last_count; }
			else if($last_count < 10000){ $no_rm = '00'.$last_count; }
			else if($last_count < 100000){ $no_rm = '0'.$last_count; }
			else $no_rm = $last_count; 
		}
		else $no_rm = '000001';

		return $no_rm;
	}

	public function update_data($context)
	{
		$this->no_rm = $context['no_rm'];
		$this->nama = $context['nama'];
		$this->nik = $context['nik'];
		$this->jenis_kelamin = $context['jenis_kelamin'];

		$spit = explode('-', $context['tgl_lahir']);

		$this->tgl_lahir = $spit[2].'-'.$spit[1].'-'.$spit[0];
		$this->alamat = $context['alamat'];
		$this->propinsi = $context['propinsi'];
		$this->kabupaten = $context['kabupaten'];
		$this->kecamatan = $context['kecamatan'];
		$this->kelurahan = $context['kelurahan'];
		$this->no_bpjs = $context['no_bpjs'];
		$this->no_hp = $context['no_hp'];
		
		if(isset($context['alergi'])) $this->alergi = $context['alergi'];

		if(isset($context['keterangan_lain'])) $this->keterangan_lain = $context['keterangan_lain'];

		$this->status = $context['status'];

		$query = $this->db->where('no_rm', $context['no_rm_old'])->update($this->_table_name, $this);	

		$notif = $this->get_query_notif('Update');

		return $notif;
	}

	public function update_satusehat($context)
	{
		$this->satusehat_id = $context['entry'][0]->resource->id;

		$query = $this->db->where('no_rm', $context['no_rm'])->update($this->_table_name, $this);	

		return $this->get_query_notif('Update');
	}

	public function delete_data($context)
	{
		$no_rm = $context['id'];

		$query = $this->db->where('no_rm', $no_rm)->delete($this->_table_name);		

		return $this->get_query_notif('Hapus');
	}

	//--------------------------------------------------------------------------------------------

	public function get_query_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	