<?php

class Data_pemeriksaan_model extends CI_Model {
	
	private $_error = "";
	private $_table_name = "data_pemeriksaan";
	private $_table_sql = "data_pemeriksaan d_pem";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);

		$this->db->select('d_pen.id,
			d_pem.id AS pemeriksaan_id,
			d_pem.tgl_pemeriksaan,
			d_pem.unit,
			d_pen.id AS pendaftaran_id,			
			d_pen.tgl_daftar,
			d_pen.jam_daftar,
			d_pen.no_rawat,
			d_pen.urut,
			d_pen.bpjs_noUrut,
			d_pen.status_kirim_bpjs,
			d_pen.status_pemeriksaan,
			d_pen.umur,
			d_pas.nama,
			d_pas.no_rm,
			d_pas.nik AS pasien_nik,
			d_pas.satusehat_id AS pasien_satusehat_id,
			d_d.nik AS dokter_nik,
			d_d.satusehat_id AS dokter_satusehat_id,			
			a_d.value AS debitur_value,
			d_pem.status_kirim_bpjs AS status_kirim_bpjs_pemeriksaan,
			d_pem.bpjs_noKunjungan,
			d_pem.bpjs_rujukLanjut');		
		$this->db->from('data_pendaftaran d_pen');
		$this->db->join('data_pemeriksaan d_pem', 'd_pem.pendaftaran_id=d_pen.id', 'left');
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	

		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if(isset($tgl['awal']) && isset($tgl['akhir'])) 
		{			
			$this->db->where("d_pen.tgl_daftar >= '".$tgl['awal']."'");
			$this->db->where("d_pen.tgl_daftar <= '".$tgl['akhir']."'");
		}

		if(isset($context['status_pemeriksaan'])){ if($context['status_pemeriksaan'] != "all") $this->db->where('d_pen.status_pemeriksaan', $context['status_pemeriksaan']); }

		$this->db->order_by('d_pen.created_date', 'DESC');			
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);

		$this->db->select('d_pen.*');
		$this->db->from('data_pendaftaran d_pen');
		$this->db->join('data_pemeriksaan d_pem', 'd_pem.pendaftaran_id=d_pen.id', 'left');
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');

		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if(isset($tgl['awal']) && isset($tgl['akhir'])) $this->db->where("d_pen.tgl_daftar BETWEEN '".$tgl['awal']." 00:00:00' AND '".$tgl['akhir']." 23:59:59'");

		if(isset($context['status_pemeriksaan'])){ if($context['status_pemeriksaan'] != "all") $this->db->where('d_pen.status_pemeriksaan', $context['status_pemeriksaan']); }

		return $this->db->get()->num_rows();
	}

	public function riwayat($context)
	{		
		$no_rm = $context['no_rm'];

		$this->db->select('
			d_pem.*,
			DATE_FORMAT(d_pem.tgl_pemeriksaan, "%d-%m-%Y") AS tgl_pemeriksaan,
			d_pen.tgl_daftar,
			d_pen.jam_daftar,
			d_pen.no_rawat,
			d_pas.nama,
			d_pas.nik AS pasien_nik,
			GROUP_CONCAT(d_pp.nama SEPARATOR "#") AS procedure_pemeriksaan,
			GROUP_CONCAT(CONCAT(d_po.nama,";",d_po.jumlah,";",d_po.aturan_pakai) SEPARATOR "#") AS pemberian_obat
			');		
		$this->db->from('data_pemeriksaan d_pem');
		$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_pem.pendaftaran_id', 'left');
		$this->db->join('data_pemeriksaan_procedure d_pp', 'd_pp.pemeriksaan_id=d_pem.id', 'left');
		$this->db->join('data_pemeriksaan_obat d_po', 'd_po.pemeriksaan_id=d_pem.id', 'left');
		$this->db->join('data_obat d_o', 'd_o.id=d_po.obat_id', 'left');
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	
		$this->db->where('d_pas.no_rm', $no_rm); 

		$this->db->order_by('d_pen.created_date', 'DESC');	
		$this->db->group_by('d_pem.id'); 

		return $this->db->get()->result();
	}

	public function tabel_data_satusehat($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);

		if($context['service_name'] == 'procedure')
		{
			$this->db->select('
				if(s_de.satusehat_id="-",CONCAT("[<b>", s_de.status_kirim, "</b>] ", s_de.response),s_de.satusehat_id) AS encounter_satusehat_id,
				if(s_dp.satusehat_id="-",CONCAT("[<b>", s_dp.status_kirim, "</b>] ", s_dp.response),s_dp.satusehat_id) AS procedure_satusehat_id,
				d_pp.icd_9,
				d_pp.nama AS icd_9_value,
				d_pem.id AS pemeriksaan_id,
				d_pem.unit,
				d_pen.id AS pendaftaran_id,			
				d_pen.tgl_daftar,
				d_pen.jam_daftar,
				d_pen.no_rawat,
				d_pen.umur,
				d_pas.nama,
				d_pas.nik AS pasien_nik,
				d_pas.satusehat_id AS pasien_satusehat_id,
				d_d.nik AS dokter_nik,
				d_d.satusehat_id AS dokter_satusehat_id,			
				a_d.value AS debitur_value
				');		
			$this->db->from('data_pemeriksaan_procedure d_pp');
			$this->db->join('data_pemeriksaan d_pem', 'd_pem.id=d_pp.pemeriksaan_id', 'left');
			$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_pem.pendaftaran_id', 'left');
			$this->db->join('satusehat_data_procedure s_dp', 's_dp.id=d_pp.id', 'left');
			$this->db->join('satusehat_data_encounter s_de', 's_de.satusehat_id=s_dp.encounter_satusehat_id', 'left');
			$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
			$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');
			$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	
			$this->db->where("(s_de.satusehat_id != '' AND s_de.satusehat_id != '-')");
		}
		else
		{
			switch ($context['service_name'])
			{
				case 'condition':
				$where = "s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND d_pem.bpjs_kdDiag1 != ''";
				break;

				case 'composition':
				$where = "s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND d_pem.diet != '' AND d_pem.diet != '-'";
				break;

				case 'observation':
				$where = "s_de.satusehat_id != '' AND s_de.satusehat_id != '-'";
				break;

				case 'clinical_impression':
				$where = "s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND s_dcon.satusehat_id != '' AND s_dcon.satusehat_id != '-' AND d_pem.bpjs_anamnesa != '' AND d_pem.bpjs_anamnesa != '-'";
				break;

				default:
				$where = '';
				break;
			}

			$this->db->select('
				if(s_de.satusehat_id="-",CONCAT("[<b>", s_de.status_kirim, "</b>] ", s_de.response),s_de.satusehat_id) AS encounter_satusehat_id,
				if(s_dcon.satusehat_id="-",CONCAT("[<b>", s_dcon.status_kirim, "</b>] ", s_dcon.response),s_dcon.satusehat_id) AS condition_satusehat_id,
				if(s_dcom.satusehat_id="-",CONCAT("[<b>", s_dcom.status_kirim, "</b>] ", s_dcom.response),s_dcom.satusehat_id) AS composition_satusehat_id,
				if(s_dci.satusehat_id="-",CONCAT("[<b>", s_dci.status_kirim, "</b>] ", s_dci.response),s_dci.satusehat_id) AS clinical_impression_satusehat_id,
				d_pem.id AS pemeriksaan_id,
				d_pem.unit,
				d_pen.id AS pendaftaran_id,			
				d_pen.tgl_daftar,
				d_pen.jam_daftar,
				d_pen.no_rawat,
				d_pen.umur,
				d_pas.nama,
				d_pas.nik AS pasien_nik,
				d_pas.satusehat_id AS pasien_satusehat_id,
				d_d.nik AS dokter_nik,
				d_d.satusehat_id AS dokter_satusehat_id,			
				a_d.value AS debitur_value,
				bpjs_kdDiag1,
				bpjs_nmDiag1,
				d_pem.bpjs_sistole AS sistole,
				d_pem.bpjs_diastole AS diastole,
				d_pem.bpjs_beratBadan AS berat_badan,
				d_pem.bpjs_tinggiBadan AS tinggi_badan,
				d_pem.bpjs_respRate AS respirasi_rate,
				d_pem.bpjs_lingkarPerut AS lingkar_perut,
				d_pem.bpjs_heartRate AS heart_rate,
				d_pem.bpjs_nmSadar AS kesadaran,
				d_pem.bpjs_suhu AS suhu,
				d_pem.diet AS diet,
				d_pem.bpjs_anamnesa AS anamnesa,
				s_do.sistole_satusehat,
				s_do.diastole_satusehat,
				s_do.berat_badan_satusehat,
				s_do.tinggi_badan_satusehat,
				s_do.respirasi_rate_satusehat,
				s_do.lingkar_perut_satusehat,
				s_do.heart_rate_satusehat,
				s_do.kesadaran_satusehat,
				s_do.suhu_satusehat
				');		
			$this->db->from('data_pendaftaran d_pen');
			$this->db->join('satusehat_data_encounter s_de', 's_de.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_condition s_dcon', 's_dcon.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_observation s_do', 's_do.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_composition s_dcom', 's_dcom.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_clinical_impression s_dci', 's_dci.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('data_pemeriksaan d_pem', 'd_pem.pendaftaran_id=d_pen.id', 'left');
			$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
			$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');
			$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');

			if($where != '') $this->db->where($where);
		}

		$this->db->where('d_pem.kirim_satusehat', 'Ya');
		
		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if($tgl['awal'] && $tgl['akhir']) 
		{			
			$this->db->where("d_pen.tgl_daftar >= '".$tgl['awal']."'");
			$this->db->where("d_pen.tgl_daftar <= '".$tgl['akhir']."'");
		}

		$this->db->where("d_pem.penyerahan_obat_date IS NOT NULL");
		$this->db->where("d_pem.penyerahan_obat_time IS NOT NULL");
		$this->db->order_by('d_pen.created_date', 'DESC');			
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data_satusehat($context)
	{
		$keyword = $context['keyword'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);

		if($context['service_name'] == 'procedure')
		{
			$this->db->select('d_pp.*');
			$this->db->from('data_pemeriksaan_procedure d_pp');
			$this->db->join('data_pemeriksaan d_pem', 'd_pem.id=d_pp.pemeriksaan_id', 'left');
			$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_pem.pendaftaran_id', 'left');
			$this->db->join('satusehat_data_procedure s_dp', 's_dp.id=d_pp.id', 'left');
			$this->db->join('satusehat_data_encounter s_de', 's_de.satusehat_id=s_dp.encounter_satusehat_id', 'left');
			$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
			$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');
			$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	

			$this->db->where("(s_de.satusehat_id != '' AND s_de.satusehat_id != '-')");
		}
		else
		{
			switch ($context['service_name'])
			{
				case 'condition':
				$where = "s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND d_pem.bpjs_kdDiag1 != ''";
				break;

				case 'composition':
				$where = "s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND d_pem.diet != '' AND d_pem.diet != '-'";
				break;

				case 'observation':
				$where = "s_de.satusehat_id != '' AND s_de.satusehat_id != '-'";
				break;

				case 'clinical_impression':
				$where = "s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND s_dcon.satusehat_id != '' AND s_dcon.satusehat_id != '-' AND d_pem.bpjs_anamnesa != '' AND d_pem.bpjs_anamnesa != '-'";
				break;

				default:
				$where = '';
				break;
			}

			$this->db->select('d_pen.*');
			$this->db->from('data_pendaftaran d_pen');
			$this->db->join('satusehat_data_encounter s_de', 's_de.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_condition s_dcon', 's_dcon.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_observation s_do', 's_do.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_composition s_dcom', 's_dcom.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('data_pemeriksaan d_pem', 'd_pem.pendaftaran_id=d_pen.id', 'left');
			$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');

			if($where != '') $this->db->where($where);
		}

		$this->db->where('d_pem.kirim_satusehat', 'Ya');
		$this->db->where("d_pem.penyerahan_obat_date IS NOT NULL");
		$this->db->where("d_pem.penyerahan_obat_time IS NOT NULL");

		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if($tgl['awal'] && $tgl['akhir']) 
		{			
			$this->db->where("d_pen.tgl_daftar >= '".$tgl['awal']."'");
			$this->db->where("d_pen.tgl_daftar <= '".$tgl['akhir']."'");
		}

		return $this->db->get()->num_rows();
	}

	public function tabel_all_satusehat($context)
	{		
		if(isset($context['range_tgl'])) $tgl = $this->convert_range_tgl($context['range_tgl']);

		if($context['service_name'] == 'procedure')
		{
			$this->db->select('
				if(s_de.satusehat_id="-",CONCAT("[<b>", s_de.status_kirim, "</b>] ", s_de.response),s_de.satusehat_id) AS encounter_satusehat_id,
				if(s_dp.satusehat_id="-",CONCAT("[<b>", s_dp.status_kirim, "</b>] ", s_dp.response),s_dp.satusehat_id) AS procedure_satusehat_id,
				d_pp.icd_9,
				d_pp.nama AS icd_9_value,
				d_pem.id AS pemeriksaan_id,
				d_pem.unit,
				d_pen.id AS pendaftaran_id,			
				d_pen.tgl_daftar,
				d_pen.jam_daftar,
				d_pen.no_rawat,
				d_pen.umur,
				d_pas.nama,
				d_pas.nik AS pasien_nik,
				d_pas.satusehat_id AS pasien_satusehat_id,
				d_d.nik AS dokter_nik,
				d_d.satusehat_id AS dokter_satusehat_id,			
				a_d.value AS debitur_value
				');		
			$this->db->from('data_pemeriksaan_procedure d_pp');
			$this->db->join('data_pemeriksaan d_pem', 'd_pem.id=d_pp.pemeriksaan_id', 'left');
			$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_pem.pendaftaran_id', 'left');
			$this->db->join('satusehat_data_procedure s_dp', 's_dp.id=d_pp.id', 'left');
			$this->db->join('satusehat_data_encounter s_de', 's_de.satusehat_id=s_dp.encounter_satusehat_id', 'left');
			$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
			$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');
			$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	
			$this->db->where("(s_de.satusehat_id != '' AND s_de.satusehat_id != '-')");
		}
		else
		{
			switch ($context['service_name'])
			{
				case 'encounter':
				$where = "s_de.satusehat_id IS NULL";
				break;

				case 'condition':
				$where = "(s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND s_dcon.satusehat_id IS NULL) AND d_pem.bpjs_kdDiag1 != ''";
				break;

				case 'composition':
				$where = "(s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND s_dcom.satusehat_id IS NULL) AND d_pem.diet != '' AND d_pem.diet != '-'";
				break;

				case 'observation':
				$where = "(s_de.satusehat_id != '' AND s_de.satusehat_id != '-' AND s_do.sistole_satusehat = '' AND s_do.diastole_satusehat = '' AND s_do.heart_rate_satusehat = '' AND s_do.lingkar_perut_satusehat = '' AND s_do.berat_badan_satusehat = '' AND s_do.tinggi_badan_satusehat = '' AND s_do.respirasi_rate_satusehat = '' AND s_do.kesadaran_satusehat = '' AND s_do.suhu_satusehat = '')";
				break;

				default:
				$where = '';
				break;
			}

			$this->db->select('
				if(s_de.satusehat_id="-",CONCAT("[<b>", s_de.status_kirim, "</b>] ", s_de.response),s_de.satusehat_id) AS encounter_satusehat_id,
				if(s_dcon.satusehat_id="-",CONCAT("[<b>", s_dcon.status_kirim, "</b>] ", s_dcon.response),s_dcon.satusehat_id) AS condition_satusehat_id,
				if(s_dcom.satusehat_id="-",CONCAT("[<b>", s_dcom.status_kirim, "</b>] ", s_dcom.response),s_dcom.satusehat_id) AS composition_satusehat_id,
				if(s_dci.satusehat_id="-",CONCAT("[<b>", s_dci.status_kirim, "</b>] ", s_dci.response),s_dci.satusehat_id) AS clinical_impression_satusehat_id,
				d_pem.id AS pemeriksaan_id,
				d_pem.unit,
				d_pen.id AS pendaftaran_id,			
				d_pen.tgl_daftar,
				d_pen.jam_daftar,
				d_pen.no_rawat,
				d_pen.umur,
				d_pas.nama,
				d_pas.nik AS pasien_nik,
				d_pas.satusehat_id AS pasien_satusehat_id,
				d_d.nik AS dokter_nik,
				d_d.satusehat_id AS dokter_satusehat_id,			
				a_d.value AS debitur_value,
				bpjs_kdDiag1,
				bpjs_nmDiag1,
				d_pem.bpjs_sistole AS sistole,
				d_pem.bpjs_diastole AS diastole,
				d_pem.bpjs_beratBadan AS berat_badan,
				d_pem.bpjs_tinggiBadan AS tinggi_badan,
				d_pem.bpjs_respRate AS respirasi_rate,
				d_pem.bpjs_lingkarPerut AS lingkar_perut,
				d_pem.bpjs_heartRate AS heart_rate,
				d_pem.bpjs_nmSadar AS kesadaran,
				d_pem.bpjs_suhu AS suhu,
				d_pem.diet AS diet,
				d_pem.bpjs_anamnesa AS anamnesa,
				s_do.sistole_satusehat,
				s_do.diastole_satusehat,
				s_do.berat_badan_satusehat,
				s_do.tinggi_badan_satusehat,
				s_do.respirasi_rate_satusehat,
				s_do.lingkar_perut_satusehat,
				s_do.heart_rate_satusehat,
				s_do.kesadaran_satusehat,
				s_do.suhu_satusehat
				');		
			$this->db->from('data_pendaftaran d_pen');
			$this->db->join('satusehat_data_encounter s_de', 's_de.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_condition s_dcon', 's_dcon.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_observation s_do', 's_do.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_composition s_dcom', 's_dcom.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('satusehat_data_clinical_impression s_dci', 's_dci.no_rawat=d_pen.no_rawat', 'left');
			$this->db->join('data_pemeriksaan d_pem', 'd_pem.pendaftaran_id=d_pen.id', 'left');
			$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
			$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');
			$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');

			if($where != '') $this->db->where($where);
		}

		$this->db->where('d_pem.kirim_satusehat', 'Ya');

		if(isset($tgl['awal']) && isset($tgl['akhir'])) 
		{			
			$this->db->where("d_pen.tgl_daftar >= '".$tgl['awal']."'");
			$this->db->where("d_pen.tgl_daftar <= '".$tgl['akhir']."'");
		}

		$this->db->where("d_pem.penyerahan_obat_date IS NOT NULL");
		$this->db->where("d_pem.penyerahan_obat_time IS NOT NULL");
		$this->db->order_by('d_pen.created_date', 'DESC');	

		return $this->db->get()->result();
	}

	public function tabel_obat($context)
	{		
		$pemeriksaan_id = $context['pemeriksaan_id'];

		$this->db->select('d_po.*, 
			concat(d_po.nama, " (", a_s.value, ") - Rp ", d_po.harga) AS value');		
		$this->db->from('data_pemeriksaan_obat d_po');
		$this->db->join('data_obat d_o', 'd_o.id=d_po.obat_id', 'left');
		$this->db->join('asset_satuan a_s', 'a_s.id=d_o.satuan', 'left');		
		$this->db->where('d_po.pemeriksaan_id', $pemeriksaan_id);

		return $this->db->get()->result();
	}

	public function tabel_tindakan($context)
	{		
		$pemeriksaan_id = $context['pemeriksaan_id'];

		$this->db->select('d_pt.*, concat(d_t.nama, " (", a_kt.value, ") - Rp ", d_pt.total) AS value');		
		$this->db->from('data_pemeriksaan_tindakan d_pt');
		$this->db->join('data_tindakan d_t', 'd_t.id=d_pt.tindakan_id', 'left');
		$this->db->join('asset_kategori_tindakan a_kt', 'a_kt.id=d_t.kategori', 'left');	
		$this->db->where('d_pt.pemeriksaan_id', $pemeriksaan_id);

		return $this->db->get()->result();
	}

	public function tabel_procedure($context)
	{		
		$pemeriksaan_id = $context['pemeriksaan_id'];

		$this->db->select('a_i9.id, a_i9.value');		
		$this->db->from('data_pemeriksaan_procedure d_pp');
		$this->db->join('asset_icd_9 a_i9', 'a_i9.id=d_pp.icd_9', 'left');	
		$this->db->where('d_pp.pemeriksaan_id', $pemeriksaan_id);

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_pem.*, 
			d_pen.no_rm,
			d_pen.debitur,
			d_pen.nm_debitur,
			d_pen.status_kirim_bpjs AS status_kirim_bpjs_pendaftaran,
			a_kd.value AS kategori_debitur_value,
			a_d.value as debitur_value');
		$this->db->from($this->_table_sql);
		$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_pem.pendaftaran_id', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');
		$this->db->join('asset_kategori_debitur a_kd', 'a_kd.id=a_d.kategori', 'left');
		$this->db->where('d_pem.id', $id);
		
		return $this->db->get()->row();
	}

	public function lihat_data_no_rawat($context)
	{
		$no_rawat = $context['no_rawat'];

		$this->db->select('d_pem.*, 
			d_pen.debitur,
			d_pen.no_rm,
			a_d.value AS debitur_value,
			d_pem.id AS pemeriksaan_id,
			d_pen.status_kirim_bpjs AS status_kirim_bpjs_pendaftaran');
		$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_pem.pendaftaran_id', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	
		$this->db->from($this->_table_sql);
		$this->db->where('d_pem.no_rawat', $no_rawat);
		
		return $this->db->get()->row();
	}

	public function tambah_data($context)
	{
		$default = $this->db->select('*')->from('pengaturan_pemeriksaan')->get()->row();

		$this->bpjs_noKunjungan = '';
		$this->id = '';
		$this->dokter = $context->dokter;
		$this->nm_dokter = $context->nm_dokter;
		$this->debitur = $context->debitur;
		$this->debitur_value = $context->debitur_value;
		$this->tgl_pemeriksaan = date('Y-m-d');
		$this->jam_pemeriksaan = date('H:i');
		$this->pendaftaran_id = $context->id;
		$this->no_rawat = $context->no_rawat;
		$this->bpjs_kdProviderPeserta = $context->bpjs_kdProviderPeserta;
		$this->bpjs_tglDaftar = $context->bpjs_tglDaftar;
		$this->bpjs_noKartu = $context->bpjs_noKartu;
		$this->bpjs_kdPoli = $context->bpjs_kdPoli;
		$this->bpjs_nmPoli = '';
		$this->bpjs_keluhan = $context->bpjs_keluhan;
		$this->bpjs_kunjSakit = $context->bpjs_kunjSakit;
		$this->bpjs_sistole = $context->bpjs_sistole;
		$this->bpjs_diastole = $context->bpjs_diastole;
		$this->bpjs_beratBadan = $context->bpjs_beratBadan;
		$this->bpjs_tinggiBadan = $context->bpjs_tinggiBadan;
		$this->bpjs_respRate = $context->bpjs_respRate;
		$this->bpjs_lingkarPerut = $context->bpjs_lingkarPerut;
		$this->bpjs_heartRate = $context->bpjs_heartRate;
		$this->bpjs_suhu = $context->bpjs_suhu;
		$this->bpjs_rujukBalik = $context->bpjs_rujukBalik;
		$this->bpjs_kdTkp = $context->bpjs_kdTkp;
		$this->bpjs_nmTkp = '';
		$this->bpjs_noUrut = $context->bpjs_noUrut;
		$this->bpjs_kdStatusPulang = $default->bpjs_kdStatusPulang;
		$this->bpjs_nmStatusPulang = $default->bpjs_nmStatusPulang;
		$this->bpjs_tglPulang = date('d-m-Y');
		$this->jam_pulang = date('H:i');
		$this->bpjs_kdDiag1 = '';
		$this->bpjs_nmDiag1 = '';
		$this->bpjs_kdDiag2 = '';
		$this->bpjs_nmDiag2 = '';
		$this->bpjs_kdDiag3 = '';
		$this->bpjs_nmDiag3 = '';
		$this->bpjs_kdSadar = $default->bpjs_kdSadar;
		$this->bpjs_nmSadar = $default->bpjs_nmSadar;
		$this->bpjs_kdPoliRujukInternal = '';
		$this->bpjs_rujukLanjut = '';
		$this->bpjs_rujukLanjut_tglEstRujuk = '';
		$this->bpjs_rujukLanjut_kdppk = '';
		$this->bpjs_rujukLanjut_nmppk = '';
		$this->bpjs_rujukLanjut_SubSpesialis = '';
		$this->bpjs_rujukLanjut_SubSpesialis_kdSubSpesialis1 = '';
		$this->bpjs_rujukLanjut_SubSpesialis_nmSubSpesialis1 = '';
		$this->bpjs_rujukLanjut_SubSpesialis_kdSarana = '';
		$this->bpjs_rujukLanjut_SubSpesialis_nmSarana = '';
		$this->bpjs_rujukLanjut_khusus = '';
		$this->bpjs_rujukLanjut_khusus_kdKhusus = '';
		$this->bpjs_rujukLanjut_khusus_nmKhusus = '';
		$this->bpjs_rujukLanjut_khusus_kdSubSpesialis = '';
		$this->bpjs_rujukLanjut_khusus_nmSubSpesialis = '';
		$this->bpjs_rujukLanjut_khusus_catatan = '';
		$this->bpjs_kdTacc = '';
		$this->bpjs_nmTacc = '';
		$this->bpjs_alasanTacc = '';
		$this->bpjs_anamnesa = $default->bpjs_anamnesa;
		$this->bpjs_alergiMakan = $default->bpjs_alergiMakan;
		$this->bpjs_nm_alergiMakan = $default->bpjs_nm_alergiMakan;
		$this->bpjs_alergiUdara = $default->bpjs_alergiUdara;
		$this->bpjs_nm_alergiUdara = $default->bpjs_nm_alergiUdara;
		$this->bpjs_alergiObat = $default->bpjs_alergiObat;
		$this->bpjs_nm_alergiObat = $default->bpjs_nm_alergiObat;
		$this->bpjs_kdPrognosa = $default->bpjs_kdPrognosa;
		$this->bpjs_nmPrognosa = $default->bpjs_nmPrognosa;
		$this->bpjs_terapiObat = $default->bpjs_terapiObat;
		$this->bpjs_terapiNonObat = $default->bpjs_terapiNonObat;
		$this->bpjs_bmhp = $default->bpjs_bmhp;
		$this->object = $default->object;
		$this->plan = $default->plan;
		$this->evaluasi = $default->evaluasi;
		$this->diet = '';
		$this->alergi = $context->alergi;
		$this->status_kirim_bpjs = '';
		$this->status_kirim_bpjs_pendaftaran = $context->status_kirim_bpjs;
		$this->subtotal_obat = 0;
		$this->subtotal_tindakan = 0;
		$this->biaya_pemeriksaan = '';
		$this->total = 0;
		$this->kirim_satusehat = '';

		return $this;
	}

	public function add_update($context)
	{
		$this->bpjs_noKunjungan = $context['bpjs_noKunjungan'];
		$this->dokter = $context['dokter'];
		$this->nm_dokter = $context['nm_dokter'];
		$this->tgl_pemeriksaan = $context['tgl_pemeriksaan'];
		$this->jam_pemeriksaan = $context['jam_pemeriksaan'];
		$this->pendaftaran_id = $context['pendaftaran_id'];
		$this->no_rawat = $context['no_rawat'];
		$this->bpjs_kdProviderPeserta = $context['bpjs_kdProviderPeserta'];
		$this->bpjs_tglDaftar = $context['bpjs_tglDaftar'];
		$this->bpjs_noKartu = $context['bpjs_noKartu'];
		$this->bpjs_kdPoli = $context['bpjs_kdPoli'];
		$this->bpjs_nmPoli = $context['bpjs_nmPoli'];
		$this->bpjs_kunjSakit = $context['bpjs_kunjSakit'];

		if($context['bpjs_sistole'] != ''){ $this->bpjs_sistole = $context['bpjs_sistole']; } else $this->bpjs_sistole = 0;
		
		if($context['bpjs_diastole'] != ''){ $this->bpjs_diastole = $context['bpjs_diastole']; } else $this->bpjs_diastole = 0;
		
		if($context['bpjs_beratBadan'] != ''){ $this->bpjs_beratBadan = $context['bpjs_beratBadan']; } else $this->bpjs_beratBadan = 0;
		
		if($context['bpjs_tinggiBadan'] != ''){ $this->bpjs_tinggiBadan = $context['bpjs_tinggiBadan']; } else $this->bpjs_tinggiBadan = 0;
		
		if($context['bpjs_respRate'] != ''){ $this->bpjs_respRate = $context['bpjs_respRate']; } else $this->bpjs_respRate = 0;
		
		if($context['bpjs_lingkarPerut'] != ''){ $this->bpjs_lingkarPerut = $context['bpjs_lingkarPerut']; } else $this->bpjs_lingkarPerut = 0;

		if($context['bpjs_heartRate'] != ''){ $this->bpjs_heartRate = $context['bpjs_heartRate']; } else $this->bpjs_heartRate = 0;

		$this->bpjs_kdTkp = $context['bpjs_kdTkp'];
		$this->bpjs_nmTkp = $context['bpjs_nmTkp'];
		$this->bpjs_rujukBalik = $context['bpjs_rujukBalik'];		
		$this->bpjs_noUrut = $context['bpjs_noUrut'];
		$this->bpjs_kdStatusPulang = $context['bpjs_kdStatusPulang'];
		$this->bpjs_nmStatusPulang = $context['bpjs_nmStatusPulang'];
		$this->bpjs_tglPulang = $context['bpjs_tglPulang'];
		$this->jam_pulang = $context['jam_pulang'];
		$this->bpjs_kdDiag1 = $context['bpjs_kdDiag1'];
		$this->bpjs_nmDiag1 = $context['bpjs_nmDiag1'];

		if($context['bpjs_kdDiag2'] != '')
		{
			$this->bpjs_kdDiag2 = $context['bpjs_kdDiag2'];
			$this->bpjs_nmDiag2 = $context['bpjs_nmDiag2'];
		} 
		else
		{
			$this->bpjs_kdDiag2 = null;
			$this->bpjs_nmDiag2 = '';
		}

		if($context['bpjs_kdDiag3'] != '')
		{
			$this->bpjs_kdDiag3 = $context['bpjs_kdDiag3'];
			$this->bpjs_nmDiag3 = $context['bpjs_nmDiag3'];
		}
		else
		{
			$this->bpjs_kdDiag3 = null;
			$this->bpjs_nmDiag3 = '';
		}

		$this->bpjs_kdSadar = $context['bpjs_kdSadar'];
		$this->bpjs_nmSadar = $context['bpjs_nmSadar'];
		$this->bpjs_kdPoliRujukInternal = null;

		if($this->bpjs_kdStatusPulang == 4)
		{
			$this->bpjs_rujukLanjut = $context['bpjs_rujukLanjut'];
			$this->bpjs_rujukLanjut_tglEstRujuk = $context['bpjs_rujukLanjut_tglEstRujuk'];
			$this->bpjs_rujukLanjut_kdppk = $context['bpjs_rujukLanjut_kdppk'];
			$this->bpjs_rujukLanjut_nmppk = $context['bpjs_rujukLanjut_nmppk'];
			$this->bpjs_rujukLanjut_SubSpesialis = $context['bpjs_rujukLanjut_SubSpesialis'];

			if($this->bpjs_rujukLanjut_SubSpesialis == 'true')
			{
				$this->bpjs_rujukLanjut_SubSpesialis_kdSubSpesialis1 = $context['bpjs_rujukLanjut_SubSpesialis_kdSubSpesialis1'];
				$this->bpjs_rujukLanjut_SubSpesialis_nmSubSpesialis1 = $context['bpjs_rujukLanjut_SubSpesialis_nmSubSpesialis1'];
				$this->bpjs_rujukLanjut_SubSpesialis_kdSarana = $context['bpjs_rujukLanjut_SubSpesialis_kdSarana'];
				$this->bpjs_rujukLanjut_SubSpesialis_nmSarana = $context['bpjs_rujukLanjut_SubSpesialis_nmSarana'];
			}
			else
			{
				$this->bpjs_rujukLanjut_SubSpesialis_kdSubSpesialis1 = '';
				$this->bpjs_rujukLanjut_SubSpesialis_nmSubSpesialis1 = '';
				$this->bpjs_rujukLanjut_SubSpesialis_kdSarana = '';
				$this->bpjs_rujukLanjut_SubSpesialis_nmSarana = '';
			}

			$this->bpjs_rujukLanjut_khusus = $context['bpjs_rujukLanjut_khusus'];

			if($this->bpjs_rujukLanjut_khusus == 'true')
			{
				$this->bpjs_rujukLanjut_khusus_kdKhusus = $context['bpjs_rujukLanjut_khusus_kdKhusus'];
				$this->bpjs_rujukLanjut_khusus_nmKhusus = $context['bpjs_rujukLanjut_khusus_nmKhusus'];
				$this->bpjs_rujukLanjut_khusus_kdSubSpesialis = $context['bpjs_rujukLanjut_khusus_kdSubSpesialis'];
				$this->bpjs_rujukLanjut_khusus_nmSubSpesialis = $context['bpjs_rujukLanjut_khusus_nmSubSpesialis'];
				$this->bpjs_rujukLanjut_khusus_catatan = $context['bpjs_rujukLanjut_khusus_catatan'];
			}
			else
			{
				$this->bpjs_rujukLanjut_khusus_kdKhusus = '';
				$this->bpjs_rujukLanjut_khusus_nmKhusus = '';
				$this->bpjs_rujukLanjut_khusus_kdSubSpesialis = '';
				$this->bpjs_rujukLanjut_khusus_nmSubSpesialis = '';
				$this->bpjs_rujukLanjut_khusus_catatan = '';
			}
			
			$this->bpjs_kdTacc = $context['bpjs_kdTacc'];
			$this->bpjs_nmTacc = $context['bpjs_nmTacc'];
			$this->bpjs_alasanTacc = $context['bpjs_alasanTacc'];
		}
		else
		{
			$this->bpjs_rujukLanjut = 'false';
			$this->bpjs_rujukLanjut_tglEstRujuk = '';
			$this->bpjs_rujukLanjut_kdppk = '';
			$this->bpjs_rujukLanjut_nmppk = '';
			$this->bpjs_rujukLanjut_SubSpesialis = 'false';
			$this->bpjs_rujukLanjut_SubSpesialis_kdSubSpesialis1 = '';
			$this->bpjs_rujukLanjut_SubSpesialis_nmSubSpesialis1 = '';
			$this->bpjs_rujukLanjut_SubSpesialis_kdSarana = '';
			$this->bpjs_rujukLanjut_SubSpesialis_nmSarana = '';
			$this->bpjs_rujukLanjut_khusus = 'false';
			$this->bpjs_rujukLanjut_khusus_kdKhusus = '';
			$this->bpjs_rujukLanjut_khusus_nmKhusus = '';
			$this->bpjs_rujukLanjut_khusus_kdSubSpesialis = '';
			$this->bpjs_rujukLanjut_khusus_nmSubSpesialis = '';
			$this->bpjs_rujukLanjut_khusus_catatan = '';;
			$this->bpjs_kdTacc = '';
			$this->bpjs_nmTacc = '';
			$this->bpjs_alasanTacc = '';
		}

		$this->bpjs_alergiMakan = $context['bpjs_alergiMakan'];
		$this->bpjs_nm_alergiMakan = $context['bpjs_nm_alergiMakan'];
		$this->bpjs_alergiUdara = $context['bpjs_alergiUdara'];
		$this->bpjs_nm_alergiUdara = $context['bpjs_nm_alergiUdara'];
		$this->bpjs_alergiObat = $context['bpjs_alergiObat'];
		$this->bpjs_nm_alergiObat = $context['bpjs_nm_alergiObat'];
		$this->bpjs_kdPrognosa = $context['bpjs_kdPrognosa'];
		$this->bpjs_nmPrognosa = $context['bpjs_nmPrognosa'];

		if($context['bpjs_suhu'] != ''){ $this->bpjs_suhu = $context['bpjs_suhu']; } else $this->bpjs_suhu = 0;

		if($context['bpjs_keluhan'] != ''){ $this->bpjs_keluhan = $context['bpjs_keluhan']; } else $this->bpjs_keluhan = '-';

		if($context['bpjs_anamnesa'] != ''){ $this->bpjs_anamnesa = $context['bpjs_anamnesa']; } else $this->bpjs_anamnesa = '-';

		if($context['bpjs_terapiObat'] != ''){ $this->bpjs_terapiObat = $context['bpjs_terapiObat']; } else $this->bpjs_terapiObat = '-';

		if($context['bpjs_terapiNonObat'] != ''){ $this->bpjs_terapiNonObat = $context['bpjs_terapiNonObat']; } else $this->bpjs_terapiNonObat = '-';

		if($context['bpjs_bmhp'] != ''){ $this->bpjs_bmhp = $context['bpjs_bmhp']; } else $this->bpjs_bmhp = '-';

		if($context['object'] != ''){ $this->object = $context['object']; } else $this->object = '-';
		
		if($context['plan'] != ''){ $this->plan = $context['plan']; } else $this->plan = '-';

		if($context['evaluasi'] != ''){ $this->evaluasi = $context['evaluasi']; } else $this->evaluasi = '-';

		if($context['alergi'] != ''){ $this->alergi = $context['alergi']; } else $this->alergi = '-';

		if($context['diet'] != ''){ $this->diet = $context['diet']; } else $this->diet = '-';

		$this->subtotal_obat = $context['subtotal_obat'];
		$this->subtotal_tindakan = $context['subtotal_tindakan'];
		$this->biaya_pemeriksaan = $context['biaya_pemeriksaan'];
		$this->total = $context['total'];

		if(isset($context['kirim_satusehat']))
		{
			$this->kirim_satusehat = 'Ya';
		} 
		else $this->kirim_satusehat = 'Tidak';

		$cek_no_rawat = $this->db->where('no_rawat', $this->no_rawat)->get($this->_table_name)->row();

		if(empty($cek_no_rawat))
		{
			$this->selesai_pemeriksaan_date = date('Y-m-d H:i:s');
			$this->petugas_pemeriksaan = $this->session->userdata('user_id_'.$this->session->userdata('prefix'));
			$this->nm_petugas_pemeriksaan = $this->session->userdata('nama_'.$this->session->userdata('prefix'));

			$insert_pemeriksaan = $this->db->insert($this->_table_name, $this);

			if($insert_pemeriksaan)
			{
				$pemeriksaan_id = $this->db->insert_id();

				$update_pendaftaran = $this->db->where('id', $this->pendaftaran_id)->update('data_pendaftaran', ['status_pemeriksaan' => 'Sudah']);
			} 
			else if(!$insert_pemeriksaan) $this->_error .= '<br> '.$this->mysql_get_error();
		}
		else 
		{
			$update_pemeriksaan = $this->db->where('no_rawat', $context['no_rawat'])->update($this->_table_name, $this);

			$pemeriksaan_id = $cek_no_rawat->id;

			if(!$update_pemeriksaan) $this->_error .= '<br> '.$this->mysql_get_error();
		}

		if(isset($context['obat_id']))
		{
			$update_pemeriksaan = $this->db->where('no_rawat', $context['no_rawat'])->update($this->_table_name, ['penyerahan_obat' => 'Belum']);
			
			if(!$update_pemeriksaan) $this->_error .= '<br> '.$this->mysql_get_error();

			$select_pemeriksaan_obat = $this->db->where('pemeriksaan_id', $pemeriksaan_id)->get('data_pemeriksaan_obat')->result();

			if(count($select_pemeriksaan_obat) >= count($context['obat_id']))
			{
				$i = 0;
				foreach ($select_pemeriksaan_obat as $key)
				{
					if(isset($context['obat_id'][$i]))
					{
						$select_obat = $this->db->where('id', $key->obat_id)->get('data_obat')->row();

						$array_insert = array(
							'pemeriksaan_id' => $pemeriksaan_id, 
							'obat_id' => $select_obat->id,
							'nama' => $select_obat->nama,
							'jumlah' => $context['jumlah'][$i],
							'aturan_pakai' => $context['aturan_pakai'][$i],
							'tersedia' => $select_obat->tersedia,
							'harga' => $select_obat->harga
						);

						$update_data_obat = $this->db->where('id', $key->id)->update('data_pemeriksaan_obat', $array_insert);

						if($update_data_obat)
						{
							$array_insert = array('aturan_pakai' => $context['aturan_pakai'][$i]);

							$update_data_obat = $this->db->where('id', $select_obat->id)->update('data_obat', $array_insert);
						}
					}
					else $delete_data_obat = $this->db->where('id', $key->id)->delete('data_pemeriksaan_obat');

					$i++;
				}						
			}

			if(count($select_pemeriksaan_obat) < count($context['obat_id']))
			{
				for ($i=0; $i < count($context['obat_id']); $i++) 
				{ 						
					$select_obat = $this->db->where('id', $context['obat_id'][$i])->get('data_obat')->row();

					$array_insert = array(
						'pemeriksaan_id' => $pemeriksaan_id, 
						'obat_id' => $select_obat->id,
						'nama' => $select_obat->nama,
						'jumlah' => $context['jumlah'][$i],
						'aturan_pakai' => $context['aturan_pakai'][$i],
						'tersedia' => $select_obat->tersedia,
						'harga' => $select_obat->harga
					);

					if(isset($select_pemeriksaan_obat[$i]))
					{
						$update_data_obat = $this->db->where('id', $select_pemeriksaan_obat[$i]->id)->update('data_pemeriksaan_obat', $array_insert);
					}
					else $insert_data_obat = $this->db->insert('data_pemeriksaan_obat', $array_insert);	

					$array_insert = array('aturan_pakai' => $context['aturan_pakai'][$i]);

					$update_data_obat = $this->db->where('id', $select_obat->id)->update('data_obat', $array_insert);
				}
			}
		}
		else
		{
			$select_pemeriksaan_obat = $this->db->where('pemeriksaan_id', $pemeriksaan_id)->get('data_pemeriksaan_obat')->result();

			if(!empty($select_pemeriksaan_obat)) 
			{
				foreach ($select_pemeriksaan_obat as $key)
				{
					$delete_data_obat = $this->db->where('id', $key->id)->delete('data_pemeriksaan_obat');
				} 
			}

			$update_pemeriksaan = $this->db->where('no_rawat', $context['no_rawat'])->update($this->_table_name, ['penyerahan_obat' => 'Tidak ada obat']);

			if(!$update_pemeriksaan) $this->_error .= '<br> '.$this->mysql_get_error();
		}

		if(isset($context['tindakan']))
		{
			$select_pemeriksaan_tindakan = $this->db->where('pemeriksaan_id', $pemeriksaan_id)->get('data_pemeriksaan_tindakan')->result();

			if(count($select_pemeriksaan_tindakan) >= count($context['tindakan']))
			{
				$i = 0;
				foreach ($select_pemeriksaan_tindakan as $key)
				{
					if(isset($context['tindakan'][$i]))
					{
						$select_tindakan = $this->db->where('id', $context['tindakan'][$i])->get('data_tindakan')->row();

						$array_insert = array(
							'pemeriksaan_id' => $pemeriksaan_id, 
							'tindakan_id' => $select_tindakan->id,
							'nama' => $select_tindakan->nama,							
							'bhp' => $select_tindakan->bhp,
							'jasa_sarana' => $select_tindakan->jasa_sarana,
							'jasa_dokter' => $select_tindakan->jasa_dokter,
							'jasa_perawat' => $select_tindakan->jasa_perawat,
							'total' => $select_tindakan->total
						);

						$update_data_tindakan = $this->db->where('id', $key->id)->update('data_pemeriksaan_tindakan', $array_insert);
					}
					else $delete_data_tindakan = $this->db->where('id', $key->id)->delete('data_pemeriksaan_tindakan');

					$i++;
				}						
			}

			if(count($select_pemeriksaan_tindakan) < count($context['tindakan']))
			{
				for ($i=0; $i < count($context['tindakan']); $i++) 
				{ 						
					$select_tindakan = $this->db->where('id', $context['tindakan'][$i])->get('data_tindakan')->row();

					$array_insert = array(
						'pemeriksaan_id' => $pemeriksaan_id, 
						'tindakan_id' => $select_tindakan->id,
						'nama' => $select_tindakan->nama,							
						'bhp' => $select_tindakan->bhp,
						'jasa_sarana' => $select_tindakan->jasa_sarana,
						'jasa_dokter' => $select_tindakan->jasa_dokter,
						'jasa_perawat' => $select_tindakan->jasa_perawat,
						'total' => $select_tindakan->total
					);

					if(isset($select_pemeriksaan_tindakan[$i]))
					{
						$update_data_tindakan = $this->db->where('id', $select_pemeriksaan_tindakan[$i]->id)->update('data_pemeriksaan_tindakan', $array_insert);
					}
					else $insert_data_tindakan = $this->db->insert('data_pemeriksaan_tindakan', $array_insert);	
				}
			}
		}
		else
		{
			$select_pemeriksaan_tindakan = $this->db->where('pemeriksaan_id', $pemeriksaan_id)->get('data_pemeriksaan_tindakan')->result();

			if(!empty($select_pemeriksaan_tindakan))
			{
				foreach ($select_pemeriksaan_tindakan as $key)
				{
					$delete_data_tindakan = $this->db->where('id', $key->id)->delete('data_pemeriksaan_tindakan');
				}
			}
		}

		if(isset($context['procedure']))
		{
			$select_pemeriksaan_procedure = $this->db->where('pemeriksaan_id', $pemeriksaan_id)->get('data_pemeriksaan_procedure')->result();

			if(count($select_pemeriksaan_procedure) >= count($context['procedure']))
			{
				$i = 0;
				foreach ($select_pemeriksaan_procedure as $key)
				{
					if(isset($context['procedure'][$i]))
					{
						$select_procedure = $this->db->where('id', $context['procedure'][$i])->get('asset_icd_9')->row();

						$array_insert = array(
							'pemeriksaan_id' => $pemeriksaan_id,  
							'icd_9' => $select_procedure->id,
							'nama' => $select_procedure->value
						);

						$update_data_procedure = $this->db->where('id', $key->id)->update('data_pemeriksaan_procedure', $array_insert);
					}
					else $delete_data_procedure = $this->db->where('id', $key->id)->delete('data_pemeriksaan_procedure');

					$i++;
				}						
			}

			if(count($select_pemeriksaan_procedure) < count($context['procedure']))
			{
				for ($i=0; $i < count($context['procedure']); $i++) 
				{ 						
					$select_procedure = $this->db->where('id', $context['procedure'][$i])->get('asset_icd_9')->row();

					$array_insert = array(
						'pemeriksaan_id' => $pemeriksaan_id, 
						'icd_9' => $select_procedure->id,
						'nama' => $select_procedure->value
					);

					if(isset($select_pemeriksaan_procedure[$i]))
					{
						$update_data_procedure = $this->db->where('id', $select_pemeriksaan_procedure[$i]->id)->update('data_pemeriksaan_procedure', $array_insert);
					}
					else $insert_data_procedure = $this->db->insert('data_pemeriksaan_procedure', $array_insert);	
				}
			}
		}
		else
		{
			$select_pemeriksaan_procedure = $this->db->where('pemeriksaan_id', $pemeriksaan_id)->get('data_pemeriksaan_procedure')->result();

			if(!empty($select_pemeriksaan_procedure))
			{
				foreach ($select_pemeriksaan_procedure as $key)
				{
					$delete_data_procedure = $this->db->where('id', $key->id)->delete('data_pemeriksaan_procedure');
				}
			}
		}

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil', 'data' => array('pemeriksaan_id' => $pemeriksaan_id, 'no_rawat' => $this->no_rawat));
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pendaftaran_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function update_status_kirim($no_rawat, $context)
	{
		$this->status_kirim_bpjs = 'Terkirim';
		$this->bpjs_noKunjungan = $context['noKunjungan'];
		$this->response_bpjs = $context['metaData'];
		$this->send_date = date('Y-m-d H:i:s');

		$query = $this->db->where('no_rawat', $no_rawat)->update($this->_table_name, $this);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pemeriksaan_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function update_status_penyerahan_obat($context)
	{
		$this->penyerahan_obat = 'Sudah';
		$this->penyerahan_obat_date = $context['penyerahan_obat_date'];
		$this->penyerahan_obat_time = $context['penyerahan_obat_time'];

		$query = $this->db->where('id', $context['pemeriksaan_id'])->update($this->_table_name, $this);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pemeriksaan_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function add_rujukan($pemeriksaan_id, $context)
	{
		$this->pemeriksaan_id = $pemeriksaan_id;
		$this->bpjs_noRujukan = $context['bpjs']['result']['bpjs_noRujukan'];
		$this->bpjs_ppk_kdPPK = $context['bpjs']['result']['bpjs_ppk_kdPPK'];
		$this->bpjs_ppk_nmPPK = $context['bpjs']['result']['bpjs_ppk_nmPPK'];
		$this->bpjs_ppk_alamat = $context['bpjs']['result']['bpjs_ppk_alamat'];
		$this->bpjs_ppk_kc_kdKC = $context['bpjs']['result']['bpjs_ppk_kc_kdKC'];
		$this->bpjs_ppk_kc_nmKC = $context['bpjs']['result']['bpjs_ppk_kc_nmKC'];
		$this->bpjs_ppk_kc_alamat = $context['bpjs']['result']['bpjs_ppk_kc_alamat'];
		$this->bpjs_ppk_kc_telp = $context['bpjs']['result']['bpjs_ppk_kc_telp'];
		$this->bpjs_ppk_kc_fax = $context['bpjs']['result']['bpjs_ppk_kc_fax'];
		$this->bpjs_ppk_kc_dati_kdProp = $context['bpjs']['result']['bpjs_ppk_kc_dati_kdProp'];
		$this->bpjs_ppk_kc_dati_kdDati = $context['bpjs']['result']['bpjs_ppk_kc_dati_kdDati'];
		$this->bpjs_ppk_kc_dati_nmDati = $context['bpjs']['result']['bpjs_ppk_kc_dati_nmDati'];
		$this->bpjs_ppk_kc_kdKR_kdKR = $context['bpjs']['result']['bpjs_ppk_kc_kdKR_kdKR'];
		$this->bpjs_ppk_kc_kdKR_nmKR = $context['bpjs']['result']['bpjs_ppk_kc_kdKR_nmKR'];
		$this->bpjs_ppk_kc_kdKR_alamat = $context['bpjs']['result']['bpjs_ppk_kc_kdKR_alamat'];
		$this->bpjs_ppk_kc_kdKR_telp = $context['bpjs']['result']['bpjs_ppk_kc_kdKR_telp'];
		$this->bpjs_ppk_kc_kdKR_fax = $context['bpjs']['result']['bpjs_ppk_kc_kdKR_fax'];
		$this->bpjs_tglKunjungan = $context['bpjs']['result']['bpjs_tglKunjungan'];
		$this->bpjs_poli_kdPoli = $context['bpjs']['result']['bpjs_poli_kdPoli'];
		$this->bpjs_poli_nmPoli = $context['bpjs']['result']['bpjs_poli_nmPoli'];
		$this->bpjs_nokaPst = $context['bpjs']['result']['bpjs_nokaPst'];
		$this->bpjs_nmPst = $context['bpjs']['result']['bpjs_nmPst'];
		$this->bpjs_tglLahir = $context['bpjs']['result']['bpjs_tglLahir'];
		$this->bpjs_pisa = $context['bpjs']['result']['bpjs_pisa'];
		$this->bpjs_ketPisa = $context['bpjs']['result']['bpjs_ketPisa'];
		$this->bpjs_sex = $context['bpjs']['result']['bpjs_sex'];
		$this->bpjs_diag1_kdDiag = $context['bpjs']['result']['bpjs_diag1_kdDiag'];
		$this->bpjs_diag1_nmDiag = $context['bpjs']['result']['bpjs_diag1_nmDiag'];
		$this->bpjs_diag2_kdDiag = $context['bpjs']['result']['bpjs_diag2_kdDiag'];
		$this->bpjs_diag2_nmDiag = $context['bpjs']['result']['bpjs_diag2_nmDiag'];
		$this->bpjs_diag3_kdDiag = $context['bpjs']['result']['bpjs_diag3_kdDiag'];
		$this->bpjs_diag3_nmDiag = $context['bpjs']['result']['bpjs_diag3_nmDiag'];
		$this->bpjs_dokter_kdDokter = $context['bpjs']['result']['bpjs_dokter_kdDokter'];
		$this->bpjs_dokter_nmDokter = $context['bpjs']['result']['bpjs_dokter_nmDokter'];
		$this->bpjs_tacc_nmTacc = $context['bpjs']['result']['bpjs_tacc_nmTacc'];
		$this->bpjs_tacc_alasanTacc = $context['bpjs']['result']['bpjs_tacc_alasanTacc'];
		$this->bpjs_infoDenda = $context['bpjs']['result']['bpjs_infoDenda'];

		$query = $this->db->insert('data_pemeriksaan_rujukan', $this);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pendaftaran_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);		

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error();

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Delete data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function convert_range_tgl($range)
	{
		$split = explode(' - ', $range);

		if(isset($split[0]))
		{
			$tgl['awal'] = substr($split[0],6,4).'-'.substr($split[0],3,2).'-'.substr($split[0],0,2);
		}

		if(isset($split[1]))
		{
			$tgl['akhir'] = substr($split[1],6,4).'-'.substr($split[1],3,2).'-'.substr($split[1],0,2);
		}

		return $tgl;
	}

	//--------------------------------------------------------------------------------------------

	public function mysql_get_error()
	{
		$error = $this->db->error();

		switch ($error['code']) 
		{
			case '1062':
			$error_detail = 'Data sudah ada';
			break;

			default:
			$error_detail = "$error[code]: $error[message]";
			break;
		}

		return $error_detail;		
	}

}	