<?php

class Data_pemeriksaan_obat_model extends CI_Model {
	
	private $_error = "";
	private $_table_name = "data_pemeriksaan_obat";
	private $_table_sql = "data_pemeriksaan_obat d_po";

	public function tabel_data($context)
	{		
		$penyerahan_obat = $context['penyerahan_obat'];
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);

		$this->db->select('
			d_pen.umur,
			d_pen.urut,
			d_pas.nama,
			d_pen.nm_debitur,
			d_pen.tgl_daftar,
			d_pen.no_rawat,
			d_pem.tgl_pemeriksaan,
			d_pem.*,
			a_d.value AS debitur_value');		
		$this->db->from('data_pemeriksaan d_pem');
		$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_pem.pendaftaran_id', 'left');
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	

		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if(isset($tgl['awal']) && isset($tgl['akhir'])) $this->db->where("d_pem.tgl_pemeriksaan BETWEEN '".$tgl['awal']."' AND '".$tgl['akhir']."'");

		if($penyerahan_obat != "all") $this->db->where('d_pem.penyerahan_obat', $penyerahan_obat);

		// $this->db->where("d_pem.penyerahan_obat != 'Tidak ada obat'");
		$this->db->order_by('d_pem.created_date', 'DESC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$penyerahan_obat = $context['penyerahan_obat'];
		$keyword = $context['keyword'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);

		$this->db->from('data_pemeriksaan d_pem');
		$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_pem.pendaftaran_id', 'left');
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		
		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if(isset($tgl['awal']) && isset($tgl['akhir'])) $this->db->where("d_pem.tgl_pemeriksaan BETWEEN '".$tgl['awal']."' AND '".$tgl['akhir']."'");

		if($penyerahan_obat != "all") $this->db->where('d_pem.penyerahan_obat', $penyerahan_obat);

		// $this->db->where("d_pem.penyerahan_obat != 'Tidak ada obat'");

		return $this->db->get()->num_rows();
	}

	public function tabel_obat($context)
	{		
		$pemeriksaan_id = $context['pemeriksaan_id'];

		$this->db->select('d_po.*, 
			a_s.value AS satuan_value,
			a_ko.value AS kategori_value,
			concat(d_po.nama, " (", a_s.value," - ",a_ko.value,"), ") AS value');		
		$this->db->from($this->_table_sql);
		$this->db->join('data_obat d_o', 'd_o.id=d_po.obat_id', 'left');
		$this->db->join('asset_satuan a_s', 'a_s.id=d_o.satuan', 'left');		
		$this->db->join('asset_kategori_obat a_ko', 'a_ko.id=d_o.kategori', 'left');	
		$this->db->where('pemeriksaan_id', $pemeriksaan_id);

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_po.*, 
			d_pen.debitur,
			d_pen.status_kirim_bpjs AS status_kirim_bpjs_pendaftaran');
		$this->db->join('data_pendaftaran d_pen', 'd_pen.id=d_po.pendaftaran_id', 'left');
		$this->db->from($this->_table_sql);
		$this->db->where('d_po.id', $id);
		
		return $this->db->get()->row();
	}

	public function update_data($context)
	{		
		if(isset($context['id']))
		{
			$data = array('biaya_pemeriksaan' => $context['biaya_pemeriksaan']);

			$this->db->where('id', $context['pemeriksaan_id'])->update('data_pemeriksaan', $data);

			$i = 0;
			foreach($context['id'] as $key)
			{
				if(in_array($key, $context['checked'])){ $this->tersedia = 'Ya'; } else $this->tersedia = 'Tidak';

				$this->jumlah = $context['jumlah'][$i];

				$query = $this->db->where('id', $key)->update($this->_table_name, $this);

				if(!$query) $this->_error .= '<br> '.$this->mysql_get_error();

				$i++;
			}

			if($this->_error == '')
			{
				$query = $this->db->where('id', $context['pemeriksaan_id'])->update('data_pemeriksaan', ['subtotal_obat' => $context['subtotal_obat'], 'subtotal_tindakan' => $context['subtotal_tindakan'], 'total' => $context['total']]);

				if(!$query) $this->_error .= '<br> '.$this->mysql_get_error();
			}
		}

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function convert_range_tgl($range)
	{
		$split = explode(' - ', $range);

		if(isset($split[0]))
		{
			$tgl['awal'] = substr($split[0],6,4).'-'.substr($split[0],3,2).'-'.substr($split[0],0,2);
		}

		if(isset($split[1]))
		{
			$tgl['akhir'] = substr($split[1],6,4).'-'.substr($split[1],3,2).'-'.substr($split[1],0,2);
		}

		return $tgl;
	}

	//--------------------------------------------------------------------------------------------

	public function mysql_get_error()
	{
		$error = $this->db->error();

		switch ($error['code']) 
		{
			case '1062':
			$error_detail = 'Data sudah ada';
			break;

			default:
			$error_detail = "$error[code]: $error[message]";
			break;
		}

		return $error_detail;		
	}

}	