<?php

class Data_pendaftaran_model extends CI_Model {
	
	private $_error = "";
	private $_table_name = "data_pendaftaran";
	private $_table_sql = "data_pendaftaran d_pen";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);

		$this->db->select('d_pen.*,
			d_pas.*,
			a_d.value AS debitur_value');
		$this->db->from($this->_table_sql);		
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	

		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if(isset($tgl['awal']) && isset($tgl['akhir'])) $this->db->where("d_pen.tgl_daftar BETWEEN '".$tgl['awal']."' AND '".$tgl['akhir']."'");

		$this->db->order_by('d_pen.created_date', 'DESC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$tgl = $this->convert_range_tgl($context['range_tgl']);
		
		$this->db->select('d_pen.*');
		$this->db->from($this->_table_sql);
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');

		if($keyword != "") $this->db->where("d_pas.nama LIKE '%$keyword%'");

		if(isset($tgl['awal']) && isset($tgl['akhir'])) $this->db->where("d_pen.tgl_daftar BETWEEN '".$tgl['awal']."' AND '".$tgl['akhir']."'");

		return $this->db->get()->num_rows();
	}

	public function pendaftaran_hari_ini()
	{		
		$this->db->select('d_pen.*,
			d_pas.*,
			a_d.value AS debitur_value');
		$this->db->from($this->_table_sql);		
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	
		$this->db->where('d_pen.tgl_daftar', date('Y-m-d'));
		$this->db->where('d_pen.status_pemeriksaan', 'Belum');
		$this->db->order_by('d_pen.id');

		return $this->db->get()->result();
	}

	public function pendaftaran_hari_ini_jml()
	{		
		$this->db->select('SUM(if(d_pen.kode_jadwal_praktek="PA",1,0)) AS jadwal_pagi,
			SUM(if(d_pen.kode_jadwal_praktek="SO",1,0)) AS jadwal_sore');
		$this->db->from($this->_table_sql);			
		$this->db->where('d_pen.tgl_daftar', date('Y-m-d'));

		return $this->db->get()->row();
	}

	public function riwayat($context)
	{		
		$no_rm = $context['no_rm'];

		$this->db->select('
			d_pen.*,
			DATE_FORMAT(d_pen.tgl_daftar, "%d-%m-%Y") AS tgl_daftar,
			d_pas.nama,
			d_pas.nik AS pasien_nik,
			');		
		$this->db->from('data_pendaftaran d_pen');
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	
		$this->db->where('d_pas.no_rm', $no_rm); 
		$this->db->order_by('d_pen.created_date', 'DESC');	

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_pen.*,
			a_d.value AS debitur_value,
			d_d.id AS kdDokter');
		$this->db->from($this->_table_sql);
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');
		$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');	
		$this->db->where('d_pen.id', $id);
		
		return $this->db->get()->row();
	}

	public function lihat_data_no_rawat($context)
	{
		$no_rawat = $context['no_rawat'];

		$this->db->select('d_pen.*,
			s_de.satusehat_id AS encounter_satusehat_id,
			s_dc.satusehat_id AS condition_satusehat_id,
			d_pas.nama AS pasien_nama,
			d_pas.nik AS pasien_nik,
			d_pas.no_hp AS pasien_no_hp,
			d_pas.satusehat_id AS pasien_satusehat_id,
			d_d.nama AS dokter_nama,
			d_d.nik AS dokter_nik,
			d_d.satusehat_id AS dokter_satusehat_id,
			a_d.value AS debitur_value,
			s_ml.id AS lokasi_satusehat_id,
			s_ml.description AS lokasi_satusehat_description,
			d_pem.penyerahan_obat_date AS tgl_selesai,
			d_pem.penyerahan_obat_time AS jam_selesai,
			d_pem.bpjs_kdDiag1 AS icd10_id,
			a_i10.value AS icd10_value,
			d_pem.bpjs_sistole AS sistole,
			d_pem.bpjs_diastole AS diastole,
			d_pem.bpjs_beratBadan AS berat_badan,
			d_pem.bpjs_tinggiBadan AS tinggi_badan,
			d_pem.bpjs_respRate AS respirasi_rate,
			d_pem.bpjs_lingkarPerut AS lingkar_perut,
			d_pem.bpjs_heartRate AS heart_rate,
			d_pem.bpjs_nmSadar AS kesadaran,
			d_pem.bpjs_suhu AS suhu,
			d_pem.diet AS diet,
			d_pem.bpjs_anamnesa AS anamnesa,
			s_do.sistole_satusehat,
			s_do.diastole_satusehat,
			s_do.berat_badan_satusehat,
			s_do.tinggi_badan_satusehat,
			s_do.respirasi_rate_satusehat,
			s_do.lingkar_perut_satusehat,
			s_do.heart_rate_satusehat,
			s_do.kesadaran_satusehat,
			s_do.suhu_satusehat');
		$this->db->from($this->_table_sql);
		$this->db->join('data_pemeriksaan d_pem', 'd_pem.pendaftaran_id=d_pen.id', 'left');
		$this->db->join('asset_icd_10 a_i10', 'a_i10.id=d_pem.bpjs_kdDiag1', 'left');
		$this->db->join('asset_debitur a_d', 'a_d.id=d_pen.debitur', 'left');	
		$this->db->join('data_dokter d_d', 'd_d.id=d_pen.dokter', 'left');	
		$this->db->join('data_pasien d_pas', 'd_pas.no_rm=d_pen.no_rm', 'left');
		$this->db->join('satusehat_mapping_lokasi s_ml', 's_ml.name=d_pen.unit', 'left');
		$this->db->join('satusehat_data_encounter s_de', 's_de.no_rawat=d_pen.no_rawat', 'left');
		$this->db->join('satusehat_data_condition s_dc', 's_dc.no_rawat=d_pen.no_rawat', 'left');
		$this->db->join('satusehat_data_observation s_do', 's_do.no_rawat=d_pen.no_rawat', 'left');
		$this->db->where('d_pen.no_rawat', $no_rawat);
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->no_rawat = '';
		$this->no_rm = '';
		$this->tgl_daftar = date('Y-m-d');
		$this->jam_daftar = date('H:i');
		$this->dokter = '';
		$this->nm_dokter = '';
		$this->jadwal_praktek = '';
		$this->kode_jadwal_praktek = '';
		$this->debitur = '';
		$this->nm_debitur = '';
		$this->bpjs_kdProviderPeserta = '';
		$this->bpjs_tglDaftar = '';
		$this->bpjs_noKartu = '';
		$this->bpjs_kdPoli = '001';
		$this->bpjs_nmPoli = '';
		$this->bpjs_keluhan = '';
		$this->bpjs_kunjSakit = 'true';
		$this->bpjs_sistole = '';
		$this->bpjs_diastole = '';
		$this->bpjs_beratBadan = '';
		$this->bpjs_tinggiBadan = '';
		$this->bpjs_respRate = '';
		$this->bpjs_lingkarPerut = '';
		$this->bpjs_heartRate = '';
		$this->bpjs_suhu = '';
		$this->bpjs_rujukBalik = '';
		$this->bpjs_kdTkp = '10';
		$this->bpjs_nmTkp = '';
		$this->bpjs_noUrut = '';
		$this->status_kirim_bpjs = '';

		return $this;
	}

	public function add_update($context)
	{
		$this->no_rm = $context['no_rm'];
		$this->tgl_daftar = $context['tgl_daftar'];
		$this->jam_daftar = $context['jam_daftar'];
		$this->umur = $context['umur'];
		$this->dokter = $context['dokter'];
		$this->nm_dokter = $context['nm_dokter'];
		$this->debitur = $context['debitur'];
		$this->nm_debitur = $context['nm_debitur'];
		$this->jadwal_praktek = $context['jadwal_praktek'];
		$this->kode_jadwal_praktek = $context['kode_jadwal_praktek'];
		$this->bpjs_kdProviderPeserta = $context['bpjs_kdProviderPeserta'];
		$this->bpjs_tglDaftar = substr($context['tgl_daftar'],-2,2).'-'.substr($context['tgl_daftar'],5,2).'-'.substr($context['tgl_daftar'],0,4);
		$this->bpjs_noKartu = $context['bpjs_noKartu'];
		$this->bpjs_kdPoli = $context['bpjs_kdPoli'];
		$this->bpjs_nmPoli = $context['bpjs_nmPoli'];
		$this->bpjs_kunjSakit = $context['bpjs_kunjSakit'];

		if($context['bpjs_keluhan'] != ''){ $this->bpjs_keluhan = $context['bpjs_keluhan']; } else $this->bpjs_keluhan = '-';
		
		if($context['bpjs_sistole'] != ''){ $this->bpjs_sistole = $context['bpjs_sistole']; } else $this->bpjs_sistole = 0;
		
		if($context['bpjs_diastole'] != ''){ $this->bpjs_diastole = $context['bpjs_diastole']; } else $this->bpjs_diastole = 0;
		
		if($context['bpjs_beratBadan'] != ''){ $this->bpjs_beratBadan = $context['bpjs_beratBadan']; } else $this->bpjs_beratBadan = 0;
		
		if($context['bpjs_tinggiBadan'] != ''){ $this->bpjs_tinggiBadan = $context['bpjs_tinggiBadan']; } else $this->bpjs_tinggiBadan = 0;
		
		if($context['bpjs_respRate'] != ''){ $this->bpjs_respRate = $context['bpjs_respRate']; } else $this->bpjs_respRate = 0;
		
		if($context['bpjs_lingkarPerut'] != ''){ $this->bpjs_lingkarPerut = $context['bpjs_lingkarPerut']; } else $this->bpjs_lingkarPerut = 0;
		
		if($context['bpjs_suhu'] != ''){ $this->bpjs_suhu = $context['bpjs_suhu']; } else $this->bpjs_suhu = 0;

		if($context['bpjs_heartRate'] != ''){ $this->bpjs_heartRate = $context['bpjs_heartRate']; } else $this->bpjs_heartRate = 0;

		$this->bpjs_kdTkp = $context['bpjs_kdTkp'];
		$this->bpjs_nmTkp = $context['bpjs_nmTkp'];
		$this->alergi = $context['alergi'];
		$this->bpjs_rujukBalik = 0;
		$this->petugas_daftar = $this->session->userdata('user_id_'.$this->session->userdata('prefix'));
		$this->nm_petugas_daftar = $this->session->userdata('nama_'.$this->session->userdata('prefix'));

		$cek_data = $this->db->where('tgl_daftar', $context['tgl_daftar'])->where('jadwal_praktek', $context['jadwal_praktek'])->where('no_rm', $context['no_rm'])->get($this->_table_name)->row();

		if(empty($cek_data))
		{
			$last_urut = $this->db->where('tgl_daftar', $context['tgl_daftar'])->where('jadwal_praktek', $context['jadwal_praktek'])->where('dokter', $context['dokter'])->order_by('no_rawat', 'DESC')->get($this->_table_name)->row();

			if(!empty($last_urut))
			{
				$last_count = intval($last_urut->urut)+1;

				if($last_count < 10){ $this->urut = '00'.$last_count; }
				else if($last_count < 100){ $this->urut = '0'.$last_count; }
				else $this->urut = $last_count; 
			}
			else $this->urut = '001';

			$this->no_rawat = date('Ymd').'/'.$context['dokter'].'/'.$context['kode_jadwal_praktek'].'/'.$this->urut;

			$query = $this->db->insert($this->_table_name, $this);
		}
		else
		{
			$this->no_rawat = $cek_data->no_rawat;

			$query = $this->db->where('no_rawat', $cek_data->no_rawat)->update($this->_table_name, $this);
		}

		if($this->_error == '')
		{
			$this->db->where('no_rm', $context['no_rm'])->update('data_pasien', ['alergi' => $this->alergi]);
			
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil', 'data' => array('no_rawat' => $this->no_rawat) );
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pendaftaran_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function update_status_pcare($no_rawat, $context)
	{
		$this->status_kirim_bpjs = 'Terkirim'; 
		$this->bpjs_noUrut = $context['result']['message'];
		$this->response_bpjs = '['.$context['metaData']['code'].'] '.$context['metaData']['message'];
		$this->send_date = date('Y-m-d H:i:s');

		$query = $this->db->where('no_rawat', $no_rawat)->update($this->_table_name, $this);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pendaftaran_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function status_kirim_antrol($no_rawat, $context)
	{
		$this->date_kirim_antrol = date('Y-m-d H:i:s');
		$this->response_kirim_antrol = '['.$context['metaData']['code'].'] '.$context['metaData']['message'];

		$query = $this->db->where('no_rawat', $no_rawat)->update($this->_table_name, $this);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pendaftaran_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function status_update_antrol($no_rawat, $context)
	{
		$this->date_update_antrol = date('Y-m-d H:i:s');
		$this->response_update_antrol = '['.$context['metaData']['code'].'] '.$context['metaData']['message'];

		$query = $this->db->where('no_rawat', $no_rawat)->update($this->_table_name, $this);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pendaftaran_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function update_status_pemeriksaan($pendaftaran_id, $status)
	{
		$query = $this->db->where('id', $pendaftaran_id)->update($this->_table_name, ['status_pemeriksaan' => $status]);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error();

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Delete data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}

	public function update_no_urut_bpjs($context)
	{
		$tglDaftar = substr($context['tgl_daftar'],-2,2).'-'.substr($context['tgl_daftar'],5,2).'-'.substr($context['tgl_daftar'],0,4);

		$noUrut = $this->db->from('bpjs_pendaftaran_provider')->where('tglDaftar', $tglDaftar)->where('peserta_noKartu', $context['bpjs_noKartu'])->get()->row();

		$this->status_kirim_bpjs = 'Terkirim'; 
		$this->bpjs_noUrut = $noUrut->noUrut;
		$this->response_bpjs = '[401] Peserta sudah di entri di poli yang sama pada hari sama';
		$this->send_date = date('Y-m-d H:i:s');

		$query = $this->db->where('no_rawat', $context['no_rawat'])->update($this->_table_name, $this);

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Update data berhasil');
		}
		else 
		{	
			$notif = array('eror' => 'warning', 'pesan' => $this->_error);
			$this->db->insert('_log_error', ['model' => 'Data_pendaftaran_model', 'detail' => $this->_error]);
		}

		return $notif;
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);		

		if(!$query) $this->_error .= '<br> '.$this->mysql_get_error();

		if($this->_error == '')
		{
			$notif = array('eror' => 'success', 'pesan' => 'Delete data berhasil');
		}
		else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function convert_range_tgl($range)
	{
		$split = explode(' - ', $range);

		if(isset($split[0]))
		{
			$tgl['awal'] = substr($split[0],6,4).'-'.substr($split[0],3,2).'-'.substr($split[0],0,2);
		}

		if(isset($split[1]))
		{
			$tgl['akhir'] = substr($split[1],6,4).'-'.substr($split[1],3,2).'-'.substr($split[1],0,2);
		}

		return $tgl;
	}

	//--------------------------------------------------------------------------------------------

	public function mysql_get_error()
	{
		$error = $this->db->error();

		switch ($error['code']) 
		{
			case '1062':
			$error_detail = 'Data sudah ada';
			break;

			case '1451':
			$error_detail = 'Pasien sudah di periksa. Silakan hapus dulu data pemeriksaan';
			break;
			
			default:
			$error_detail = "$error[code]: $error[message]";
			break;
		}

		return $error_detail;		
	}

}	