<?php

class Data_tindakan_model extends CI_Model {

	private $_table_name = "data_tindakan";
	private $_table_sql = "data_tindakan d_t";

	public function tabel_data($context)
	{		
		$keyword = $context['keyword'];
		$limit = $context['limit'];
		$start = $context['start'];

		$this->db->select('d_t.*, 
			a_kt.value AS kategori_value');
		$this->db->from($this->_table_sql);		
		$this->db->join('asset_kategori_tindakan a_kt', 'a_kt.id=d_t.kategori', 'left');	

		if($keyword != "") $this->db->where("d_t.nama LIKE '%$keyword%'");

		$this->db->order_by('d_t.nama', 'ASC');		
		$this->db->limit($limit, $start);

		return $this->db->get()->result();
	}

	public function jml_data($context)
	{
		$keyword = $context['keyword'];

		$this->db->select('d_t.*');
		$this->db->from($this->_table_sql);

		if($keyword != "") $this->db->where("d_t.nama LIKE '%$keyword%'");

		return $this->db->get()->num_rows();
	}

	public function lihat_data($context)
	{
		$id = $context['id'];

		$this->db->select('d_t.*');
		$this->db->from($this->_table_sql);
		$this->db->where('d_t.id', $id);
		
		return $this->db->get()->row();
	}

	public function tambah_data()
	{
		$this->id = '';
		$this->nama = '';
		$this->kategori = '';
		$this->jasa_sarana = '';
		$this->jasa_dokter = '';
		$this->jasa_perawat = '';
		$this->bhp = '';
		$this->total = '';
		$this->bpjs_pcare_id = '';
		$this->satusehat_id = '';
		$this->status = '';

		return $this;
	}

	public function add_data($context)
	{
		if(isset($context['auto_id']))
		{
			$last_id = $this->db->order_by('id', 'DESC')->limit(1)->get($this->_table_sql)->row();

			if(!empty($last_id))
			{
				$last_count = intval(substr($last_id->id, 1))+1;

				if($last_count < 10){ $this->id = 'T000'.$last_count; }
				else if($last_count < 100){ $this->id = 'T00'.$last_count; }
				else if($last_count < 1000){ $this->id = 'T0'.$last_count; }
				else if($last_count < 10000){ $this->id = 'T'.$last_count; }
			}
			else $this->id = 'A0001';
		} 
		else $this->id = $context['id'];

		$this->nama = $context['nama'];
		$this->kategori = $context['kategori'];
		$this->jasa_sarana = $context['jasa_sarana'];
		$this->jasa_dokter = $context['jasa_dokter'];
		$this->jasa_perawat = $context['jasa_perawat'];
		$this->total = $context['jasa_sarana']+$context['jasa_dokter']+$context['jasa_perawat']+$context['bhp'];
		$this->status =  $context['status'];
		$this->created_date = date('Y-m-d H:i:s');

		$query = $this->db->insert($this->_table_name, $this);

		return $this->get_notif('Tambah');
	}

	public function update_data($context)
	{		
		$this->id = $context['id'];
		$this->nama = $context['nama'];
		$this->kategori = $context['kategori'];
		$this->jasa_sarana = $context['jasa_sarana'];
		$this->jasa_dokter = $context['jasa_dokter'];
		$this->jasa_perawat = $context['jasa_perawat'];
		$this->bhp = $context['bhp'];
		$this->total = $context['jasa_sarana']+$context['jasa_dokter']+$context['jasa_perawat']+$context['bhp'];
		$this->status =  $context['status'];

		$query = $this->db->where('id', $context['id_old'])->update($this->_table_name, $this);	

		return $this->get_notif('Update');
	}

	public function delete_data($context)
	{
		$id = $context['id'];

		$query = $this->db->where('id', $id)->delete($this->_table_name);		

		return $this->get_notif('Hapus');
	}

	//--------------------------------------------------------------------------------------------

	public function select_data_keyword($context)
	{	
		$keyword = $context['keyword'];

		$this->db->select('d_t.id, concat(d_t.nama, " (", a_kt.value, ") Rp ", d_t.total) AS text');
		$this->db->from($this->_table_sql);
		$this->db->join('asset_kategori_tindakan a_kt', 'a_kt.id=d_t.kategori', 'left');	
		$this->db->where('d_t.status', 'Aktif');

		if($keyword != "") $this->db->where("d_t.nama LIKE '%$keyword%'");

		$this->db->order_by('d_t.nama');
		
		return $this->db->get()->result();
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	