<?php

class Mjkn_model extends CI_Model {

	private $_error = "";

	public function token()
	{
		return array(
			"iss" => "SAHABAT KLINIK",
			"aud" => "MITRA KLINIK",
			"iat" => time(),
			"exp" => 36600
		);
	}

	public function generate_token($context)
	{		
		$username = $context['X-Username'];
		$password = $context['X-Password'];

		$pengaturan =  $this->db->get('pengaturan')->row();

		if($username == $pengaturan->bpjs_username_jkn && $password == $pengaturan->bpjs_password_jkn)
		{   		
			$gettoken = $this->enkripsi();

			$response = array(
				'response' => array(
					'token' => $gettoken
				),
				'metadata' => array(
					'message' => 'Ok',
					'code' => 200
				)
			);
		} else {
			$response = array(
				'metadata' => array(
					'message' => 'Username atau Password Tidak Sesuai',
					'code' => 201
				)
			);
		}

		if(empty($response))
		{
			$response = array(
				'metadata' => array(
					'message' => "Maaf Terjadi Kesalahan, Hubungi $pengaturan->no_telp",
					'code' => 201
				)
			);
		}

		return $response;
	}

	public function cek_token($context)
	{	
		$pengaturan =  $this->db->get('pengaturan')->row();

		$token = $context['X-Token'];

		$token_decrypt = $this->deskripsi($token);

		$hari_ini = strtotime(date('Y-m-d H:i:s'));

		if(intval($hari_ini) <= intval($token_decrypt->expired)) 
		{
			$response = '';
		}
		else
		{
			$response = array(
				'metadata' => array(
					'message' => $token_decrypt,
					'code' => 201
				)
			);
		}

		return $response;
	}

	public function ambil_antrian($context)
	{	
		$pengaturan =  $this->db->get('pengaturan')->row();
		$response = array();

		$nomorkartu = $context['nomorkartu'];
		$nik = $context['nik'];
		$kodepoli = $context['kodepoli'];
		$tanggalperiksa = $context['tanggalperiksa'];
		$keluhan = $context['keluhan'];
		$kodedokter = $context['kodedokter'];
		$jampraktek = $context['jampraktek'];
		$norm = $context['norm'];
		$nohp = $context['nohp'];

		if(empty($nomorkartu) or strlen($nomorkartu) < 13)
		{
			$response = array(
				'metadata' => array(
					'message' => 'Maaf Nomor kartu kurang dari 13 Digit',
					'code' => 201
				)
			);
		}
		elseif(empty($nik) or strlen($nik) < 16)
		{
			$response = array(
				'metadata' => array(
					'message' => 'Maaf Nomor Induk Kependudukan kurang dari 16 Digit',
					'code' => 201
				)
			);
		}
		elseif(empty($kodepoli))
		{
			$response = array(
				'metadata' => array(
					'message' => 'Maaf Poli Tujuan Anda Masih Kosong',
					'code' => 201
				)
			);
		}
		elseif(strtotime($tanggalperiksa) < strtotime(date('Y-m-d')) or strtotime($tanggalperiksa) >= strtotime(date('Y-m-d', strtotime('+'.$pengaturan->bpjs_hari_jkn.' day', strtotime(date('Y-m-d'))))))
		{
			$response = array(
				'metadata' => array(
					'message' => 'Maaf pemilihan tanggal hanya boleh '.$pengaturan->bpjs_hari_jkn.' Hari Kedepan dari Hari Sekarang',
					'code' => 201
				)
			);
		}
		else 
		{
			$select_dokter = $this->db->where('id', $kodedokter)->get('data_dokter')->row();

			$tanggal_lahir = new DateTime($context['data_pasien']['tgl_lahir']);
			$tanggal_periksa = new DateTime($tanggalperiksa);

			$pendaftaran['no_rm'] = $context['data_pasien']['no_rm'];
			$pendaftaran['tgl_daftar'] = $tanggalperiksa;
			$pendaftaran['jam_daftar'] = date('H:i:s');
			$pendaftaran['umur'] = $tanggal_periksa->diff($tanggal_lahir)->y." Th ".$tanggal_periksa->diff($tanggal_lahir)->m." Bl ".$tanggal_periksa->diff($tanggal_lahir)->d." Hr";
			$pendaftaran['dokter'] = $kodedokter;
			$pendaftaran['nm_dokter'] = $select_dokter->nama;
			$pendaftaran['debitur'] = 1;
			$pendaftaran['jadwal_praktek'] = $jampraktek;
			$pendaftaran['bpjs_kdProviderPeserta'] = $pengaturan->bpjs_kode_ppk;
			$pendaftaran['bpjs_tglDaftar'] = substr($tanggalperiksa,-2,2).'-'.substr($tanggalperiksa,5,2).'-'.substr($tanggalperiksa,0,4);
			$pendaftaran['bpjs_noKartu'] = $nomorkartu;
			$pendaftaran['bpjs_kdPoli'] = $kodepoli;
			$pendaftaran['bpjs_keluhan'] = $keluhan;

			$date = date_create($pendaftaran['bpjs_tglDaftar']);
			$days = date_format($date,"w");

			switch ($days) 
			{
				case '0':
				if($jampraktek == $select_dokter->senin_pagi) $pendaftaran['kode_jadwal_praktek'] = 'PA';
				if($jampraktek == $select_dokter->senin_sore) $pendaftaran['kode_jadwal_praktek'] = 'SO';
				break;

				case '1':
				if($jampraktek == $select_dokter->selasa_pagi) $pendaftaran['kode_jadwal_praktek'] = 'PA';
				if($jampraktek == $select_dokter->selasa_sore) $pendaftaran['kode_jadwal_praktek'] = 'SO';
				break;

				case '2':
				if($jampraktek == $select_dokter->rabu_pagi) $pendaftaran['kode_jadwal_praktek'] = 'PA';
				if($jampraktek == $select_dokter->rabu_sore) $pendaftaran['kode_jadwal_praktek'] = 'SO';
				break;

				case '3':
				if($jampraktek == $select_dokter->kamis_pagi) $pendaftaran['kode_jadwal_praktek'] = 'PA';
				if($jampraktek == $select_dokter->kamis_sore) $pendaftaran['kode_jadwal_praktek'] = 'SO';
				break;

				case '4':
				if($jampraktek == $select_dokter->kamis_pagi) $pendaftaran['kode_jadwal_praktek'] = 'PA';
				if($jampraktek == $select_dokter->kamis_sore) $pendaftaran['kode_jadwal_praktek'] = 'SO';
				break;

				case '5':
				if($jampraktek == $select_dokter->jumat_pagi) $pendaftaran['kode_jadwal_praktek'] = 'PA';
				if($jampraktek == $select_dokter->jumat_sore) $pendaftaran['kode_jadwal_praktek'] = 'SO';
				break;

				case '6':
				if($jampraktek == $select_dokter->sabtu_pagi) $pendaftaran['kode_jadwal_praktek'] = 'PA';
				if($jampraktek == $select_dokter->sabtu_sore) $pendaftaran['kode_jadwal_praktek'] = 'SO';
				break;

				default:
				$response = array(
					'metadata' => array(
						'message' => 'Maaf jadwal dokter tidak ada',
						'code' => 201
					)
				);
				break;
			}

			$cek_data = $this->db->where('tgl_daftar', $tanggalperiksa)->where('jadwal_praktek', $pendaftaran['jadwal_praktek'])->where('no_rm', $pendaftaran['no_rm'])->get('data_pendaftaran')->row();

			if(empty($cek_data))
			{
				$last_urut = $this->db->where('tgl_daftar', $tanggalperiksa)->where('jadwal_praktek', $pendaftaran['jadwal_praktek'])->where('dokter', $select_dokter->id)->order_by('urut', 'DESC')->get('data_pendaftaran')->row();

				if(!empty($last_urut))
				{
					$last_count = intval($last_urut->urut)+1;

					if($last_count < 10){ $pendaftaran['urut'] = '00'.$last_count; }
					else if($last_count < 100){ $pendaftaran['urut'] = '0'.$last_count; }
					else $pendaftaran['urut'] = $last_count; 
				}
				else $pendaftaran['urut'] = '001';

				$pendaftaran['no_rawat'] = str_replace('-', '', $tanggalperiksa).'/'.$select_dokter->id.'/'.$pendaftaran['kode_jadwal_praktek'].'/'.$pendaftaran['urut']; 

				$query = $this->db->insert('data_pendaftaran', $pendaftaran);

				if(!$query)
				{
					$this->_error .= '<br> '.$this->mysql_get_error();
				}
				else
				{
					$pendaftaran_jkn['no_rawat'] = $pendaftaran['no_rawat'];

					$query = $this->db->insert('data_pendaftaran_jkn', $pendaftaran_jkn);

					if(!$query)
					{
						$this->_error .= '<br> '.$this->mysql_get_error();
					}
					else
					{
						$response = array(
							'response' => array(
								'nomorantrean' => $pendaftaran['urut'],
								'angkaantrean' => intval($pendaftaran['urut']),
								'namapoli' => 'UMUM',
								'sisaantrean' => intval($pendaftaran['urut'])-1,
								'antreanpanggil' => 0,
								'keterangan' => 'Datang 30 Menit sebelum pelayanan, Konfirmasi kehadiran dibagian pendaftaran dengan menunjukan bukti pendaftaran melalui Mobile JKN, Terima Kasih.'
							),
							'metadata' => array(
								'message' => 'Ok',
								'code' => 200
							)
						);
					}
				}
			}
			else
			{
				$response = array(
					'metadata' => array(
						'message' => "Anda sudah terdaftar, datang langsung atau hubungi $pengaturan->no_telp [$this->_error]",
						'code' => 201
					)
				);
			}
		}

		if(empty($response) || $this->_error != '')
		{
			$response = array(
				'metadata' => array(
					'message' => "Maaf Terjadi Kesalahan, Hubungi $pengaturan->no_telp [$this->_error]",
					'code' => 201
				)
			);
		}

		return $response;
	}

	public function status_antrian($context)
	{		
		$this->db->select('
			bpjs_nmPoli,
			GROUP_CONCAT(if(status_pemeriksaan="Belum",urut,null) SEPARATOR ",") AS belum_panggil,
			sum(if(status_pemeriksaan="Belum",1,0)) AS sisa_antrian,			
			sum(if(id!=0,1,0)) AS total_antrian');
		$this->db->from('data_pendaftaran');	
		$this->db->where('tgl_daftar', $context['tanggalperiksa']);	
		$this->db->where('bpjs_kdPoli', $context['kode_poli']);	
		$this->db->group_by('tgl_daftar');

		$query = $this->db->get()->row();

		$sisa_antrian = intval($query->sisa_antrian);
		$total_antrian = intval($query->total_antrian);

		if($query->belum_panggil != '') 
		{
			$antrean_panggil = explode(',', $query->belum_panggil);
		}
		else $antrean_panggil = array(0 => '');

		$response = array(
			'response'  => array(
				'namapoli' => $query->bpjs_nmPoli,
				'totalantrean' => $total_antrian,
				'sisaantrean' => $sisa_antrian,
				'antreanpanggil' => $antrean_panggil[0],
				'keterangan' => ''),
			'metadata' => array(
				'message' => "OK",
				'code' => 200
			)
		);

		return $response;		
	}

	public function sisa_antrian($context)
	{		
		$this->db->select('urut');
		$this->db->from('data_pendaftaran');	
		$this->db->where('tgl_daftar', $context['tanggalperiksa']);	
		$this->db->where('bpjs_kdPoli', $context['kode_poli']);	
		$this->db->where('bpjs_noKartu', $context['nomorkartu_jkn']);

		$pendaftaran = $this->db->get()->row();

		if(empty($pendaftaran))
		{
			$response = array(
				'metadata' => array(
					'message' => "Maaf Peserta belum terdafar / dibatalkan. Silakan daftar kembali",
					'code' => 201
				)
			);
		}
		else
		{
			$this->db->select('
				bpjs_nmPoli,
				GROUP_CONCAT(if(status_pemeriksaan="Belum",urut,null) SEPARATOR ",") AS belum_panggil,
				sum(if(status_pemeriksaan="Belum",1,0)) AS sisa_antrian,			
				sum(if(id!=0,1,0)) AS total_antrian
				');
			$this->db->from('data_pendaftaran');	
			$this->db->where('tgl_daftar', $context['tanggalperiksa']);	
			$this->db->where('bpjs_kdPoli', $context['kode_poli']);	
			$this->db->group_by('tgl_daftar');

			$query = $this->db->get()->row();

			$sisa_antrian = intval($query->sisa_antrian);
			$total_antrian = intval($query->total_antrian);

			if($query->belum_panggil != '') 
			{
				$antrean_panggil = explode(',', $query->belum_panggil);
			}
			else $antrean_panggil = array(0 => '');

			$response = array(
				'response'  => array(
					'nomorantrean' => $pendaftaran->urut,
					'namapoli' => $query->bpjs_nmPoli,
					'sisaantrean' => $sisa_antrian,
					'antreanpanggil' => $antrean_panggil[0],
					'keterangan' => ''),
				'metadata' => array(
					'message' => "OK",
					'code' => 200
				)
			);
		}

		return $response;	
	}

	public function batal_antrian($context)
	{		
		$pengaturan =  $this->db->get('pengaturan')->row();
		$response = array();

		$query = $this->db->where('tgl_daftar', $context['tanggalperiksa'])->where('bpjs_noKartu', $context['nomorkartu'])->where('bpjs_kdPoli', $context['kodepoli'])->get('data_pendaftaran')->row();

		if(!empty($query))
		{
			$delete_pendaftaran = $this->db->where('id', $query->id)->delete('data_pendaftaran');	

			$delete_pendaftaran_jkn = $this->db->where('no_rawat', $query->no_rawat)->delete('data_pendaftaran_jkn');

			$response = array(
				'metadata' => array(
					'message' => "OK",
					'code' => 200
				)
			);
		} 
		else 
			$response = array(
				'metadata' => array(
					'message' => "Maaf Terjadi Kesalahan, Hubungi $pengaturan->no_telp [$this->_error]",
					'code' => 201
				)
			);

		return $response;				
	}

	//-------------------------------------------------------------------------------------------------------------------------

	public function enkripsi()
	{
		ini_set('display_errors', 0);

		$hari_ini = strtotime(date('Y-m-d H:i:s'));
		$expired = strtotime("+24 hours", $hari_ini);

		$token = base64_encode(json_encode([date('s') => $hari_ini, 'expired' => $expired]));

		$enkripsi = base64_encode(openssl_encrypt($token, 'AES-256-CBC', 'kunci123#'));

		return $enkripsi;
	}

	public function deskripsi($token)
	{		
		ini_set('display_errors', 0);

		$deskripsi = json_decode(base64_decode(openssl_decrypt(base64_decode($token), 'AES-256-CBC', 'kunci123#')));

		return $deskripsi;
	}

}	