<?php

class Pengaturan_model extends CI_Model {

	private $_table_name = "pengaturan";
	private $_table_sql = "pengaturan p";

	public function tabel_data()
	{		
		$this->db->select('p.*');
		$this->db->from($this->_table_sql);

		return $this->db->get()->row();
	}

	public function update_pcare($context)
	{
		$this->bpjs_username_pcare = $context['username'];
		$this->bpjs_password_pcare = $context['password'];			

		$query = $this->db->update($this->_table_name, $this);			

		return $this->get_notif('Update');
	}

	public function update_icare($context)
	{
		$this->bpjs_username_icare = $context['username'];
		$this->bpjs_password_icare = $context['password'];			

		$query = $this->db->update($this->_table_name, $this);			

		return $this->get_notif('Update');
	}

	public function update_token_satusehat($context)
	{
		$this->satusehat_access_token = $context['access_token'];
		$this->satusehat_expired_token = date("Y-m-d h:i:s", time() + $context['expires_in']);			

		$query = $this->db->update($this->_table_name, $this);			

		return $this->get_notif('Update');
	}
	
	public function update_data($context)
	{
		$this->nama = $context['nama'];
		$this->singkatan = $context['singkatan'];
		$this->kode_klinik = $context['kode_klinik'];
		$this->kode_lab = $context['kode_lab'];
		$this->kode_farmasi = $context['kode_farmasi'];
		$this->kode_waktu = $context['kode_waktu'];
		$this->last_no_rm = $context['last_no_rm'];
		$this->perusahaan = $context['perusahaan'];
		$this->no_telp = $context['no_telp'];
		$this->alamat = $context['alamat'];
		$this->email = $context['email'];
		$this->footer = $context['footer'];
		$this->bpjs_kode_ppk = $context['bpjs_kode_ppk'];
		$this->bpjs_cons_id = $context['bpjs_cons_id'];
		$this->bpjs_secret_key = $context['bpjs_secret_key'];
		$this->bpjs_user_key = $context['bpjs_user_key'];
		$this->bpjs_username_pcare = $context['bpjs_username_pcare'];
		$this->bpjs_password_pcare = $context['bpjs_password_pcare'];		
		$this->bpjs_url_pcare = $context['bpjs_url_pcare'];		
		$this->bpjs_username_icare = $context['bpjs_username_icare'];
		$this->bpjs_password_icare = $context['bpjs_password_icare'];		
		$this->bpjs_url_pcare = $context['bpjs_url_pcare'];		
		$this->bpjs_username_jkn = $context['bpjs_username_jkn'];
		$this->bpjs_password_jkn = $context['bpjs_password_jkn'];		
		$this->bpjs_hari_jkn = $context['bpjs_hari_jkn'];	
		$this->bpjs_kuota_jkn = $context['bpjs_kuota_jkn'];
		$this->bpjs_url_jkn = $context['bpjs_url_jkn'];
		$this->bpjs_url_antrol = $context['bpjs_url_antrol'];
		$this->satusehat_id = $context['satusehat_id'];	
		$this->satusehat_client_id = $context['satusehat_client_id'];	
		$this->satusehat_secret_key = $context['satusehat_secret_key'];	
		$this->satusehat_kelurahan = $context['satusehat_kelurahan'];	
		$this->satusehat_kecamatan = $context['satusehat_kecamatan'];	
		$this->satusehat_kabupaten = $context['satusehat_kabupaten'];	
		$this->satusehat_propinsi = $context['satusehat_propinsi'];	
		$this->satusehat_kodepos = $context['satusehat_kodepos'];	
		$this->satusehat_rt = $context['satusehat_rt'];	
		$this->satusehat_rw = $context['satusehat_rw'];	
		$this->satusehat_url_auth = $context['satusehat_url_auth'];	
		$this->satusehat_url_fhir = $context['satusehat_url_fhir'];

		$this->prefix = strtolower(str_replace(" ","_",$context['singkatan']));
		
		if(!empty($_FILES['logo_kecil']['name'])) 
		{
			if($context['url_logo_kecil'] != '') unlink($context['url_logo_kecil']);

			$file_name = 'kecil-'.date('Ymd-His');

			$this->url_logo_kecil = $this->_uploadFile('logo_kecil', $file_name);
		}

		if(!empty($_FILES['logo_besar']['name'])) 
		{
			if($context['url_logo_besar'] != '') 
			{
				if(!file_exists($context['url_logo_besar'])) unlink($context['url_logo_besar']);
			}

			$file_name = 'besar-'.date('Ymd-His');

			$this->url_logo_besar = $this->_uploadFile('logo_besar', $file_name);
		}

		if(!empty($_FILES['logo_header']['name'])) 
		{
			if($context['url_logo_header'] != '') 
			{
				if(!file_exists($context['url_logo_header'])) unlink($context['url_logo_header']);
			}

			$file_name = 'besar-'.date('Ymd-His');

			$this->url_logo_header = $this->_uploadFile('logo_header', $file_name);
		}

		$query = $this->db->update($this->_table_name, $this);			

		return $this->get_notif('Update');
	}

	public function update_versi($context)
	{		
		$this->versi = $context['versi'];

		$query = $this->db->update($this->_table_name, $this);	

		return $this->get_notif('Update');
	}

	private function _uploadFile($input, $filename)
	{
		$upload_path = '_asset/img/';

		$config['upload_path'] = $upload_path;
		$config['allowed_types'] = 'jpg|jpeg|png';
		$config['file_name'] = $filename;
		$config['overwrite'] = true;
		$config['max_size'] = 2024; // 10MB

		$this->upload->initialize($config);
		$this->load->library('upload', $config);

		if($this->upload->do_upload($input)) {
			return $upload_path.''.$this->upload->data('file_name');
		} else print_r($this->upload->display_errors());
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'singkatan sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	