<?php

class Satusehat_data_clinical_impression_model extends CI_Model {

	private $_error = "";
	private $_table_name = "satusehat_data_clinical_impression";
	private $_table_sql = "satusehat_data_clinical_impression s_dci";

	public function tabel_data()
	{		
		$this->db->select('s_dci.*');
		$this->db->from($this->_table_sql);		

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{		
		$this->db->select('s_dci.*');
		$this->db->from($this->_table_sql);	 
		$this->db->where('satusehat_id', $context['id']);

		return $this->db->get()->result();
	}

	public function lihat_data_no_rawat($context)
	{		
		$this->db->select('s_dci.*');
		$this->db->from($this->_table_sql);	 
		$this->db->where('no_rawat', $context['no_rawat']);

		return $this->db->get()->result();
	}

	public function update_status($context)
	{
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);

		$notif = $this->get_notif('Update');

		return $notif;
	}

	public function add_update($context)
	{ 
		$this->no_rawat = $context['data']['no_rawat'];
		$this->encounter_satusehat_id = $context['data']['encounter_satusehat_id'];
		$this->tgl_daftar = $context['data']['tgl_daftar'];
		$this->icd10_id = $context['data']['icd10_id'];
		$this->icd10_value = $context['data']['icd10_value'];
		$this->anamnesa = $context['data']['anamnesa'];

		if(isset($context['id'])){ $this->satusehat_id = $context['id']; } else $this->satusehat_id = '-';

		if(isset($context['data']['status_kirim'])){ $this->status_kirim = $context['data']['status_kirim']; } else $this->status_kirim = 'Terkirim';

		if(isset($context['data']['response'])){ $this->response = $context['data']['response']; } else $this->response = '-';

		$cek_data = $this->lihat_data_no_rawat(['no_rawat' => $this->no_rawat]);

		if(empty($cek_data))
		{
			$query = $this->db->insert($this->_table_name, $this);

			if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
		}
		else 
		{
			$query = $this->db->where('no_rawat', $this->no_rawat)->update($this->_table_name, $this);

			if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
		}
		
		if($this->_error != '')
		{
			$notif = array('eror' => 'warning', 'pesan' => $this->_error, 'data' => $context);
		}
		else $notif = array('eror' => 'success', 'pesan' => 'Update data berhasil', 'data' => $context);

		return $notif;
	}
}	