<?php

class Satusehat_data_encounter_model extends CI_Model {

	private $_error = "";
	private $_table_name = "satusehat_data_encounter";
	private $_table_sql = "satusehat_data_encounter s_de";

	public function tabel_data()
	{		
		$this->db->select('s_de.*');
		$this->db->from($this->_table_sql);		

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{		
		$this->db->select('s_de.*');
		$this->db->from($this->_table_sql);	 
		$this->db->where('satusehat_id', $context['id']);

		return $this->db->get()->result();
	}

	public function lihat_data_no_rawat($context)
	{		
		$this->db->select('s_de.*');
		$this->db->from($this->_table_sql);	 
		$this->db->where('no_rawat', $context['no_rawat']);

		return $this->db->get()->result();
	}

	public function update_status($context)
	{
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);

		$notif = $this->get_notif('Update');

		return $notif;
	}

	public function add_update($context)
	{ 
		$pengaturan = $this->db->get('pengaturan')->row();

		$this->no_rawat = $context['data']['no_rawat'];
		$this->tgl_daftar = $context['data']['tgl_daftar'];
		$this->jam_daftar = $context['data']['jam_daftar'];
		$this->tgl_selesai = $context['data']['tgl_selesai'];
		$this->jam_selesai = $context['data']['jam_selesai'];
		$this->kode_waktu = $pengaturan->kode_waktu;
		$this->nama_dokter = $context['data']['dokter_nama'];
		$this->satusehat_id_dokter = $context['data']['dokter_satusehat_id'];
		$this->nama_pasien = $context['data']['pasien_nama'];
		$this->satusehat_id_pasien = $context['data']['pasien_satusehat_id'];
		$this->location_id = $context['data']['lokasi_satusehat_id'];
		$this->organization_id = $pengaturan->satusehat_id;

		if(isset($context['id'])){ $this->satusehat_id = $context['id']; } else $this->satusehat_id = '-';

		if(isset($context['data']['status_kirim'])){ $this->status_kirim = $context['data']['status_kirim']; } else $this->status_kirim = 'Terkirim';

		if(isset($context['data']['response'])){ $this->response = $context['data']['response']; } else $this->response = '-';

		$cek_data = $this->lihat_data_no_rawat(['no_rawat' => $this->no_rawat]);

		if(empty($cek_data))
		{
			$query = $this->db->insert($this->_table_name, $this);

			if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
		}
		else 
		{
			$query = $this->db->where('no_rawat', $this->no_rawat)->update($this->_table_name, $this);

			if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
		}
		
		if($this->_error != '')
		{
			$notif = array('eror' => 'warning', 'pesan' => $this->_error, 'data' => $context);
		}
		else $notif = array('eror' => 'success', 'pesan' => 'Update data berhasil', 'data' => $context);

		return $notif;
	}
}	