<?php

class Satusehat_data_observation_model extends CI_Model {

	private $_error = "";
	private $_table_name = "satusehat_data_observation";
	private $_table_sql = "satusehat_data_observation s_do";

	public function tabel_data()
	{		
		$this->db->select('s_do.*');
		$this->db->from($this->_table_sql);		

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{		
		$this->db->select('s_do.*');
		$this->db->from($this->_table_sql);	 
		$this->db->where('satusehat_id', $context['id']);

		return $this->db->get()->result();
	}

	public function lihat_data_no_rawat($context)
	{		
		$this->db->select('s_do.*');
		$this->db->from($this->_table_sql);	 
		$this->db->where('no_rawat', $context['no_rawat']);

		return $this->db->get()->result();
	}

	public function update_status($context)
	{
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);

		$notif = $this->get_notif('Update');

		return $notif;
	}

	public function add_update($context)
	{  
		$pengaturan = $this->db->get('pengaturan')->row();

		$this->no_rawat = $context['data']['no_rawat'];
		$this->encounter_satusehat_id = $context['data']['encounter_satusehat_id'];
		$this->tgl_daftar = $context['data']['tgl_daftar'];
		$this->jam_daftar = $context['data']['jam_daftar'];
		$this->tgl_selesai = $context['data']['tgl_selesai'];
		$this->jam_selesai = $context['data']['jam_selesai'];
		$this->kode_waktu = $pengaturan->kode_waktu;
		$this->sistole = $context['data']['sistole'];
		$this->diastole = $context['data']['diastole'];
		$this->berat_badan = $context['data']['berat_badan'];
		$this->tinggi_badan = $context['data']['tinggi_badan'];
		$this->respirasi_rate = $context['data']['respirasi_rate'];
		$this->lingkar_perut = $context['data']['lingkar_perut'];
		$this->heart_rate = $context['data']['heart_rate'];
		$this->kesadaran = $context['data']['kesadaran'];
		$this->suhu = $context['data']['suhu'];
		
		if(isset($context['id'])){ $this->satusehat_id = $context['id']; } else $this->satusehat_id = '-';

		if($context['parameter']['code']['display'] == 'Systolic blood pressure') $this->sistole_satusehat = 'Terkirim';

		if($context['parameter']['code']['display'] == 'Diastolic blood pressure') $this->diastole_satusehat = 'Terkirim';

		if($context['parameter']['code']['display'] == 'Body weight') $this->berat_badan_satusehat = 'Terkirim'; 

		if($context['parameter']['code']['display'] == 'Body height') $this->tinggi_badan_satusehat = 'Terkirim';

		if($context['parameter']['code']['display'] == 'Respiratory rate') $this->respirasi_rate_satusehat = 'Terkirim';

		if($context['parameter']['code']['display'] == 'Waist Circumference at umbilicus by Tape measure') $this->lingkar_perut_satusehat = 'Terkirim'; 

		if($context['parameter']['code']['display'] == 'Heart rate') $this->heart_rate_satusehat = 'Terkirim'; 

		if($context['parameter']['code']['display'] == 'ACVPU (Alert Confusion Voice Pain Unresponsive) scale score') $this->kesadaran_satusehat = 'Terkirim'; 

		if($context['parameter']['code']['display'] == 'Body temperature') $this->suhu_satusehat = 'Terkirim';

		if(isset($context['data']['status_kirim'])){ $this->status_kirim = $context['data']['status_kirim']; } else $this->status_kirim = 'Terkirim';

		if(isset($context['data']['response'])){ $this->response = $context['data']['response']; } else $this->response = '-';

		$cek_data = $this->lihat_data_no_rawat(['no_rawat' => $this->no_rawat]);

		if(empty($cek_data))
		{
			$query = $this->db->insert($this->_table_name, $this);

			if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
		}
		else 
		{
			$query = $this->db->where('no_rawat', $this->no_rawat)->update($this->_table_name, $this);

			if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
		}
		
		if($this->_error != '')
		{
			$notif = array('eror' => 'warning', 'pesan' => $this->_error, 'data' => $context);
		}
		else $notif = array('eror' => 'success', 'pesan' => 'Update data berhasil', 'data' => $context);

		return $notif;
	}
}	