<?php

class Satusehat_mapping_lokasi_model extends CI_Model {

	private $_error = "";
	private $_table_name = "satusehat_mapping_lokasi";
	private $_table_sql = "satusehat_mapping_lokasi s_ml";

	public function tabel_data()
	{		
		$this->db->select('s_ml.*');
		$this->db->from($this->_table_sql);		

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{		
		$this->db->select('s_ml.*');
		$this->db->from($this->_table_sql);	 
		$this->db->where('id', $context['id']);

		return $this->db->get()->result();
	}

	public function update_status($context)
	{
		$this->status = $context['status'];

		$query = $this->db->where('id', $context['id'])->update($this->_table_name, $this);

		$notif = $this->get_notif('Update');

		return $notif;
	}

	public function add_update($context)
	{
		if(isset($context['entry']))
		{
			if(!empty($context['entry']))
			{
				foreach ($context['entry'] as $key) 
				{
					$this->id = $key->resource->id;
					$this->name = $key->resource->name;
					$this->description = $key->resource->description;

					if(isset($key->resource->position))
					{						
						$this->position_altitude = $key->resource->position->altitude;
						$this->position_latitude = $key->resource->position->latitude;
						$this->position_longitude = $key->resource->position->longitude;
					}

					$this->status = $key->resource->status;

					$split = explode('/', $key->resource->managingOrganization->reference);

					$this->organization_id = $split[1];

					$cek_data = $this->lihat_data(['id' => $this->id]);

					if(empty($cek_data))
					{
						$query = $this->db->insert($this->_table_name, $this);

						if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
					}
					else 
					{
						$query = $this->db->where('id', $this->id)->update($this->_table_name, $this);

						if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
					}
				} 
			} 
			else $notif = array('eror' => 'warning', 'pesan' => 'Data masih kosong');
		}
		elseif(isset($context['id']))
		{
			$this->id = $context['id'];
			$this->name = $context['name'];
			$this->description = $context['description'];
			$this->position_altitude = $context['position']->altitude;
			$this->position_latitude = $context['position']->latitude;
			$this->position_longitude = $context['position']->longitude;
			$this->status = $context['status'];

			$split = explode('/', $context['managingOrganization']->reference);

			$this->organization_id = $split[1];

			$cek_data = $this->lihat_data(['id' => $this->id]);

			if(empty($cek_data))
			{
				$query = $this->db->insert($this->_table_name, $this);

				if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
			}
			else 
			{
				$query = $this->db->where('id', $this->id)->update($this->_table_name, $this);

				if(!$query) $this->_error .= '<br> '.$this->mysql_get_error(); 
			}

			if($this->_error == '')
			{
				$notif = $this->get_notif('Update');
			}
			else $notif = array('eror' => 'warning', 'pesan' => $this->_error);

		}
		else $notif = array('eror' => 'warning', 'pesan' => 'Belum ada data di SATU SEHAT');

		return $notif;
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}
}	