<?php

class Satusehat_mapping_organisasi_model extends CI_Model {

	private $_table_name = "satusehat_mapping_organisasi";
	private $_table_sql = "satusehat_mapping_organisasi s_mo";

	public function tabel_data()
	{		
		$this->db->select('*');
		$this->db->from($this->_table_name);

		return $this->db->get()->result();
	}

	public function lihat_data($context)
	{
		$id =  $context['id'];

		$this->db->select('*');
		$this->db->from($this->_table_name);
		$this->db->where('id', $id);
		
		return $this->db->get()->row();
	}

	public function add_update($context)
	{
		$this->organization_id = $context['id'];	
		$this->name = $context['name'];	
		$this->coding_code = $context['type'][0]->coding[0]->code;	
		$this->coding_display = $context['type'][0]->coding[0]->display;
		$this->coding_system = $context['type'][0]->coding[0]->system;	
		$this->active = $context['active'];	

		if(empty($this->tabel_data()))
		{
			$query = $this->db->insert($this->_table_name, $this);
		}
		else $query = $this->db->where('organization_id', $this->organization_id)->update($this->_table_name, $this);			

		return $this->get_notif('Tambah');
	}

	//--------------------------------------------------------------------------------------------

	public function get_notif($name_function)
	{
		$eror = $this->db->error();

		if($eror['code'] == 0){
			$notif = array('eror'=>'success', 'pesan'=>$name_function.' data berhasil');
		} else if($eror['code'] == 1062){
			$notif = array('eror'=>'warning', 'pesan'=>'Username sudah terdaftar');
		} else $notif = array('eror'=>'warning', 'pesan'=>"Terjadi kesalahan. Mohon hubungi (septiaputra@gmail.com)<br>$eror[code]: $eror[message]");	

		return $notif;		
	}

}	