<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<form role="form" method="POST" id="form-data" action="<?php echo $url_form ?>">
  <div class="modal-content">
    <div class="modal-header">
      <h4 class="modal-title" id="modal-title"></h4>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-body">
      <div class="form-group">
        <label>Nama <span class="text-red">*</span></label>
        <input type="text" class="form-control form-control-sm" name="value" placeholder="Enter nama" value="<?php echo $data->value ?>" required>
      </div>  
      <div class="form-group">
        <label>Nama Tabel <span class="text-red">*</span></label>
        <input type="text" class="form-control form-control-sm" name="table_name" placeholder="Enter nama tabel" value="<?php echo $data->table_name ?>" required>
      </div> 
      <div class="form-group">
        <label>Status <span class="text-red">*</span></label>
        <select class="form-control form-control-sm" name="status" required> 
          <option value="Aktif" <?php if($data->status == 'Aktif'){ echo 'selected'; } ?>>Aktif</option>
          <option value="Tidak Aktif" <?php if($data->status == 'Tidak Aktif'){ echo 'selected'; } ?>>Tidak Aktif</option>
        </select>     
      </div>
      <p class="text-red"> * Wajib diisi</p>  
    </div>
    <div class="modal-footer">
      <input type="hidden" name="id" value="<?php echo $data->id ?>">
      <input type="hidden" name="table_name_old" value="<?php echo $data->table_name ?>">
      <button type="submit" class="btn btn-primary add_data">Simpan</button>
      <button type="button" class="btn btn-default" data-dismiss="modal" class="close">Batal</button>
    </div>
  </div>
</form>

<script>
  $(document).ready(function(){    
    $('.select2').select2();
  })

  $('#form-data').submit(function(e){
    e.preventDefault();
    $('.add_data').attr('disabled', true);  
    $.ajax({
      type: $('#form-data').attr('method'),
      url: base_url+''+$('#form-data').attr('action'),
      data:new FormData(this),
      processData:false,
      contentType:false,
      cache:false,
      async:false,
      dataType:'json',
      success: function(response){
        notif(response.eror,response.pesan);
        if(response.eror=="success"){
          load_tabel(page_curr);
          $('#modal-data').modal('hide');
        } else $('.add_data').attr('disabled',false);
      },
      error: function (xhr, ajaxOptions, thrownError) {
        console.log(xhr.responseText);
        $('.add_data').attr('disabled',false);
      }  
    });
  })

</script>
