function load_tabel(table_name)
{
  var url_page = controller_url+'/tabel';

  var data = {
    table_name: table_name
  };

  $('input[name=service_aktif]').val(table_name);

  if(data.table_name != null)
  {
    $.ajax({
      url: url_page,
      type: 'POST',
      data: data,
      success: function(response){
        $('#tabel_'+table_name).html(response);
      },
      error: function (xhr, ajaxOptions, thrownError) { 
       console.log(xhr.responseText);
     }
   });
  }
}

function get(data)
{
  $.ajax({
    url: controller_url+'/get',
    type: 'POST',
    data: data,
    success: function(response){ 
      console.log(response);
      $('#tabel_'+data.table_name).html(response);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     console.log(xhr.responseText);
   }
 });
}

function get_update(data)
{
  $.ajax({
    url: controller_url+'/get_update',
    type: 'POST',
    data: data,
    dataType:'json',
    success: function(response){ 
      console.log(response);
      notif(response.eror, response.pesan);
      load_tabel(data.table_name);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     console.log(xhr.responseText);
   }
 });
}

function edit_data(value_array)
{
  switch(value_array.table_name)
  {
    case 'mapping_lokasi':    
    $('#form_'+value_array.table_name+' select[name=kode]').val(value_array.name);
    $('#form_'+value_array.table_name+' input[name=position_latitude]').val(value_array.position_latitude);
    $('#form_'+value_array.table_name+' input[name=position_longitude]').val(value_array.position_longitude);
    $('#form_'+value_array.table_name+' input[name=position_altitude]').val(value_array.position_altitude);
    $('#form_'+value_array.table_name+' select[name=status]').val(value_array.status);
    $('#form_'+value_array.table_name+' input[name=id]').val(value_array.id);
    break;

    case 'mapping_organisasi':    
    $('#form_'+value_array.table_name+' input[name=id]').val(value_array.organization_id);
    $('#form_'+value_array.table_name+' input[name=name]').val(value_array.name);
    $('#form_'+value_array.table_name+' input[name=coding_code]').val(value_array.coding_code);
    $('#form_'+value_array.table_name+' input[name=coding_display]').val(value_array.coding_display);
    $('#form_'+value_array.table_name+' input[name=coding_system]').val(value_array.coding_system);
    $('#form_'+value_array.table_name+' select[name=active]').val(value_array.active);
    break;
  }
}

function hapus_data(value_array)
{
  var pesan = '<table width="100%" class="table table-sm table-striped" style="font-size: 14px">';
  var capcha = Math.floor((Math.random() * 100));

  for(var column in value_array)
  {
    pesan += '<tr><td align="right"><b>'+column.replace('_', ' ')+'</b></td><td width="20px">:</td><td align="left">'+value_array[column]+'</td></tr>';
  }

  pesan += '</table>';

  Swal.fire({
    title: 'Apakah data ini akan dihapus?',
    html: pesan+'<table width="100%"><tr><td width="150px">Ketik angka <br><b>'+capcha+
    '</b></td><td><input type="text" id="kode" class="swal2-input" placeholder="Kode konfirmasi"></td></tr></table>',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Hapus',
    cancelButtonText: 'Batal',
    preConfirm: () => {
      const kode = Swal.getPopup().querySelector('#kode').value
      if (kode != capcha || !kode) {
        Swal.showValidationMessage('Kode konfirmasi salah')
      }
      return { capcha: kode }
    }
  }).then((result) => {
    if(result.value.capcha){
      delete_data(value_array);
    } 
  })
}

function delete_data(value_array)
{  
  var data = {
    id: value_array.id,
    table_name: value_array.table_name,
    status: 'inactive'
  };

  $.ajax({
    url: controller_url+'/delete',
    type: 'POST',
    data: data,
    dataType:'json',
    success: function(response)
    {      
      notif(response.eror, response.pesan);
      load_tabel(value_array.table_name);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      console.log(xhr.responseText);
    }
  });
}
