<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<form role="form" method="POST" id="form-data-2" action="<?php echo $url_form ?>">
  <div class="modal-content">
    <div class="modal-header">
      <h4 class="modal-title" id="modal-title"></h4>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-body">
      <div class="row">
        <div class="col-12 col-sm-12 col-md-12 col-lg-4">
          <div class="form-group">
            <div class="form-check">
              <input class="form-check-input" type="radio" id="radio_spesialis" name="rujukan" value="spesialis" onchange="change_rujukan(this.value)" checked>
              <label class="form-check-label" for="radio_spesialis">Spesialis</label>
            </div>
          </div>
          <table class="table table-sm table-bordered table_rujukan" id="table_spesialis" style="display: none">
            <tr>
              <td style="border-color: blue; padding: 10px">
                <div class="form-group">
                  <label>Kategori</label>
                  <select class="form-control form-control-sm select2_2" name="spesialis" onchange="change_spesialis(this.value)">
                    <option value="" selected hidden disabled>---Pilih Spesialis---</option>
                    <?php foreach ($select_spesialis as $key){ ?>                
                      <option value="<?php echo $key->kdSpesialis ?>"?><?php echo $key->nmSpesialis ?></option>
                    <?php } ?>  
                  </select>
                </div>
                <div class="form-group">
                  <select class="form-control form-control-sm select2_2" name="subspesialis">
                    <option value="" selected hidden disabled>---Pilih Subspesialis---</option>
                  </select>
                </div>
                <div class="form-group">
                  <label>Sarana</label>
                  <select class="form-control form-control-sm select2_2" name="sarana">
                    <option value="0" selected hidden>-</option>
                    <?php foreach ($select_sarana as $key){ ?>                
                      <option value="<?php echo $key->kdSarana ?>"?><?php echo $key->nmSarana ?></option>
                    <?php } ?> 
                  </select>
                </div>
              </td>
            </tr>
          </table>

          <div class="form-group">
            <div class="form-check">
              <input class="form-check-input" type="radio" id="radio_khusus" name="rujukan" value="khusus" onchange="change_rujukan(this.value)">
              <label class="form-check-label" for="radio_khusus">Kondisi Khusus</label> 
            </div> 
          </div>
          <table class="table table-sm table-bordered table_rujukan" id="table_khusus" style="display: none">
            <tr>
              <td style="border-color: blue; padding: 10px">
                <div class="form-group">
                  <label>Kategori</label>
                  <select class="form-control form-control-sm select2_2" name="spesialis_khusus" onchange="change_spesialis_khusus(this.value)">
                    <?php foreach ($select_spesialis_khusus as $key){ ?>                
                      <option value="<?php echo $key->kdKhusus ?>"?><?php echo $key->nmKhusus ?></option>
                    <?php } ?> 
                  </select>
                </div> 
                <div class="form-group" id="subspesialis_khusus">
                  <select class="form-control form-control-sm select2_2" name="subspesialis_khusus">
                    <option value="" selected hidden disabled>---Pilih Subspesialis---</option>
                  </select>
                </div>
                <div class="form-group">
                  <label>Alasan</label>
                  <textarea class="form-control form-control-sm" rows="4" name="catatan"></textarea>
                </div>
              </td>
            </tr>
          </table>
          <div class="form-group"> 
            <label>Tgl. Rencana berkunjung <span class="badge bg-success">BPJS</span></label>
            <div class="input-group input-group-sm">
              <input type="text" class="form-control form-control-sm" name="tglEstRujuk" id="date_tglEstRujuk" data-target="#date_tglEstRujuk" data-toggle="datetimepicker" value="<?php echo date('d-m-Y') ?>"/>
              <div class="input-group-append">
                <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
              </div>
            </div>
          </div>
          <div class="form-group"> 
            <input type="hidden" name="noKartu" value="<?php echo $noKartu ?>">
            <button type="submit" class="btn btn-primary btn_submit"><i class="fas fa-search"></i> Cari Faskes Rujukan</button>
          </div>
        </div>
        <div class="col-12 col-sm-12 col-md-12 col-lg-8">
          <div class="form-group" style="min-height: 100px"> 
           <div  id="result">
           </div>
         </div>
       </div>
     </div>
   </div>
   <div class="modal-footer">
    <button type="button" class="btn btn-sm btn-default" data-dismiss="modal" class="close"><i class="fas fa-times"></i> Batal</button>
  </div>
</div>
</form>

<script>
  $(document).ready(function(){    
    $('.select2_2').select2();
    change_rujukan($('input[name=rujukan]:checked').val());
  })

  $(document).on('mouseup touchend', function (e) {
    var container = $(".bootstrap-datetimepicker-widget");
    if (!container.is(e.target) && container.has(e.target).length === 0) {
      container.hide();
    }
  });

  $('#date_tglEstRujuk').datetimepicker({    
    focusOnShow: true,
    format: 'DD-MM-Y'
  })

  function change_rujukan(value)
  {
    $('.table_rujukan').find('input, select, textarea').attr('disabled', true);
    $('.table_rujukan').find('input, select, textarea').attr('required', false);
    $('input[name=rujukan]').attr('disabled', false);
    $('.table_rujukan').hide();
    $('#table_'+value).show();
    $('#table_'+value).find('input, select, textarea').attr('disabled', false);
    $('#table_'+value).find('input, select, textarea').attr('required', true);
    change_spesialis($('select[name=spesialis]').val());
    change_spesialis_khusus($('select[name=spesialis_khusus]').val());
  }

  function change_spesialis(value)
  { 
    var data = {
      asset: 'subspesialis', 
      kdPoliRujuk: value
    };
    $.ajax({
      url: base_url+'/asset_bpjs/select_2',
      type: 'POST',
      data: data,
      dataType:'json',
      success: function(response){ 
        $('select[name=subspesialis]').html('');
        response.result.forEach(function(value) {  
          $('select[name=subspesialis]')
          .append($("<option></option>")
           .attr("value",value.kdSubSpesialis)
           .text(value.nmSubSpesialis)); 
        });
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        notif('warning', xhr.responseText);
      }
    }); 
  }

  function change_spesialis_khusus(value)
  { 
    if(value == 'THA' || value == 'HEM')
    {
      $('#subspesialis_khusus').show();
      $('#subspesialis_khusus').find('input, select, textarea').attr('disabled', false);
      $('#subspesialis_khusus').find('input, select, textarea').attr('required', true);

      var data = {
        asset: 'subspesialis_khusus', 
        kdPoliRujuk: value
      };
      $.ajax({
        url: base_url+'/asset_bpjs/select_2',
        type: 'POST',
        data: data,
        dataType:'json',
        success: function(response){ 
          $('select[name=subspesialis_khusus]').html('');
          response.result.forEach(function(value) {  
            $('select[name=subspesialis_khusus]')
            .append($("<option></option>")
             .attr("value",value.kdSubSpesialis)
             .text(value.nmSubSpesialis)); 
          });
        },
        error: function (xhr, ajaxOptions, thrownError) { 
          notif('warning', xhr.responseText);
        }
      }); 
    }
    else
    {
      $('#subspesialis_khusus').hide();
      $('#subspesialis_khusus').find('input, select, textarea').attr('disabled', true);
      $('#subspesialis_khusus').find('input, select, textarea').attr('required', false);
    }
  }

  function get_rujukan(kdppk, nmppk)
  {
    var rujukan = $('input[name=rujukan]:checked').val();

    $('.modal').modal('hide');
    $('input[name=bpjs_rujukLanjut_kdppk]').val(kdppk);
    $('input[name=bpjs_rujukLanjut_nmppk]').val(nmppk);
    $('input[name=bpjs_rujukLanjut_tglEstRujuk]').val($('input[name=tglEstRujuk]').val());

    if(rujukan == 'spesialis')
    {
      $('input[name=bpjs_rujukLanjut_SubSpesialis]').val('true');
      $('input[name=bpjs_rujukLanjut_khusus]').val('false');
      $('input[name=bpjs_rujukLanjut_SubSpesialis_kdSubSpesialis1]').val($('select[name=subspesialis] option:selected').val());
      $('input[name=bpjs_rujukLanjut_SubSpesialis_nmSubSpesialis1]').val($('select[name=subspesialis] option:selected').text());
      $('input[name=bpjs_rujukLanjut_SubSpesialis_kdSarana]').val($('select[name=sarana] option:selected').val());
      $('input[name=bpjs_rujukLanjut_SubSpesialis_nmSarana]').val($('select[name=sarana] option:selected').text());
    } 
    else 
    {      
      $('input[name=bpjs_rujukLanjut_SubSpesialis]').val('false');      
      $('input[name=bpjs_rujukLanjut_khusus]').val('true');
      $('input[name=bpjs_rujukLanjut_khusus_kdKhusus]').val($('select[name=spesialis_khusus] option:selected').val());
      $('input[name=bpjs_rujukLanjut_khusus_nmKhusus]').val($('select[name=spesialis_khusus] option:selected').text());
      $('input[name=bpjs_rujukLanjut_khusus_kdSubSpesialis]').val($('select[name=subspesialis_khusus] option:selected').val());
      $('input[name=bpjs_rujukLanjut_khusus_nmSubSpesialis]').val($('select[name=subspesialis_khusus] option:selected').text());

      if($('select[name=subspesialis_khusus] option:selected').val() == '')
      {
        $('input[name=bpjs_rujukLanjut_SubSpesialis_nmSubSpesialis1]').val($('select[name=spesialis_khusus] option:selected').text());
      }
      else $('input[name=bpjs_rujukLanjut_SubSpesialis_nmSubSpesialis1]').val($('select[name=subspesialis_khusus] option:selected').text());
      
      $('input[name=bpjs_rujukLanjut_khusus_catatan]').val($('textarea[name=catatan]').text());
    }
  }

  $('#form-data-2').submit(function(e){
    e.preventDefault();
    $('.btn_submit').attr('disabled', true);  
    $.ajax({
      type: $('#form-data-2').attr('method'),
      url: base_url+''+$('#form-data-2').attr('action'),
      data:new FormData(this),
      processData:false,
      contentType:false,
      cache:false,
      async:false,
      dataType:'json',
      success: function(response){
        notif(response.eror, response.pesan);
        if(response.eror == 'success')
        {
          $('#result').html('<p>Jumlah Faskes Rujukan: '+response.result.count+'</p>');
          var i = 0;
          response.result.list.forEach(function(value){  
            i++;
            $('#result').append('<div class="card"><div class="card-header"><h5>'+i+'. '+value.nmppk+'<a class="btn btn-sm btn-default float-right" onclick="get_rujukan(`'+value.kdppk+'`, `'+value.nmppk+'`)">Pilih</a></h5></div><div class="card-body"><table width="100%"><tr><td>Kode</td><td width="10px" align="center">:</td><td>'+value.kdppk+'</td><td>Kantor Cabang</td><td width="10px" align="center">:</td><td>'+value.nmkc+'</td><td>Kapasitas</td><td width="10px" align="center">:</td><td>'+value.kapasitas+' ('+value.persentase+' %)</td></tr><tr><td>Kelas</td><td width="10px" align="center">:</td><td>'+value.kelas+'</td><td>Jarak</td><td width="10px" align="center">:</td><td>'+parseInt(value.distance)+' meter</td><td>Total Rujukan</td><td width="10px" align="center">:</td><td>'+value.jmlRujuk+'</td></tr><tr><td>Alamat</td><td width="10px" align="center">:</td><td>'+value.alamatPpk+'</td><td>Jadwal</td><td width="10px" align="center">:</td><td rowspan="2" colspan="4" valign="top">'+value.jadwal+'</td></tr><tr><td>Telp.</td><td width="10px" align="center">:</td><td>'+value.telpPpk+'</td></tr></table></div></div>'); 
          });
        } 
        else console.log(response);

        $('.btn_submit').attr('disabled', false);
      },
      error: function (xhr, ajaxOptions, thrownError) {
        notif('warning', xhr.responseText);
        $('.btn_submit').attr('disabled',false);
      }  
    });
  })

</script>
