<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<form role="form" method="POST" id="form-data" action="<?php echo $url_form ?>">
  <div class="modal-content">
    <div class="modal-header">
      <h4 class="modal-title" id="modal-title"></h4>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-body">         
      <div class="form-group">
        <label>Kode <span class="text-red">*</span></label>
        <input type="text" class="form-control form-control-sm" name="kode" placeholder="Enter kode" value="<?php echo $data->kode ?>" required>
      </div>       
      <div class="form-group">
        <label>Nama <span class="text-red">*</span></label>
        <input type="text" class="form-control form-control-sm" name="value" placeholder="Enter nama" value="<?php echo $data->value ?>" required>
      </div>
      <div class="form-group">
        <label>Kategori <span class="text-red">*</span></label>
        <select class="form-control form-control-sm" name="kategori" required> 
          <option value="" selected hidden disabled></option>
          <?php foreach ($select_kategori as $key){ ?>                
            <option value="<?php echo $key->id ?>" <?php if($data->kategori == $key->id){ echo 'selected'; } ?>><?php echo $key->value ?></option>
          <?php } ?>                     
        </select>     
      </div>  
      <div class="form-group">
        <label>Status Tampil <span class="text-red">*</span></label>
        <select class="form-control form-control-sm" name="status" required> 
          <option value="Aktif" <?php if($data->status == 'Aktif'){ echo 'selected'; } ?>>Aktif</option>
          <option value="Tidak Aktif" <?php if($data->status == 'Tidak Aktif'){ echo 'selected'; } ?>>Tidak Aktif</option>
        </select>
      </div>
      <p class="text-red"> * Wajib diisi</p>  
    </div>
    <div class="modal-footer">
      <input type="hidden" name="id" value="<?php echo $data->id ?>">
      <button type="submit" class="btn btn-primary add_data"><i class="fas fa-save"></i> Simpan</button>
      <button type="button" class="btn btn-default" data-dismiss="modal" class="close"><i class="fas fa-times"></i> Batal</button>
    </div>
  </div>
</form>

<script>
  $(document).ready(function(){    
    $('.select2').select2();
  })

  function change_checked(value)
  {
    $('input[name=id]').attr('disabled', value);
    $('input[name=id]').attr('readonly', value);

    if(value == true)
    {
     $('input[name=id]').val('Auto'); 
   } 
   else $('input[name=id]').val('');
 }

 $('#form-data').submit(function(e){
  e.preventDefault();
  $('.add_data').attr('disabled', true);  
  $.ajax({
    type: $('#form-data').attr('method'),
      url: base_url+''+$('#form-data').attr('action'),
    data:new FormData(this),
    processData:false,
    contentType:false,
    cache:false,
    async:false,
    dataType:'json',
    success: function(response){
      notif(response.eror,response.pesan);
      if(response.eror == "success"){
        load_tabel(page_curr);
        $('.modal').modal('hide');
      } else $('.add_data').attr('disabled',false);
    },
    error: function (xhr, ajaxOptions, thrownError) {
      notif('warning', xhr.responseText);
      $('.add_data').attr('disabled',false);
    }  
  });
})

</script>
