<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function split_jadwal($data)
{
  $split = explode("-", $data);

  return $split;
}

$jadwal_senin_pagi = split_jadwal($data->senin_pagi);
$jadwal_senin_sore = split_jadwal($data->senin_sore);
$jadwal_selasa_pagi = split_jadwal($data->selasa_pagi);
$jadwal_selasa_sore = split_jadwal($data->selasa_sore);
$jadwal_rabu_pagi= split_jadwal($data->rabu_pagi);
$jadwal_rabu_sore = split_jadwal($data->rabu_sore);
$jadwal_kamis_pagi = split_jadwal($data->kamis_pagi);
$jadwal_kamis_sore = split_jadwal($data->kamis_sore);
$jadwal_jumat_pagi = split_jadwal($data->jumat_pagi);
$jadwal_jumat_sore = split_jadwal($data->jumat_sore);
$jadwal_sabtu_pagi = split_jadwal($data->sabtu_pagi);
$jadwal_sabtu_sore = split_jadwal($data->sabtu_sore);
$jadwal_minggu_pagi = split_jadwal($data->minggu_pagi);
$jadwal_minggu_sore = split_jadwal($data->minggu_sore);

?>

<form role="form" method="POST" id="form-data" action="<?php echo $url_form ?>">
  <div class="modal-content">
    <div class="modal-header">
      <h4 class="modal-title" id="modal-title"></h4>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-body">
      <div class="row">
        <div class="col-12">
          <div id="jadwal_dokter_bpjs"></div>
        </div>
        <div class="col-12 col-sm-12 col-md-12 col-lg-4">

          <?php if($notif['eror'] == 'warning') echo '<p Style="color:red">'.$notif['pesan'].'</p>'; ?>
          <div class="form-group">
            <label>Kode BPJS</label>
            <select class="form-control form-control-sm" name="bpjs_kdDokter" onchange="change_kode_bpjs(this.value)"> 
              <option value="-" <?php if($data->bpjs_kdDokter == '-'){ echo 'selected'; } ?>>-</option>
              <?php foreach ($select_kode_bpjs as $key){  ?>
                <option value="<?php echo $key['kdDokter'] ?>" <?php if($key['kdDokter'] == $data->bpjs_kdDokter){ echo 'selected'; } ?>><?php echo $key['nmDokter'] ?></option>
              <?php } ?>
            </select>             
            <button type="button" class="btn bg-olive btn-sm float-sm-right" onclick="cek_jadwal_dokter_bpjs()"><i class="fas fa-search"></i> Cek Jadwal Dokter BPJS</button>    
          </div> 
          <div class="form-group">
            <label>ID <span class="text-red">*</span></label>
            <input type="text" class="form-control form-control-sm" name="id" placeholder="Enter kode" value="<?php echo $data->id ?>" required>
          </div>   
          <div class="form-group">
            <label>Nama <span class="text-red">*</span></label>
            <input type="text" class="form-control form-control-sm" name="nama" placeholder="Enter nama" value="<?php echo $data->nama ?>" required>
          </div>     
          <div class="form-group">
            <label>NIK KTP <span class="text-red">*</span></label>
            <input type="text" class="form-control form-control-sm" name="nik" placeholder="Enter nik" value="<?php echo $data->nik ?>" required>
          </div> 
          <?php if($data->id != ''){ ?>
            <div class="form-group">
              <label>Status <span class="text-red">*</span></label>
              <select class="form-control form-control-sm" name="status" required> 
                <option value="Aktif" <?php if($data->status == 'Aktif'){ echo 'selected'; } ?>>Aktif</option>
                <option value="Tidak aktif" <?php if($data->status == 'Tidak aktif'){ echo 'selected'; } ?>>Tidak aktif</option>
              </select>     
            </div> 
          <?php } ?>                 
          <div class="form-group">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text">
                  <input type="checkbox" name="utama" value="1" <?php if($data->utama == 1) echo 'checked' ?>>
                </span>
              </div>
              <input type="text" class="form-control" value="Jadikan dokter utama" readonly>
            </div> 
          </div>
        </div>

        <div class="col-12 col-sm-12 col-md-12 col-lg-8">
          <div class="row">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <div class="form-group">
                <label>Senin</label>
                <table width="100%" class="table table-striped table-sm">
                  <tr>
                    <td>Pagi</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="senin_mulai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_senin_pagi[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="senin_selesai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_senin_pagi[1] ?>"> 
                    </td>
                  </tr>
                  <tr>
                    <td>Sore</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="senin_mulai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_senin_sore[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="senin_selesai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_senin_sore[1] ?>"> 
                    </td>
                  </tr>
                </table> 
              </div> 
            </div> 
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <div class="form-group">
                <label>Selasa</label>
                <table width="100%" class="table table-striped table-sm">
                  <tr>
                    <td>Pagi</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="selasa_mulai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_selasa_pagi[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="selasa_selesai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_selasa_pagi[1] ?>"> 
                    </td>
                  </tr>
                  <tr>
                    <td>Sore</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="selasa_mulai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_selasa_sore[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="selasa_selesai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_selasa_sore[1] ?>"> 
                    </td>
                  </tr>
                </table> 
              </div> 
            </div> 
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <div class="form-group">
                <label>Rabu</label>
                <table width="100%" class="table table-striped table-sm">
                  <tr>
                    <td>Pagi</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="rabu_mulai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_rabu_pagi[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="rabu_selesai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_rabu_pagi[1] ?>"> 
                    </td>
                  </tr>
                  <tr>
                    <td>Sore</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="rabu_mulai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_rabu_sore[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="rabu_selesai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_rabu_sore[1] ?>"> 
                    </td>
                  </tr>
                </table> 
              </div> 
            </div> 
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <div class="form-group">
                <label>Kamis</label>
                <table width="100%" class="table table-striped table-sm">
                  <tr>
                    <td>Pagi</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="kamis_mulai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_kamis_pagi[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="kamis_selesai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_kamis_pagi[1] ?>"> 
                    </td>
                  </tr>
                  <tr>
                    <td>Sore</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="kamis_mulai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_kamis_sore[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="kamis_selesai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_kamis_sore[1] ?>"> 
                    </td>
                  </tr>
                </table> 
              </div> 
            </div> 
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <div class="form-group">
                <label>Jumat</label>
                <table width="100%" class="table table-striped table-sm">
                  <tr>
                    <td>Pagi</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="jumat_mulai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_jumat_pagi[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="jumat_selesai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_jumat_pagi[1] ?>"> 
                    </td>
                  </tr>
                  <tr>
                    <td>Sore</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="jumat_mulai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_jumat_sore[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="jumat_selesai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_jumat_sore[1] ?>"> 
                    </td>
                  </tr>
                </table> 
              </div> 
            </div> 
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <div class="form-group">
                <label>Sabtu</label>
                <table width="100%" class="table table-striped table-sm">
                  <tr>
                    <td>Pagi</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="sabtu_mulai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_sabtu_pagi[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="sabtu_selesai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_sabtu_pagi[1] ?>"> 
                    </td>
                  </tr>
                  <tr>
                    <td>Sore</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="sabtu_mulai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_sabtu_sore[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="sabtu_selesai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_sabtu_sore[1] ?>"> 
                    </td>
                  </tr>
                </table> 
              </div> 
            </div> 
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <div class="form-group">
                <label>Minggu</label>
                <table width="100%" class="table table-striped table-sm">
                  <tr>
                    <td>Pagi</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="minggu_mulai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_minggu_pagi[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="minggu_selesai_pagi" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_minggu_pagi[1] ?>"> 
                    </td>
                  </tr>
                  <tr>
                    <td>Sore</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="minggu_mulai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_minggu_sore[0] ?>">
                    </td>
                    <td width="5px" align="center">sd</td>
                    <td width="45%">
                      <input type="text" class="form-control form-control-sm" name="minggu_selesai_sore" data-inputmask-alias="datetime" data-inputmask-inputformat="HH:ss" value="<?php echo $jadwal_minggu_sore[1] ?>"> 
                    </td>
                  </tr>
                </table> 
              </div> 
            </div>             
          </div>
        </div> 
      </div>
      <div class="modal-footer">
        <table width="100%" class="table table-striped table-sm">
          <tr>
            <td align="left"><span class="text-red" style="text-align: left;"> * Wajib diisi</span></td>
            <td align="right">
              <input type="hidden" name="id_lama" value="<?php echo $data->id ?>">
              <input type="hidden" name="bpjs_nmDokter" value="<?php echo $data->id ?>">
              <button type="submit" class="btn btn-primary add_data"><i class="fas fa-save"></i> Simpan</button>
              <button type="button" class="btn btn-default" data-dismiss="modal" class="close"><i class="fas fa-times"></i> Batal</button>
            </td>
          </tr>
        </table>      
      </div>
    </div>
  </form>

  <script>
    $(document).ready(function(){    
      $('.select2').select2(); 
      change_kode_bpjs($('select[name=bpjs_kdDokter]').val());
    })

    $('input[name=senin_mulai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=senin_mulai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=senin_selesai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=senin_selesai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=selasa_mulai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=selasa_mulai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=selasa_selesai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=selasa_selesai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=rabu_mulai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=rabu_mulai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=rabu_selesai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=rabu_selesai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=kamis_mulai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=kamis_mulai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=kamis_selesai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=kamis_selesai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=jumat_mulai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=jumat_mulai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=jumat_selesai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=jumat_selesai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=sabtu_mulai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=sabtu_mulai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=sabtu_selesai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=sabtu_selesai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=minggu_mulai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=minggu_mulai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=minggu_selesai_pagi]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });
    $('input[name=minggu_selesai_sore]').inputmask('HH:ss', { 'placeholder': 'hh:mm' });

    $('select[name=propinsi]').change(function(){
      select_propinsi($(this).val());
    })

    function change_kode_bpjs(value)
    {
      if(value != '-')
      {
        $('input[name=id]').attr('readonly', true);
        $('input[name=id]').val($('select[name=bpjs_kdDokter] option:selected').val());
        $('input[name=bpjs_nmDokter]').val($('select[name=bpjs_kdDokter] option:selected').text());
      }
      else {
        $('input[name=id]').attr('readonly', false);
        $('input[name=bpjs_nmDokter]').val('-');
      }
    }

    $('#form-data').submit(function(e){
      e.preventDefault();
      $('.add_data').attr('disabled', true);  
      $.ajax({
        type: $('#form-data').attr('method'),
        url: base_url+''+$('#form-data').attr('action'),
        data:new FormData(this),
        processData:false,
        contentType:false,
        cache:false,
        async:false,
        dataType:'json',
        success: function(response){
          notif(response.eror,response.pesan);
          if(response.eror == "success"){
            load_tabel(page_curr);
            $('.modal').modal('hide');
          } else $('.add_data').attr('disabled',false);
        },
        error: function (xhr, ajaxOptions, thrownError) {
          console.log(xhr.responseText);
          $('.add_data').attr('disabled',false);
        }  
      });
    })

  </script>