<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<form role="form" method="POST" id="form-data" action="<?php echo $url_form ?>">
  <div class="modal-content">
    <div class="modal-header">
      <h4 class="modal-title" id="modal-title"></h4>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-body">
      <div class="row">
        <div class="col-12 col-sm-12 col-md-12 col-lg-6">           
          <div class="form-group">
            <label>Kode <span class="text-red">*</span></label>
            <?php if($data->id == ''){ ?>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <input type="checkbox" name="auto_id" onclick="change_checked(this.checked)" value="1" checked ?> 
                  </span>
                </div>
                <input type="text" class="form-control form-control-sm" name="id" placeholder="Enter id" value="Auto" readonly>                
              </div>
            <?php } else { ?>
              <input type="text" class="form-control form-control-sm" name="id" placeholder="Enter id" value="<?php echo $data->id ?>" required>
            <?php } ?> 
          </div>       
          <div class="form-group">
            <label>Nama <span class="text-red">*</span></label>
            <input type="text" class="form-control form-control-sm" name="nama" placeholder="Enter name" value="<?php echo $data->nama ?>" required>
          </div>
          <div class="form-group">
            <label>Satuan <span class="text-red">*</span></label>
            <select class="form-control form-control-sm" name="satuan" required> 
              <option value="" selected hidden disabled></option>
              <?php foreach ($select_satuan as $key){ ?>                
                <option value="<?php echo $key->id ?>" <?php if($data->satuan == $key->id){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>                     
            </select>     
          </div>
          <div class="form-group">
            <label>Kategori <span class="text-red">*</span></label>
            <select class="form-control form-control-sm" name="kategori" required> 
              <option value="" selected hidden disabled></option>
              <?php foreach ($select_kategori as $key){ ?>                
                <option value="<?php echo $key->id ?>" <?php if($data->kategori == $key->id){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>                     
            </select>     
          </div> 
          <div class="form-group">
            <label>Jenis <span class="text-red">*</span></label>
            <select class="form-control form-control-sm" name="jenis" required> 
              <option value="" selected hidden disabled></option>
              <?php foreach ($select_jenis as $key){ ?>                
                <option value="<?php echo $key->id ?>" <?php if($data->jenis == $key->id){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>                     
            </select>     
          </div> 
        </div>
        <div class="col-12 col-sm-12 col-md-12 col-lg-6">
          <div class="form-group">
            <label>Harga <span class="text-red">*</span></label>
            <div class="input-group input-group-sm">
              <div class="input-group-prepend">
                <span class="input-group-text">Rp.</span>
              </div>
              <input type="number" min="0" class="form-control form-control-sm" name="harga" placeholder="Enter harga" value="<?php echo $data->harga ?>" required>
            </div>
          </div> 
          <div class="form-group">
            <label>Aturan Pakai</label>
            <input type="text" class="form-control form-control-sm" name="aturan_pakai" placeholder="Enter aturan pakai" value="<?php echo $data->aturan_pakai ?>" required>
          </div>
          <div class="form-group">
            <label>Tersedia <span class="text-red">*</span></label>
            <select class="form-control form-control-sm" name="tersedia" required>               
              <option value="Ya" <?php if($data->tersedia == 'Ya'){ echo 'selected'; } ?>>Ya</option>
              <option value="Tidak" <?php if($data->tersedia == 'Tidak'){ echo 'selected'; } ?>>Tidak</option>                
            </select>     
          </div>         
          <div class="form-group">
            <label>Status Tampil <span class="text-red">*</span></label>
            <select class="form-control form-control-sm" name="status" required> 
              <option value="Aktif" <?php if($data->status == 'Aktif'){ echo 'selected'; } ?>>Aktif</option>
              <option value="Tidak Aktif" <?php if($data->status == 'Tidak Aktif'){ echo 'selected'; } ?>>Tidak Aktif</option>
            </select>     
          </div>
        </div>
      </div>
      <p class="text-red"> * Wajib diisi</p>  
    </div>
    <div class="modal-footer">
      <input type="hidden" name="id_old" value="<?php echo $data->id ?>">
      <button type="submit" class="btn btn-primary add_data"><i class="fas fa-save"></i> Simpan</button>
      <button type="button" class="btn btn-default" data-dismiss="modal" class="close"><i class="fas fa-times"></i> Batal</button>
    </div>
  </div>
</form>

<script>
  $(document).ready(function(){    
    $('.select2').select2();
  })

  function change_checked(value)
  {
    $('input[name=id]').attr('disabled', value);
    $('input[name=id]').attr('readonly', value);

    if(value == true)
    {
     $('input[name=id]').val('Auto'); 
   } 
   else $('input[name=id]').val('');
 }

 $('#form-data').submit(function(e){
  e.preventDefault();
  $('.add_data').attr('disabled', true);  
  $.ajax({
    type: $('#form-data').attr('method'),
    url: base_url+''+$('#form-data').attr('action'),
    data:new FormData(this),
    processData:false,
    contentType:false,
    cache:false,
    async:false,
    dataType:'json',
    success: function(response){
      notif(response.eror,response.pesan);
      if(response.eror == "success"){
        load_tabel(page_curr);
        $('.modal').modal('hide');
      } else $('.add_data').attr('disabled',false);
    },
    error: function (xhr, ajaxOptions, thrownError) {
      notif('warning', xhr.responseText);
      $('.add_data').attr('disabled',false);
    }  
  });
})

</script>
