  $(document).ready(function(){
  load_tabel();
})  

$('.cari_data').keyup(function(){ 
  load_tabel();
});

function load_tabel(url_page)
{
  if(url_page == null) var url_page = controller_url+'/tabel';

  var data = {
    keyword: $('input[name=keyword]').val()
  };

  $.ajax({
    url: url_page,
    type: 'POST',
    data: data,
    success: function(response){    
      $('#content-tabel-1').html(response);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     notif('warning', xhr.responseText);
   }
 });
}

function tambah_data()
{
  $.ajax({
    url: controller_url+'/tambah',
    type: 'POST',
    success: function(response){    
      $('#modal-view-xl').html(response);
      $('#modal-title').html("<i class='fas fa-plus'></i> | Tambah Data");
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     notif('warning', xhr.responseText);
   }
 });
}

function edit_data(no_rm)
{
  var data = {id: no_rm};

  $.ajax({
    url: controller_url+'/edit',
    type: 'POST',
    data: data,
    success: function(response){    
      $('#modal-view-xl').html(response);
      $('#modal-title').html("<i class='fas fa-edit'></i> | Edit Data");
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     notif('warning', xhr.responseText);
   }
 });
}

function salin_data(id)
{
  var data = {id: id};

  $.ajax({
    url: controller_url+'/salin',
    type: 'POST',
    data: data,
    success: function(response){    
      $('#modal-view-xl').html(response);
      $('#modal-title').html("<i class='fas fa-clone'></i> | Salin Data");
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     notif('warning', xhr.responseText);
   }
 });
}

function hapus_data(id, value_1, value_2)
{
  var capcha = Math.floor((Math.random() * 100));

  Swal.fire({
    title: 'Apakah data ini akan dihapus?',
    html: '<strong>'+value_1+'</strong><br>'+value_2+'<br><br><table width="100%"><tr><td width="150px">Ketik angka <br><b>'+capcha+
    '</b></b></td><td width="20px">:</td><td align="left"><input type="text" id="kode" class="swal2-input" placeholder="Kode konfirmasi"></td></tr></table>',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Hapus',
    cancelButtonText: 'Batal',
    preConfirm: () => {
      const kode = Swal.getPopup().querySelector('#kode').value
      if (kode != capcha || !kode) {
        Swal.showValidationMessage('Kode konfirmasi salah')
      }
      return { capcha: kode }
    }
  }).then((result) => {
    if(result.value.capcha){
      delete_data(id);
    } 
  })
}

function delete_data(id)
{  
  var data = {id: id};

  $.ajax({
    url: controller_url+'/delete',
    type: 'POST',
    data: data,
    dataType:'json',
    success: function(response){      
      notif(response.eror,response.pesan);
      load_tabel(page_curr);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      notif('warning', xhr.responseText);
    }
  });
}

function bridging_bpjs_nik(btn)
{
  proses_loading();

  var data = {
    jnsKartu: 'nik',
    keyword: $('input[name=nik]').val()
  };  

  if(data.keyword == '' )
  {
    notif('warning', 'NIK tidak boleh kosong');
  }
  else if(data.keyword.length != 16)
  {
    notif('warning', 'NIK harus 16 karakter');
  }
  else
  {
    $(btn).attr('disabled', true);

    $.ajax({
      url: controller_url+'/bridging_bpjs',
      type: 'POST',
      data: data,
      dataType:'json',
      success: function(response)
      {        
        $(btn).attr('disabled', false);

        if(response.eror == "success")
        {
          var detail = '<table width="100%" class="table table-sm table-striped" style="font-size: 16px">';
          detail += '<tr><td align="right"><b>Status</b></td><td width="20px">:</td><td align="left"><b>'+response.result.ketAktif+'</b></td></tr>';
          detail += '<tr><td align="right"><b>Nomor Kartu</b></td><td width="20px">:</td><td align="left">'+response.result.noKartu+'</td></tr>';
          detail += '<tr><td align="right"><b>Nama</b></td><td width="20px">:</td><td align="left">'+response.result.nama+'</td></tr>';
          detail += '<tr><td align="right"><b>Nomor HP</b></td><td width="20px">:</td><td align="left">'+response.result.noHP+'</td></tr>';
          detail += '<tr><td align="right"><b>Jenis Kelamin</b></td><td width="20px">:</td><td align="left">'+response.result.sex+'</td></tr>';
          detail += '<tr><td align="right"><b>Tanggal Lahir</b></td><td width="20px">:</td><td align="left">'+response.result.tglLahir+'</td></tr>';
          detail += '<tr><td align="right"><b>Jenis Kelas</b></td><td width="20px">:</td><td align="left">'+response.result.jnsKelas.nama+'</td></tr>';
          detail += '<tr><td align="right"><b>Jenis Peserta</b></td><td width="20px">:</td><td align="left">'+response.result.jnsPeserta.nama+'</td></tr>';
          detail += '<tr><td align="right"><b>FKTP</b></td><td width="20px">:</td><td align="left">'+response.result.kdProviderPst.nmProvider+'</td></tr>';
          detail += '<tr><td align="right"><b>FKTP Gigi</b></td><td width="20px">:</td><td align="left">'+response.result.kdProviderGigi.nmProvider+'</td></tr>';
          detail += '<tr><td align="right"><b>Tunggakan</b></td><td width="20px">:</td><td align="left">'+response.result.tunggakan+'</td></tr>';
          detail += '</table>';
          Swal.fire({
            title: 'Detail Peserta BPJS',
            html: detail,
            showCancelButton: true,
            confirmButtonText: 'OK',
            cancelButtonText: 'Batal',
          }).then((result) => { 
            if(result.value){
              $('input[name=nama]').val(response.result.nama);
              $('input[name=no_bpjs]').val(response.result.noKartu);
              $('input[name=tgl_lahir]').val(response.result.tglLahir);
              $('input[name=no_hp]').val(response.result.noHP);
              $('select[name=jenis_kelamin]').val(response.result.sex);
            }
          })
        } 
        else notif(response.eror, response.pesan);
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        notif('warning', xhr.responseText);
      }
    });
  }
}

function bridging_bpjs_noka(btn)
{
  proses_loading();
  
  var data = {
    jnsKartu: 'noka',
    keyword: $('input[name=no_bpjs]').val()
  };  

  if(data.keyword == '' )
  {
    notif('warning', 'Nomor Kartu tidak boleh kosong');
  }
  else if(data.keyword.length != 13)
  {
    notif('warning', 'Nomor Kartu harus 13 karakter');
  }
  else
  {
    $(btn).attr('disabled', true);

    $.ajax({
      url: controller_url+'/bridging_bpjs',
      type: 'POST',
      data: data,
      dataType:'json',
      success: function(response)
      {                
        $(btn).attr('disabled', false);

        if(response.eror == "success")
        {
          var detail = '<table width="100%" class="table table-sm table-striped"  style="font-size: 16px">';
          detail += '<tr><td align="right"><b>Status</b></td><td width="20px">:</td><td align="left"><b>'+response.result.ketAktif+'</b></td></tr>';
          detail += '<tr><td align="right"><b>NIK</b></td><td width="20px">:</td><td align="left">'+response.result.noKTP+'</td></tr>';
          detail += '<tr><td align="right"><b>Nama</b></td><td width="20px">:</td><td align="left">'+response.result.nama+'</td></tr>';
          detail += '<tr><td align="right"><b>Nomor HP</b></td><td width="20px">:</td><td align="left">'+response.result.noHP+'</td></tr>';
          detail += '<tr><td align="right"><b>Jenis Kelamin</b></td><td width="20px">:</td><td align="left">'+response.result.sex+'</td></tr>';
          detail += '<tr><td align="right"><b>Tanggal Lahir</b></td><td width="20px">:</td><td align="left">'+response.result.tglLahir+'</td></tr>';
          detail += '<tr><td align="right"><b>Jenis Kelas</b></td><td width="20px">:</td><td align="left">'+response.result.jnsKelas.nama+'</td></tr>';
          detail += '<tr><td align="right"><b>Jenis Peserta</b></td><td width="20px">:</td><td align="left">'+response.result.jnsPeserta.nama+'</td></tr>';
          detail += '<tr><td align="right"><b>FKTP</b></td><td width="20px">:</td><td align="left">'+response.result.kdProviderPst.nmProvider+'</td></tr>';
          detail += '<tr><td align="right"><b>FKTP Gigi</b></td><td width="20px">:</td><td align="left">'+response.result.kdProviderGigi.nmProvider+'</td></tr>';
          detail += '<tr><td align="right"><b>Tunggakan</b></td><td width="20px">:</td><td align="left">'+response.result.tunggakan+'</td></tr>';
          detail += '</table>';
          Swal.fire({
            title: 'Detail Peserta BPJS',
            html: detail,
            showCancelButton: true,
            confirmButtonText: 'OK',
            cancelButtonText: 'Batal',
            allowOutsideClick: false,
          }).then((result) => { 
            if(result.value){
              $('input[name=nama]').val(response.result.nama);
              $('input[name=nik]').val(response.result.noKTP);
              $('input[name=tgl_lahir]').val(response.result.tglLahir);
              $('input[name=no_hp]').val(response.result.noHP);
              $('select[name=jenis_kelamin]').val(response.result.sex);
            }
          })
        } 
        else notif(response.eror, response.pesan);
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        notif('warning', xhr.responseText);
      }
    });
  }
}