<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<form role="form" method="POST" id="form-data" action="<?php echo $url_form ?>">
  <div class="modal-content">
    <div class="modal-header">
      <h4 class="modal-title" id="modal-title"></h4>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-body">
      <div class="row">
        <div class="col-12 col-sm-12 col-md-12 col-lg-4">  
          <div class="form-group">
            <label>Nomor BPJS</label>
            <div class="input-group input-group-sm">                  
              <input type="text" class="form-control form-control-sm" name="no_bpjs" placeholder="Enter no bpjs" value="<?php echo $data->no_bpjs ?>">
              <span class="input-group-append">
                <button type="button" class="btn btn-info btn-flat" id="bpjs_noka" onclick="bridging_bpjs_noka(this)">Ambil data</button>
              </span>
            </div>
          </div>        
          <div class="form-group">
            <label>NIK KTP <span class="text-red">*</span></label>
            <div class="input-group input-group-sm">        
              <input type="text" class="form-control form-control-sm" name="nik" placeholder="Enter nik" value="<?php echo $data->nik ?>" required>
              <span class="input-group-append">
                <button type="button" class="btn btn-success btn-flat" id="bpjs_nik" onclick="bridging_bpjs_nik(this)">Ambil data</button>
              </span>
            </div>
          </div>  
          <div class="form-group">
            <label>No. RM <span class="text-red">*</span></label> 
            <?php if($data->no_rm == ''){ ?>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <input type="checkbox" name="auto_id" onclick="change_checked(this.checked)" value="1" checked ?> 
                  </span>
                </div>
                <input type="text" class="form-control form-control-sm" name="no_rm" placeholder="Enter no rm" value="Auto" readonly>
              </div>
            <?php } else { ?>
              <input type="text" class="form-control form-control-sm" name="no_rm" placeholder="Enter no rm" value="<?php echo $data->no_rm ?>" required>
            <?php } ?>            
          </div>               
          <div class="form-group">
            <label>Nama <span class="text-red">*</span></label>
            <input type="text" class="form-control form-control-sm" name="nama" placeholder="Enter nama" value="<?php echo $data->nama ?>" required>
          </div>      
          <div class="form-group">
            <label>Jenis Kelamin <span class="text-red">*</span></label>
            <select class="form-control form-control-sm" name="jenis_kelamin" required> 
              <option value="L" <?php if($data->jenis_kelamin == 'L'){ echo 'selected'; } ?>>Laki-laki</option>
              <option value="P" <?php if($data->jenis_kelamin == 'P'){ echo 'selected'; } ?>>Perempuan</option>
            </select>     
          </div>
        </div>      

        <div class="col-12 col-sm-12 col-md-12 col-lg-4"> 
          <div class="form-group">
            <label>Tanggal Lahir <span style="color: red">*</span></label> 
            <input type="text" class="form-control form-control-sm" name="tgl_lahir" value="<?php echo $data->tgl_lahir ?>" data-inputmask-alias="datetime" data-inputmask-inputformat="dd-mm-yyyy" data-mask="" im-insert="false" required>
          </div> 
          <div class="form-group">
            <label>Alamat <span class="text-red">*</span></label>
            <textarea class="form-control" name="alamat" rows="2"><?php echo $data->alamat ?></textarea>
          </div>      
          <div class="form-group">
            <label>Nomor HP</label>
            <input type="text" class="form-control form-control-sm" name="no_hp" placeholder="Enter no hp" value="<?php echo $data->no_hp ?>">
          </div>           
          <div class="form-group">
            <label>Alergi</label>
            <input type="text" class="form-control form-control-sm" name="alergi" placeholder="Enter alergi" value="<?php echo $data->alergi ?>">
          </div>              
          <div class="form-group">
            <label>Keterangan Lain</label>
            <input type="text" class="form-control form-control-sm" name="keterangan_lain" placeholder="Enter keterangan lain" value="<?php echo $data->keterangan_lain ?>">
          </div>      
        </div>

        <div class="col-12 col-sm-12 col-md-12 col-lg-4">                
          <div class="form-group">
            <label>Propinsi</label>                   
            <select class="form-control select2" name="propinsi" style="width: 100%;" required>                       
              <option value="-">-</option>
              <?php foreach ($select_propinsi as $key){  ?>
                <option value="<?php echo $key->id ?>" <?php if($key->id == $data->propinsi){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>
            </select>
          </div>
          <div class="form-group">
            <label>Kota/Kab</label>                 
            <select class="form-control select2" name="kabupaten" style="width: 100%;" required>           
              <option value="-">-</option>
              <?php foreach ($select_kabupaten as $key){  ?>
                <option value="<?php echo $key->id ?>"  <?php if($key->id == $data->kabupaten){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>
            </select>
          </div>
          <div class="form-group">
            <label>Kecamatan</label>                   
            <select class="form-control select2" name="kecamatan" style="width: 100%;" required>           
              <option value="-">-</option>
              <?php foreach ($select_kecamatan as $key){  ?>
                <option value="<?php echo $key->id ?>"  <?php if($key->id == $data->kecamatan){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>
            </select>
          </div>
          <div class="form-group">
            <label>Kelurahan</label>                      
            <select class="form-control select2" name="kelurahan" style="width: 100%;" required>           
              <option value="-">-</option>
              <?php foreach ($select_kelurahan as $key){  ?>
                <option value="<?php echo $key->id ?>"  <?php if($key->id == $data->kelurahan){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>
            </select>
          </div>
          <?php if($data->no_rm != ''){ ?>
            <div class="form-group">
              <label>Status <span class="text-red">*</span></label>
              <select class="form-control form-control-sm" name="status" required> 
                <option value="Aktif" <?php if($data->status == 'Aktif'){ echo 'selected'; } ?>>Aktif</option>
                <option value="Tidak Aktif" <?php if($data->status == 'Tidak Aktif'){ echo 'selected'; } ?>>Tidak Aktif</option>
              </select>     
            </div> 
          <?php } ?>
        </div>
      </div>
    </div>
    <div class="modal-footer">
      <table width="100%">
        <tr>
          <td align="left"><span class="text-red" style="text-align: left;"> * Wajib diisi</span></td>
          <td align="right">
            <input type="hidden" name="no_rm_old" value="<?php echo $data->no_rm ?>">
            <button type="submit" class="btn btn-primary add_data"><i class="fas fa-save"></i> Simpan</button>
            <button type="button" class="btn btn-default" data-dismiss="modal" class="close"><i class="fas fa-times"></i> Batal</button>
          </td>
        </tr>
      </table>      
    </div>
  </div>
</form>

<script type="text/javascript">
  $(document).ready(function(){    
    $('.select2').select2();
  })

  function change_checked(value)
  { 
    $('input[name=no_rm]').attr('disabled', value);
    $('input[name=no_rm]').attr('readonly', value);

    if(value == true)
    {
      $('input[name=no_rm]').val('Auto'); 
    } 
    else $('input[name=no_rm]').val('');
  }

  $('input[name=tgl_lahir]').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' });

  $('select[name=propinsi]').change(function(){
    select_propinsi($(this).val());
  })

  function select_propinsi(data){
    $.ajax({
      url: base_url+'wilayah/select_kabupaten/'+data,
      success: function(response){
        $('select[name=kabupaten]').html(response);
        $('select[name=kecamatan]').html('');
        $('select[name=kelurahan]').html('');
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        notif('warning', xhr.responseText);
      } 
    }); 
  }

  $('select[name=kabupaten]').change(function() {
    select_kabupaten($(this).val());
  });

  function select_kabupaten(data){
    $.ajax({
      url: base_url+'wilayah/select_kecamatan/'+data,
      success: function(response){
        $('select[name=kecamatan]').html(response);
        $('select[name=kelurahan]').html('');
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        notif('warning', xhr.responseText);
      } 
    });
  }

  $('select[name=kecamatan]').change(function() {
    select_kecamatan($(this).val());
  });

  function select_kecamatan(data){
    $.ajax({
      url: base_url+'wilayah/select_kelurahan/'+data,
      success: function(response){
        $('select[name=kelurahan]').html(response);
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        notif('warning', xhr.responseText);
      } 
    });
  }

  $('#form-data').submit(function(e){
    e.preventDefault();
    $('.add_data').attr('disabled', true);  
    $.ajax({
      type: $('#form-data').attr('method'),
      url: base_url+''+$('#form-data').attr('action'),
      data:new FormData(this),
      processData:false,
      contentType:false,
      cache:false,
      async:false,
      dataType:'json',
      success: function(response){
        notif(response.eror,response.pesan);
        if(response.eror == "success"){
          load_tabel(page_curr);
          $('.modal').modal('hide');
        } else $('.add_data').attr('disabled',false);
      },
      error: function (xhr, ajaxOptions, thrownError) {
        notif('warning', xhr.responseText);
        $('.add_data').attr('disabled',false);
      }  
    });
  })
</script>