$(document).ready(function(){
  load_tabel();
})  

$('.cari_data').keyup(function(){ 
  load_tabel();
});

$('.cari_data_pasien').keyup(function(){ 
  tabel_pasien();
});

function load_tabel(url_page)
{
  if(url_page == null) var url_page = controller_url+'/tabel';

  var data = {
    range_tgl: $('input[name=range_tgl]').val(),
    status_pemeriksaan: $('select[name=status_pemeriksaan]').val(),
    keyword: $('input[name=keyword]').val()
  };

  $.ajax({
    url: url_page,
    type: 'POST',
    data: data,
    success: function(response){    
      $('#content-box-1').show();  
      $('#content-box-2').hide();
      $('#content-box-2').html('');
      $('#content-tabel-1').html(response);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     console.log(xhr.responseText);
   }
 });
}

const rupiah = (number)=>{
  return new Intl.NumberFormat("id-ID", {
    style: "currency",
    minimumFractionDigits: 0,
    maximumFractionDigits: 0,
    currency: "IDR"
  }).format(number);
}

function tambah_data(no_rawat)
{   
  $('#content-box-1').hide();  
  $('#content-box-2').show();

  var data = {no_rawat: no_rawat};

  $.ajax({
    url: controller_url+'/tambah',
    type: 'POST',
    data: data,
    success: function(response){  
      $('#content-box-2').html(response);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      console.log(xhr.responseText);
    }
  });
}

function edit_data(no_rawat)
{   
  $('#content-box-1').hide();  
  $('#content-box-2').show();

  var data = {no_rawat: no_rawat};

  $.ajax({
    url: controller_url+'/edit',
    type: 'POST',
    data: data,
    success: function(response){  
      $('#content-box-2').html(response);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      console.log(xhr.responseText);
    }
  });
}

function pengaturan_default()
{   
  $('#content-box-1').hide();  
  $('#content-box-2').show();

  $.ajax({
    url: base_url+'pengaturan_pemeriksaan/edit',
    type: 'POST',
    success: function(response){  
      $('#content-box-2').html(response);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      console.log(xhr.responseText);
    }
  });
}

function cari_rujukan()
{
  var data = {noKartu: $('input[name=bpjs_noKartu]').val()};

  $.ajax({
    url: base_url+'/cari_rujukan/',
    type: 'POST',
    data: data,
    success: function(response){    
      $('#modal-view-xl2').html(response);
      $('#modal-title').html("<i class='fas fa-search'></i> | Cari Rujukan");
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     console.log(xhr.responseText);
   }
 });
}

function hapus_data(id, value_1, value_2)
{
  var capcha = Math.floor((Math.random() * 100));

  Swal.fire({
    title: 'Apakah data ini akan dihapus?',
    html: '<strong>'+value_1+'</strong><br>'+value_2+'<br><br><table width="100%"><tr><td width="150px">Ketik angka <br><b>'+capcha+
    '</b></b></td><td width="20px">:</td><td align="left"><input type="text" id="kode" class="swal2-input" placeholder="Kode konfirmasi"></td></tr></table>',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Hapus',
    cancelButtonText: 'Batal',
    preConfirm: () => {
      const kode = Swal.getPopup().querySelector('#kode').value
      if (kode != capcha || !kode) {
        Swal.showValidationMessage('Kode konfirmasi salah')
      }
      return { capcha: kode }
    }
  }).then((result) => {
    if(result.value.capcha){
      delete_data(id);
    } 
  })
}

function delete_data(id)
{  
  var data = {id: id};

  $.ajax({
    url: controller_url+'/delete',
    type: 'POST',
    data: data,
    dataType:'json',
    success: function(response)
    {
      notif(response.eror, response.pesan);

      if(response.eror == 'success')
      {
        load_tabel();
      } 

      console.log(response);

      $('.add_data').attr('disabled',false);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      console.log(xhr.responseText);
    }
  });
}

function batal()
{
  $('#content-box-1').show();  
  $('#content-box-2').hide();
  document.body.scrollTop = 0; // For Safari
  document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
}

function panggil(text)
{
  var data = {
    value: text
  };

  $('.btn').attr('disabled', true);  

  $.ajax({
    url: base_url+'/pemanggil_poli/add',
    type: 'POST',
    data: data,
    dataType:'json',
    success: function(response){
      notif(response.eror, response.pesan);

      setInterval(function()
      {
        $('.btn').attr('disabled', false);
      }, 5000);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      console.log(xhr.responseText);
    }
  });
}